/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi;

import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonDataException;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonEncodingException;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.JsonWriter;
import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import com.microsoft.applicationinsights.agent.shadow.okio.Buffer;
import com.microsoft.applicationinsights.agent.shadow.okio.BufferedSource;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class JsonValueReader
extends JsonReader {
    private static final Object JSON_READER_CLOSED = new Object();
    private Object[] stack;

    JsonValueReader(Object root) {
        this.scopes[this.stackSize] = 7;
        this.stack = new Object[32];
        this.stack[this.stackSize++] = root;
    }

    JsonValueReader(JsonValueReader copyFrom) {
        super(copyFrom);
        this.stack = (Object[])copyFrom.stack.clone();
        for (int i = 0; i < this.stackSize; ++i) {
            if (!(this.stack[i] instanceof JsonIterator)) continue;
            this.stack[i] = ((JsonIterator)this.stack[i]).clone();
        }
    }

    @Override
    public void beginArray() throws IOException {
        List peeked = this.require(List.class, JsonReader.Token.BEGIN_ARRAY);
        JsonIterator iterator = new JsonIterator(JsonReader.Token.END_ARRAY, peeked.toArray(new Object[peeked.size()]), 0);
        this.stack[this.stackSize - 1] = iterator;
        this.scopes[this.stackSize - 1] = 1;
        this.pathIndices[this.stackSize - 1] = 0;
        if (iterator.hasNext()) {
            this.push(iterator.next());
        }
    }

    @Override
    public void endArray() throws IOException {
        JsonIterator peeked = this.require(JsonIterator.class, JsonReader.Token.END_ARRAY);
        if (peeked.endToken != JsonReader.Token.END_ARRAY || peeked.hasNext()) {
            throw this.typeMismatch(peeked, (Object)JsonReader.Token.END_ARRAY);
        }
        this.remove();
    }

    @Override
    public void beginObject() throws IOException {
        Map peeked = this.require(Map.class, JsonReader.Token.BEGIN_OBJECT);
        JsonIterator iterator = new JsonIterator(JsonReader.Token.END_OBJECT, peeked.entrySet().toArray(new Object[peeked.size()]), 0);
        this.stack[this.stackSize - 1] = iterator;
        this.scopes[this.stackSize - 1] = 3;
        if (iterator.hasNext()) {
            this.push(iterator.next());
        }
    }

    @Override
    public void endObject() throws IOException {
        JsonIterator peeked = this.require(JsonIterator.class, JsonReader.Token.END_OBJECT);
        if (peeked.endToken != JsonReader.Token.END_OBJECT || peeked.hasNext()) {
            throw this.typeMismatch(peeked, (Object)JsonReader.Token.END_OBJECT);
        }
        this.pathNames[this.stackSize - 1] = null;
        this.remove();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.stackSize == 0) {
            return false;
        }
        Object peeked = this.stack[this.stackSize - 1];
        return !(peeked instanceof Iterator) || ((Iterator)peeked).hasNext();
    }

    @Override
    public JsonReader.Token peek() throws IOException {
        if (this.stackSize == 0) {
            return JsonReader.Token.END_DOCUMENT;
        }
        Object peeked = this.stack[this.stackSize - 1];
        if (peeked instanceof JsonIterator) {
            return ((JsonIterator)peeked).endToken;
        }
        if (peeked instanceof List) {
            return JsonReader.Token.BEGIN_ARRAY;
        }
        if (peeked instanceof Map) {
            return JsonReader.Token.BEGIN_OBJECT;
        }
        if (peeked instanceof Map.Entry) {
            return JsonReader.Token.NAME;
        }
        if (peeked instanceof String) {
            return JsonReader.Token.STRING;
        }
        if (peeked instanceof Boolean) {
            return JsonReader.Token.BOOLEAN;
        }
        if (peeked instanceof Number) {
            return JsonReader.Token.NUMBER;
        }
        if (peeked == null) {
            return JsonReader.Token.NULL;
        }
        if (peeked == JSON_READER_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw this.typeMismatch(peeked, "a JSON value");
    }

    @Override
    public String nextName() throws IOException {
        Map.Entry peeked = this.require(Map.Entry.class, JsonReader.Token.NAME);
        String result = this.stringKey(peeked);
        this.stack[this.stackSize - 1] = peeked.getValue();
        this.pathNames[this.stackSize - 2] = result;
        return result;
    }

    @Override
    public int selectName(JsonReader.Options options) throws IOException {
        Map.Entry peeked = this.require(Map.Entry.class, JsonReader.Token.NAME);
        String name = this.stringKey(peeked);
        int length = options.strings.length;
        for (int i = 0; i < length; ++i) {
            if (!options.strings[i].equals(name)) continue;
            this.stack[this.stackSize - 1] = peeked.getValue();
            this.pathNames[this.stackSize - 2] = name;
            return i;
        }
        return -1;
    }

    @Override
    public void skipName() throws IOException {
        if (this.failOnUnknown) {
            JsonReader.Token peeked = this.peek();
            this.nextName();
            throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)peeked) + " at " + this.getPath());
        }
        Map.Entry peeked = this.require(Map.Entry.class, JsonReader.Token.NAME);
        this.stack[this.stackSize - 1] = peeked.getValue();
        this.pathNames[this.stackSize - 2] = "null";
    }

    @Override
    public String nextString() throws IOException {
        Object peeked;
        Object object = peeked = this.stackSize != 0 ? this.stack[this.stackSize - 1] : null;
        if (peeked instanceof String) {
            this.remove();
            return (String)peeked;
        }
        if (peeked instanceof Number) {
            this.remove();
            return peeked.toString();
        }
        if (peeked == JSON_READER_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw this.typeMismatch(peeked, (Object)JsonReader.Token.STRING);
    }

    @Override
    public int selectString(JsonReader.Options options) throws IOException {
        Object peeked;
        Object object = peeked = this.stackSize != 0 ? this.stack[this.stackSize - 1] : null;
        if (!(peeked instanceof String)) {
            if (peeked == JSON_READER_CLOSED) {
                throw new IllegalStateException("JsonReader is closed");
            }
            return -1;
        }
        String peekedString = (String)peeked;
        int length = options.strings.length;
        for (int i = 0; i < length; ++i) {
            if (!options.strings[i].equals(peekedString)) continue;
            this.remove();
            return i;
        }
        return -1;
    }

    @Override
    public boolean nextBoolean() throws IOException {
        Boolean peeked = this.require(Boolean.class, JsonReader.Token.BOOLEAN);
        this.remove();
        return peeked;
    }

    @Override
    @Nullable
    public <T> T nextNull() throws IOException {
        this.require(Void.class, JsonReader.Token.NULL);
        this.remove();
        return null;
    }

    @Override
    public double nextDouble() throws IOException {
        double result;
        Object peeked = this.require(Object.class, JsonReader.Token.NUMBER);
        if (peeked instanceof Number) {
            result = ((Number)peeked).doubleValue();
        } else if (peeked instanceof String) {
            try {
                result = Double.parseDouble((String)peeked);
            }
            catch (NumberFormatException e) {
                throw this.typeMismatch(peeked, (Object)JsonReader.Token.NUMBER);
            }
        } else {
            throw this.typeMismatch(peeked, (Object)JsonReader.Token.NUMBER);
        }
        if (!this.lenient && (Double.isNaN(result) || Double.isInfinite(result))) {
            throw new JsonEncodingException("JSON forbids NaN and infinities: " + result + " at path " + this.getPath());
        }
        this.remove();
        return result;
    }

    @Override
    public long nextLong() throws IOException {
        long result;
        Object peeked = this.require(Object.class, JsonReader.Token.NUMBER);
        if (peeked instanceof Number) {
            result = ((Number)peeked).longValue();
        } else if (peeked instanceof String) {
            try {
                result = Long.parseLong((String)peeked);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal asDecimal = new BigDecimal((String)peeked);
                    result = asDecimal.longValueExact();
                }
                catch (NumberFormatException e2) {
                    throw this.typeMismatch(peeked, (Object)JsonReader.Token.NUMBER);
                }
            }
        } else {
            throw this.typeMismatch(peeked, (Object)JsonReader.Token.NUMBER);
        }
        this.remove();
        return result;
    }

    @Override
    public int nextInt() throws IOException {
        int result;
        Object peeked = this.require(Object.class, JsonReader.Token.NUMBER);
        if (peeked instanceof Number) {
            result = ((Number)peeked).intValue();
        } else if (peeked instanceof String) {
            try {
                result = Integer.parseInt((String)peeked);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal asDecimal = new BigDecimal((String)peeked);
                    result = asDecimal.intValueExact();
                }
                catch (NumberFormatException e2) {
                    throw this.typeMismatch(peeked, (Object)JsonReader.Token.NUMBER);
                }
            }
        } else {
            throw this.typeMismatch(peeked, (Object)JsonReader.Token.NUMBER);
        }
        this.remove();
        return result;
    }

    @Override
    public void skipValue() throws IOException {
        Object skipped;
        if (this.failOnUnknown) {
            throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
        }
        if (this.stackSize > 1) {
            this.pathNames[this.stackSize - 2] = "null";
        }
        Object object = skipped = this.stackSize != 0 ? this.stack[this.stackSize - 1] : null;
        if (skipped instanceof JsonIterator) {
            throw new JsonDataException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        if (skipped instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)this.stack[this.stackSize - 1];
            this.stack[this.stackSize - 1] = entry.getValue();
        } else if (this.stackSize > 0) {
            this.remove();
        } else {
            throw new JsonDataException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
    }

    @Override
    public BufferedSource nextSource() throws IOException {
        Object value = this.readJsonValue();
        Buffer result = new Buffer();
        try (JsonWriter jsonWriter = JsonWriter.of(result);){
            jsonWriter.jsonValue(value);
        }
        return result;
    }

    @Override
    public JsonReader peekJson() {
        return new JsonValueReader(this);
    }

    @Override
    public void promoteNameToValue() throws IOException {
        if (this.hasNext()) {
            String name = this.nextName();
            this.push(name);
        }
    }

    @Override
    public void close() throws IOException {
        Arrays.fill(this.stack, 0, this.stackSize, null);
        this.stack[0] = JSON_READER_CLOSED;
        this.scopes[0] = 8;
        this.stackSize = 1;
    }

    private void push(Object newTop) {
        if (this.stackSize == this.stack.length) {
            if (this.stackSize == 256) {
                throw new JsonDataException("Nesting too deep at " + this.getPath());
            }
            this.scopes = Arrays.copyOf(this.scopes, this.scopes.length * 2);
            this.pathNames = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
            this.pathIndices = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
            this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
        }
        this.stack[this.stackSize++] = newTop;
    }

    @Nullable
    private <T> T require(Class<T> type, JsonReader.Token expected) throws IOException {
        Object peeked;
        Object object = peeked = this.stackSize != 0 ? this.stack[this.stackSize - 1] : null;
        if (type.isInstance(peeked)) {
            return type.cast(peeked);
        }
        if (peeked == null && expected == JsonReader.Token.NULL) {
            return null;
        }
        if (peeked == JSON_READER_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw this.typeMismatch(peeked, (Object)expected);
    }

    private String stringKey(Map.Entry<?, ?> entry) {
        Object name = entry.getKey();
        if (name instanceof String) {
            return (String)name;
        }
        throw this.typeMismatch(name, (Object)JsonReader.Token.NAME);
    }

    private void remove() {
        --this.stackSize;
        this.stack[this.stackSize] = null;
        this.scopes[this.stackSize] = 0;
        if (this.stackSize > 0) {
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            Object parent = this.stack[this.stackSize - 1];
            if (parent instanceof Iterator && ((Iterator)parent).hasNext()) {
                this.push(((Iterator)parent).next());
            }
        }
    }

    static final class JsonIterator
    implements Iterator<Object>,
    Cloneable {
        final JsonReader.Token endToken;
        final Object[] array;
        int next;

        JsonIterator(JsonReader.Token endToken, Object[] array, int next) {
            this.endToken = endToken;
            this.array = array;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.array.length;
        }

        @Override
        public Object next() {
            return this.array[this.next++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected JsonIterator clone() {
            return new JsonIterator(this.endToken, this.array, this.next);
        }
    }
}

