/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.ApplicationMetadataFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class DiagnosticsHelper {
    public static final String APPLICATIONINSIGHTS_DIAGNOSTICS_OUTPUT_DIRECTORY = "APPLICATIONINSIGHTS_DIAGNOSTICS_OUTPUT_DIRECTORY";
    static volatile boolean useAppSvcRpIntegrationLogging;
    private static volatile boolean useFunctionsRpIntegrationLogging;
    private static volatile char rpIntegrationChar;
    private static final boolean isWindows;
    public static final String DIAGNOSTICS_LOGGER_NAME = "applicationinsights.extension.diagnostics";
    private static final ApplicationMetadataFactory METADATA_FACTORY;
    public static final String MDC_PROP_OPERATION = "microsoft.ai.operationName";

    private DiagnosticsHelper() {
    }

    public static void setAgentJarFile(Path agentPath) {
        if (Files.exists(agentPath.resolveSibling("appsvc.codeless"), new LinkOption[0])) {
            rpIntegrationChar = "java".equals(System.getenv("FUNCTIONS_WORKER_RUNTIME")) ? (char)102 : (char)97;
            useAppSvcRpIntegrationLogging = true;
        } else if (Files.exists(agentPath.resolveSibling("aks.codeless"), new LinkOption[0])) {
            rpIntegrationChar = (char)107;
        } else if (Files.exists(agentPath.resolveSibling("functions.codeless"), new LinkOption[0])) {
            rpIntegrationChar = (char)102;
            useFunctionsRpIntegrationLogging = true;
        } else if (Files.exists(agentPath.resolveSibling("springcloud.codeless"), new LinkOption[0])) {
            rpIntegrationChar = (char)115;
        }
    }

    public static boolean isRpIntegration() {
        return rpIntegrationChar != '\u0000';
    }

    public static char rpIntegrationChar() {
        return rpIntegrationChar;
    }

    public static boolean useAppSvcRpIntegrationLogging() {
        return useAppSvcRpIntegrationLogging;
    }

    public static boolean useFunctionsRpIntegrationLogging() {
        return useFunctionsRpIntegrationLogging;
    }

    public static ApplicationMetadataFactory getMetadataFactory() {
        return METADATA_FACTORY;
    }

    public static boolean isOsWindows() {
        return isWindows;
    }

    static {
        METADATA_FACTORY = new ApplicationMetadataFactory();
        String osName = System.getProperty("os.name");
        isWindows = osName != null && osName.startsWith("Windows");
    }
}

