/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.bootstrap.diagnostics.status;

import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.ApplicationMetadataFactory;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.DiagnosticsHelper;
import com.microsoft.applicationinsights.agent.bootstrap.diagnostics.DiagnosticsValueFinder;
import com.microsoft.applicationinsights.agent.shadow.com.squareup.moshi.Moshi;
import com.microsoft.applicationinsights.agent.shadow.okio.BufferedSink;
import com.microsoft.applicationinsights.agent.shadow.okio.Okio;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StatusFile {
    private static final List<DiagnosticsValueFinder> VALUE_FINDERS = new ArrayList<DiagnosticsValueFinder>();
    static final Map<String, Object> CONSTANT_VALUES = new ConcurrentHashMap<String, Object>();
    static final String FILENAME_PREFIX = "status";
    static final String FILE_EXTENSION = ".json";
    static final String SITE_LOGDIR_PROPERTY = "site.logdir";
    static final String HOME_ENV_VAR = "HOME";
    static final String DEFAULT_HOME_DIR = ".";
    static final String DEFAULT_LOGDIR = "/LogFiles";
    static final String DEFAULT_APPLICATIONINSIGHTS_LOGDIR = "/ApplicationInsights";
    static final String STATUS_FILE_DIRECTORY = "/status";
    static String logDir;
    static String directory;
    private static final Object lock;
    private static String uniqueId;
    private static BufferedSink buffer;
    private static final ThreadPoolExecutor WRITER_THREAD;

    private static Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setName("StatusFileWriter");
        thread.setDaemon(true);
        return thread;
    }

    static String initLogDir() {
        String siteLogDir = System.getProperty(SITE_LOGDIR_PROPERTY);
        if (siteLogDir != null && !siteLogDir.isEmpty()) {
            return siteLogDir + DEFAULT_APPLICATIONINSIGHTS_LOGDIR;
        }
        String homeDir = System.getenv(HOME_ENV_VAR);
        if (homeDir != null && !homeDir.isEmpty()) {
            return homeDir + DEFAULT_LOGDIR + DEFAULT_APPLICATIONINSIGHTS_LOGDIR;
        }
        return "./LogFiles/ApplicationInsights";
    }

    public static String getLogDir() {
        return logDir;
    }

    private StatusFile() {
    }

    static boolean shouldWrite() {
        return DiagnosticsHelper.useAppSvcRpIntegrationLogging();
    }

    public static <T> void putValueAndWrite(String key, T value) {
        StatusFile.putValueAndWrite(key, value, true);
    }

    public static <T> void putValueAndWrite(String key, T value, boolean loggingInitialized) {
        if (!StatusFile.shouldWrite()) {
            return;
        }
        CONSTANT_VALUES.put(key, value);
        StatusFile.write(loggingInitialized);
    }

    public static <T> void putValue(String key, T value) {
        if (!StatusFile.shouldWrite()) {
            return;
        }
        CONSTANT_VALUES.put(key, value);
    }

    public static void write() {
        StatusFile.write(false);
    }

    private static void write(final boolean loggingInitialized) {
        if (!StatusFile.shouldWrite()) {
            return;
        }
        WRITER_THREAD.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<String, Object> map = StatusFile.getJsonMap();
                String fileName = StatusFile.constructFileName(map);
                Object object = lock;
                synchronized (object) {
                    block11: {
                        Logger logger;
                        File file;
                        block12: {
                            file = new File(directory, fileName);
                            boolean dirsWereCreated = file.getParentFile().mkdirs();
                            Logger logger2 = logger = loggingInitialized ? LoggerFactory.getLogger(StatusFile.class) : null;
                            if (!dirsWereCreated && !file.getParentFile().exists()) break block12;
                            BufferedSink b = null;
                            try {
                                b = StatusFile.getBuffer(file);
                                new Moshi.Builder().build().adapter(Map.class).indent(" ").nullSafe().toJson(b, map);
                                b.flush();
                            }
                            catch (Exception e) {
                                if (logger != null) {
                                    logger.error("Error writing {}", (Object)file.getAbsolutePath(), (Object)e);
                                } else {
                                    e.printStackTrace();
                                }
                                if (b == null) break block11;
                                try {
                                    b.close();
                                    break block11;
                                }
                                catch (IOException iOException) {}
                            }
                            break block11;
                        }
                        if (logger != null) {
                            logger.error("Parent directories for status file could not be created: {}", (Object)file.getAbsolutePath());
                        } else {
                            System.err.println("Parent directories for status file could not be created: " + file.getAbsolutePath());
                        }
                    }
                }
            }
        }, "StatusFileJsonWrite");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedSink getBuffer(File file) throws IOException {
        Object object = lock;
        synchronized (object) {
            if (buffer != null) {
                buffer.close();
            }
            if (DiagnosticsHelper.isOsWindows()) {
                buffer = Okio.buffer(Okio.sink(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
            } else {
                buffer = Okio.buffer(Okio.sink(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
                file.deleteOnExit();
            }
            return buffer;
        }
    }

    static Map<String, Object> getJsonMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(CONSTANT_VALUES);
        for (DiagnosticsValueFinder finder : VALUE_FINDERS) {
            String value = finder.getValue();
            if (value == null || value.isEmpty()) continue;
            map.put(StatusFile.capitalize(finder.getName()), value);
        }
        return map;
    }

    static String constructFileName(Map<String, Object> map) {
        String result = FILENAME_PREFIX;
        String separator = "_";
        if (map.containsKey("MachineName")) {
            result = result + "_" + map.get("MachineName");
        }
        return result + "_" + StatusFile.getUniqueId(map.get("PID")) + FILE_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId(Object pid) {
        Object object = lock;
        synchronized (object) {
            RuntimeMXBean runtimeMxBean;
            if (uniqueId != null) {
                return uniqueId;
            }
            uniqueId = pid != null ? pid.toString() : ((runtimeMxBean = ManagementFactory.getRuntimeMXBean()) != null ? String.valueOf(Math.abs(runtimeMxBean.getStartTime())) : UUID.randomUUID().toString().replace("-", ""));
            return uniqueId;
        }
    }

    private static @Nullable String capitalize(String input) {
        if (input == null) {
            return null;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    static {
        lock = new Object();
        WRITER_THREAD = new ThreadPoolExecutor(1, 1, 750L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), StatusFile::newThread);
        WRITER_THREAD.allowCoreThreadTimeOut(true);
        CONSTANT_VALUES.put("AppType", "java");
        ApplicationMetadataFactory mf = DiagnosticsHelper.getMetadataFactory();
        VALUE_FINDERS.add(mf.getMachineName());
        VALUE_FINDERS.add(mf.getPid());
        VALUE_FINDERS.add(mf.getSdkVersion());
        VALUE_FINDERS.add(mf.getSiteName());
        VALUE_FINDERS.add(mf.getInstrumentationKey());
        VALUE_FINDERS.add(mf.getExtensionVersion());
        logDir = StatusFile.initLogDir();
        directory = logDir + STATUS_FILE_DIRECTORY;
    }
}

