/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

final class AutoSqlSanitizer {
    private static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 2048;
    private static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    private static final int[] ZZ_CMAP_TOP = AutoSqlSanitizer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u0001\u0100\u0001\u0200\u0001\u0300\u0001\u0400\u0001\u0500\u0001\u0600\u0001\u0700\u0001\u0800\u0001\u0900\u0001\u0a00\u0001\u0b00\u0001\u0c00\u0001\u0d00\u0001\u0e00\u0001\u0f00\u0001\u1000\u0001\u1100\u0001\u1200\u0001\u1300\u0001\u1400\u0001\u1100\u0001\u1500\u0001\u1600\u0001\u1700\u0001\u1800\u0001\u1900\u0001\u1a00\u0001\u1b00\u0001\u1c00\u0001\u1100\u0001\u1d00\u0001\u1e00\u0001\u1f00\n\u2000\u0001\u2100\u0001\u2200\u0001\u2300\u0001\u2000\u0001\u2400\u0001\u2500\u0002\u2000\u0019\u1100\u0001\u2600Q\u1100\u0001\u2700\u0004\u1100\u0001\u2800\u0001\u1100\u0001\u2900\u0001\u2a00\u0001\u2b00\u0001\u2c00\u0001\u2d00\u0001\u2e00+\u1100\u0001\u2f00!\u2000\u0001\u1100\u0001\u3000\u0001\u3100\u0001\u1100\u0001\u3200\u0001\u3300\u0001\u3400\u0001\u3500\u0001\u2000\u0001\u3600\u0001\u3700\u0001\u3800\u0001\u3900\u0001\u1100\u0001\u3a00\u0001\u3b00\u0001\u3c00\u0001\u3d00\u0001\u3e00\u0001\u3f00\u0001\u4000\u0001\u2000\u0001\u4100\u0001\u4200\u0001\u4300\u0001\u4400\u0001\u4500\u0001\u4600\u0001\u4700\u0001\u4800\u0001\u4900\u0001\u4a00\u0001\u4b00\u0001\u4c00\u0001\u2000\u0001\u4d00\u0001\u4e00\u0001\u4f00\u0001\u2000\u0003\u1100\u0001\u5000\u0001\u5100\u0001\u5200\n\u2000\u0004\u1100\u0001\u5300\u000f\u2000\u0002\u1100\u0001\u5400!\u2000\u0002\u1100\u0001\u5500\u0001\u5600\u0002\u2000\u0001\u5700\u0001\u5800\u0017\u1100\u0001\u5900\u0002\u1100\u0001\u5a00%\u2000\u0001\u1100\u0001\u5b00\u0001\u5c00\t\u2000\u0001\u5d00\u0017\u2000\u0001\u5e00\u0001\u5f00\u0001\u6000\u0001\u6100\t\u2000\u0001\u6200\u0001\u6300\u0005\u2000\u0001\u6400\u0001\u6500\u0004\u2000\u0001\u6600\u0011\u2000\u00a6\u1100\u0001\u6700\u0010\u1100\u0001\u6800\u0001\u6900\u0015\u1100\u0001\u6a00\u001c\u1100\u0001\u6b00\f\u2000\u0002\u1100\u0001\u6c00\u0e05\u2000";
    private static final int[] ZZ_CMAP_BLOCKS = AutoSqlSanitizer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0012\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\b\u0001\n\u0001\u000b\u0001\f\t\r\u0007\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0015\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0015\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0002\u0015\u0001!\u0002\u0015\u0004\u0000\u0001\u0015\u0001\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0015\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0015\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0002\u0015\u0001!\u0002\u0015/\u0000\u0001\u0015\n\u0000\u0001\u0015\u0004\u0000\u0001\u0015\u0005\u0000\u0017\u0015\u0001\u0000\u001f\u0015\u0001\u00008\u0015\u0002\u0016M\u0015\u0001\u001e\u0142\u0015\u0004\u0000\f\u0015\u000e\u0000\u0005\u0015\u0007\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0081\u0000\u0005\u0015\u0001\u0000\u0002\u0015\u0002\u0000\u0004\u0015\u0001\u0000\u0001\u0015\u0006\u0000\u0001\u0015\u0001\u0000\u0003\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0014\u0015\u0001\u0000S\u0015\u0001\u0000\u008b\u0015\b\u0000\u00a6\u0015\u0001\u0000&\u0015\u0002\u0000\u0001\u0015\u0006\u0000)\u0015G\u0000\u001b\u0015\u0004\u0000\u0004\u0015-\u0000+\u0015#\u0000\u0002\u0015\u0001\u0000c\u0015\u0001\u0000\u0001\u0015\u000f\u0000\u0002\u0015\u0007\u0000\u0002\u0015\n\u0000\u0003\u0015\u0002\u0000\u0001\u0015\u0010\u0000\u0001\u0015\u0001\u0000\u001e\u0015\u001d\u0000Y\u0015\u000b\u0000\u0001\u0015\u0018\u0000!\u0015\t\u0000\u0002\u0015\u0004\u0000\u0001\u0015\u0005\u0000\u0016\u0015\u0004\u0000\u0001\u0015\t\u0000\u0001\u0015\u0003\u0000\u0001\u0015\u0017\u0000\u0019\u0015\u0007\u0000\u000b\u00155\u0000\u0015\u0015\u0001\u0000\b\u0015F\u00006\u0015\u0003\u0000\u0001\u0015\u0012\u0000\u0001\u0015\u0007\u0000\n\u0015\u000f\u0000\u0010\u0015\u0004\u0000\b\u0015\u0002\u0000\u0002\u0015\u0002\u0000\u0016\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0001\u0015\u0003\u0000\u0004\u0015\u0003\u0000\u0001\u0015\u0010\u0000\u0001\u0015\r\u0000\u0002\u0015\u0001\u0000\u0003\u0015\u000e\u0000\u0002\u0015\n\u0000\u0001\u0015\b\u0000\u0006\u0015\u0004\u0000\u0002\u0015\u0002\u0000\u0016\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0002\u0015\u001f\u0000\u0004\u0015\u0001\u0000\u0001\u0015\u0013\u0000\u0003\u0015\u0010\u0000\t\u0015\u0001\u0000\u0003\u0015\u0001\u0000\u0016\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0005\u0015\u0003\u0000\u0001\u0015\u0012\u0000\u0001\u0015\u000f\u0000\u0002\u0015\u0017\u0000\u0001\u0015\u000b\u0000\b\u0015\u0002\u0000\u0002\u0015\u0002\u0000\u0016\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0005\u0015\u0003\u0000\u0001\u0015\u001e\u0000\u0002\u0015\u0001\u0000\u0003\u0015\u000f\u0000\u0001\u0015\u0011\u0000\u0001\u0015\u0001\u0000\u0006\u0015\u0003\u0000\u0003\u0015\u0001\u0000\u0004\u0015\u0003\u0000\u0002\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0002\u0015\u0003\u0000\u0002\u0015\u0003\u0000\u0003\u0015\u0003\u0000\f\u0015\u0016\u0000\u0001\u00154\u0000\b\u0015\u0001\u0000\u0003\u0015\u0001\u0000\u0017\u0015\u0001\u0000\u0010\u0015\u0003\u0000\u0001\u0015\u001a\u0000\u0003\u0015\u0005\u0000\u0002\u0015\u001e\u0000\u0001\u0015\u0004\u0000\b\u0015\u0001\u0000\u0003\u0015\u0001\u0000\u0017\u0015\u0001\u0000\n\u0015\u0001\u0000\u0005\u0015\u0003\u0000\u0001\u0015 \u0000\u0001\u0015\u0001\u0000\u0002\u0015\u000f\u0000\u0002\u0015\u0012\u0000\b\u0015\u0001\u0000\u0003\u0015\u0001\u0000)\u0015\u0002\u0000\u0001\u0015\u0010\u0000\u0001\u0015\u0005\u0000\u0003\u0015\b\u0000\u0003\u0015\u0018\u0000\u0006\u0015\u0005\u0000\u0012\u0015\u0003\u0000\u0018\u0015\u0001\u0000\t\u0015\u0001\u0000\u0001\u0015\u0002\u0000\u0007\u0015:\u00000\u0015\u0001\u0000\u0002\u0015\f\u0000\u0007\u0015:\u0000\u0002\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0005\u0015\u0001\u0000\u0018\u0015\u0001\u0000\u0001\u0015\u0001\u0000\n\u0015\u0001\u0000\u0002\u0015\t\u0000\u0001\u0015\u0002\u0000\u0005\u0015\u0001\u0000\u0001\u0015\u0015\u0000\u0004\u0015 \u0000\u0001\u0015?\u0000\b\u0015\u0001\u0000$\u0015\u001b\u0000\u0005\u0015s\u0000+\u0015\u0014\u0000\u0001\u0015\u0010\u0000\u0006\u0015\u0004\u0000\u0004\u0015\u0003\u0000\u0001\u0015\u0003\u0000\u0002\u0015\u0007\u0000\u0003\u0015\u0004\u0000\r\u0015\f\u0000\u0001\u0015\u0011\u0000&\u0015\u0001\u0000\u0001\u0015\u0005\u0000\u0001\u0015\u0002\u0000+\u0015\u0001\u0000\u014d\u0015\u0001\u0000\u0004\u0015\u0002\u0000\u0007\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0004\u0015\u0002\u0000)\u0015\u0001\u0000\u0004\u0015\u0002\u0000!\u0015\u0001\u0000\u0004\u0015\u0002\u0000\u0007\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0004\u0015\u0002\u0000\u000f\u0015\u0001\u00009\u0015\u0001\u0000\u0004\u0015\u0002\u0000C\u0015%\u0000\u0010\u0015\u0010\u0000V\u0015\u0002\u0000\u0006\u0015\u0003\u0000\u016c\u0015\u0002\u0000\u0011\u0015\u0001\u0000\u001a\u0015\u0005\u0000K\u0015\u0006\u0000\b\u0015\u0007\u0000\r\u0015\u0001\u0000\u0004\u0015\u000e\u0000\u0012\u0015\u000e\u0000\u0012\u0015\u000e\u0000\r\u0015\u0001\u0000\u0003\u0015\u000f\u00004\u0015#\u0000\u0001\u0015\u0004\u0000\u0001\u0015C\u0000Y\u0015\u0007\u0000\u0005\u0015\u0002\u0000\"\u0015\u0001\u0000\u0001\u0015\u0005\u0000F\u0015\n\u0000\u001f\u00151\u0000\u001e\u0015\u0002\u0000\u0005\u0015\u000b\u0000,\u0015\u0004\u0000\u001a\u00156\u0000\u0017\u0015\t\u00005\u0015R\u0000\u0001\u0015]\u0000/\u0015\u0011\u0000\u0007\u00157\u0000\u001e\u0015\r\u0000\u0002\u0015\n\u0000,\u0015\u001a\u0000$\u0015)\u0000\u0003\u0015\n\u0000$\u0015\u0002\u0000\t\u0015\u0007\u0000+\u0015\u0002\u0000\u0003\u0015)\u0000\u0004\u0015\u0001\u0000\u0006\u0015\u0001\u0000\u0002\u0015\u0003\u0000\u0001\u0015\u0005\u0000\u00c0\u0015@\u0000\u0016\u0015\u0002\u0000\u0006\u0015\u0002\u0000&\u0015\u0002\u0000\u0006\u0015\u0002\u0000\b\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u001f\u0015\u0002\u00005\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0001\u0015\u0003\u0000\u0003\u0015\u0001\u0000\u0007\u0015\u0003\u0000\u0004\u0015\u0002\u0000\u0006\u0015\u0004\u0000\r\u0015\u0005\u0000\u0003\u0015\u0001\u0000\u0007\u0015t\u0000\u0001\u0015\r\u0000\u0001\u0015\u0010\u0000\r\u0015e\u0000\u0001\u0015\u0004\u0000\u0001\u0015\u0002\u0000\n\u0015\u0001\u0000\u0001\u0015\u0003\u0000\u0005\u0015\u0006\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0004\u0015\u0001\u0000\u000b\u0015\u0002\u0000\u0004\u0015\u0005\u0000\u0005\u0015\u0004\u0000\u0001\u00154\u0000\u0002\u0015\u017b\u0000/\u0015\u0001\u0000/\u0015\u0001\u0000\u0085\u0015\u0006\u0000\u0004\u0015\u0003\u0000\u0002\u0015\f\u0000&\u0015\u0001\u0000\u0001\u0015\u0005\u0000\u0001\u0015\u0002\u00008\u0015\u0007\u0000\u0001\u0015\u0010\u0000\u0017\u0015\t\u0000\u0007\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0007\u0015P\u0000\u0001\u0015\u00d5\u0000\u0002\u0015*\u0000\u0005\u0015\u0005\u0000\u0002\u0015\u0004\u0000V\u0015\u0006\u0000\u0003\u0015\u0001\u0000Z\u0015\u0001\u0000\u0004\u0015\u0005\u0000+\u0015\u0001\u0000^\u0015\u0011\u0000\u001b\u00155\u0000\u00c6\u0015J\u0000\u00f0\u0015\u0010\u0000\u008d\u0015C\u0000.\u0015\u0002\u0000\r\u0015\u0003\u0000\u0010\u0015\n\u0000\u0002\u0015\u0014\u0000/\u0015\u0010\u0000\u001f\u0015\u0002\u0000F\u00151\u0000\t\u0015\u0002\u0000g\u0015\u0002\u00005\u0015\u0002\u0000\u0005\u00150\u0000\u000b\u0015\u0001\u0000\u0003\u0015\u0001\u0000\u0004\u0015\u0001\u0000\u0017\u0015\u001d\u00004\u0015\u000e\u00002\u0015>\u0000\u0006\u0015\u0003\u0000\u0001\u0015\u0001\u0000\u0002\u0015\u000b\u0000\u001c\u0015\n\u0000\u0017\u0015\u0019\u0000\u001d\u0015\u0007\u0000/\u0015\u001c\u0000\u0001\u0015\u0010\u0000\u0005\u0015\u0001\u0000\n\u0015\n\u0000\u0005\u0015\u0001\u0000)\u0015\u0017\u0000\u0003\u0015\u0001\u0000\b\u0015\u0014\u0000\u0017\u0015\u0003\u0000\u0001\u0015\u0003\u00002\u0015\u0001\u0000\u0001\u0015\u0003\u0000\u0002\u0015\u0002\u0000\u0005\u0015\u0002\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0018\u0000\u0003\u0015\u0002\u0000\u000b\u0015\u0007\u0000\u0003\u0015\f\u0000\u0006\u0015\u0002\u0000\u0006\u0015\u0002\u0000\u0006\u0015\t\u0000\u0007\u0015\u0001\u0000\u0007\u0015\u0001\u0000+\u0015\u0001\u0000\f\u0015\b\u0000s\u0015\u001d\u0000\u00a4\u0015\f\u0000\u0017\u0015\u0004\u00001\u0015\u0004\u0000n\u0015\u0002\u0000j\u0015&\u0000\u0007\u0015\f\u0000\u0005\u0015\u0005\u0000\u0001\u0015\u0001\u0000\n\u0015\u0001\u0000\r\u0015\u0001\u0000\u0005\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0002\u0015\u0001\u0000l\u0015!\u0000k\u0015\u0012\u0000@\u0015\u0002\u00006\u0015(\u0000\f\u0015t\u0000\u0005\u0015\u0001\u0000\u0087\u0015$\u0000\u001a\u0015\u0006\u0000\u001a\u0015\u000b\u0000Y\u0015\u0003\u0000\u0006\u0015\u0002\u0000\u0006\u0015\u0002\u0000\u0006\u0015\u0002\u0000\u0003\u0015#\u0000\f\u0015\u0001\u0000\u001a\u0015\u0001\u0000\u0013\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u000f\u0015\u0002\u0000\u000e\u0015\"\u0000{\u0015\u0085\u0000\u001d\u0015\u0003\u00001\u0015/\u0000 \u0015\r\u0000\u0014\u0015\u0001\u0000\b\u0015\u0006\u0000&\u0015\n\u0000\u001e\u0015\u0002\u0000$\u0015\u0004\u0000\b\u00150\u0000\u009e\u0015\u0012\u0000$\u0015\u0004\u0000$\u0015\u0004\u0000(\u0015\b\u00004\u0015\u009c\u00007\u0015\t\u0000\u0016\u0015\n\u0000\b\u0015\u0098\u0000\u0006\u0015\u0002\u0000\u0001\u0015\u0001\u0000,\u0015\u0001\u0000\u0002\u0015\u0003\u0000\u0001\u0015\u0002\u0000\u0017\u0015\n\u0000\u0017\u0015\t\u0000\u001f\u0015A\u0000\u0013\u0015\u0001\u0000\u0002\u0015\n\u0000\u0016\u0015\n\u0000\u001a\u0015F\u00008\u0015\u0006\u0000\u0002\u0015@\u0000\u0001\u0015\u000f\u0000\u0004\u0015\u0001\u0000\u0003\u0015\u0001\u0000\u001d\u0015*\u0000\u001d\u0015\u0003\u0000\u001d\u0015#\u0000\b\u0015\u0001\u0000\u001c\u0015\u001b\u00006\u0015\n\u0000\u0016\u0015\n\u0000\u0013\u0015\r\u0000\u0012\u0015n\u0000I\u00157\u00003\u0015\r\u00003\u0015\r\u0000$\u0015\u00dc\u0000\u001d\u0015\n\u0000\u0001\u0015\b\u0000\u0016\u0015\u009a\u0000\u0017\u0015\f\u00005\u0015K\u0000-\u0015 \u0000\u0019\u0015\u001a\u0000$\u0015\u001d\u0000\u0001\u0015\u000b\u0000#\u0015\u0003\u0000\u0001\u0015\f\u00000\u0015\u000e\u0000\u0004\u0015\u0015\u0000\u0001\u0015\u0001\u0000\u0001\u0015#\u0000\u0012\u0015\u0001\u0000\u0019\u0015T\u0000\u0007\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0004\u0015\u0001\u0000\u000f\u0015\u0001\u0000\n\u0015\u0007\u0000/\u0015&\u0000\b\u0015\u0002\u0000\u0002\u0015\u0002\u0000\u0016\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0005\u0015\u0003\u0000\u0001\u0015\u0012\u0000\u0001\u0015\f\u0000\u0005\u0015\u009e\u00005\u0015\u0012\u0000\u0004\u0015\u0014\u0000\u0001\u0015 \u00000\u0015\u0014\u0000\u0002\u0015\u0001\u0000\u0001\u0015\u00b8\u0000/\u0015)\u0000\u0004\u0015$\u00000\u0015\u0014\u0000\u0001\u0015;\u0000+\u0015\r\u0000\u0001\u0015G\u0000\u001b\u0015\u00e5\u0000,\u0015t\u0000@\u0015\u001f\u0000\u0001\u0015\u00a0\u0000\b\u0015\u0002\u0000'\u0015\u0010\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u001c\u0000\u0001\u0015\n\u0000(\u0015\u0007\u0000\u0001\u0015\u0015\u0000\u0001\u0015\u000b\u0000.\u0015\u0013\u0000\u0001\u0015\"\u00009\u0015\u0007\u0000\t\u0015\u0001\u0000%\u0015\u0011\u0000\u0001\u00151\u0000\u001e\u0015p\u0000\u0007\u0015\u0001\u0000\u0002\u0015\u0001\u0000&\u0015\u0015\u0000\u0001\u0015\u0019\u0000\u0006\u0015\u0001\u0000\u0002\u0015\u0001\u0000 \u0015\u000e\u0000\u0001\u0015\u0147\u0000\u0013\u0015\r\u0000\u009a\u0015\u00e6\u0000\u00c4\u0015\u00bc\u0000/\u0015\u00d1\u0000G\u0015\u00b9\u00009\u0015\u0007\u0000\u001f\u0015q\u0000\u001e\u0015\u0012\u00000\u0015\u0010\u0000\u0004\u0015\u001f\u0000\u0015\u0015\u0005\u0000\u0013\u0015\u00b0\u0000@\u0015\u0080\u0000K\u0015\u0005\u0000\u0001\u0015B\u0000\r\u0015@\u0000\u0002\u0015\u0001\u0000\u0001\u0015\u001c\u0000\u00f8\u0015\b\u0000\u00f3\u0015\r\u0000\u001f\u00151\u0000\u0003\u0015\u0011\u0000\u0004\u0015\b\u0000\u018c\u0015\u0004\u0000k\u0015\u0005\u0000\r\u0015\u0003\u0000\t\u0015\u0007\u0000\n\u0015f\u0000U\u0015\u0001\u0000G\u0015\u0001\u0000\u0002\u0015\u0002\u0000\u0001\u0015\u0002\u0000\u0002\u0015\u0002\u0000\u0004\u0015\u0001\u0000\f\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0007\u0015\u0001\u0000A\u0015\u0001\u0000\u0004\u0015\u0002\u0000\b\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u001c\u0015\u0001\u0000\u0004\u0015\u0001\u0000\u0005\u0015\u0001\u0000\u0001\u0015\u0003\u0000\u0007\u0015\u0001\u0000\u0154\u0015\u0002\u0000\u0019\u0015\u0001\u0000\u0019\u0015\u0001\u0000\u001f\u0015\u0001\u0000\u0019\u0015\u0001\u0000\u001f\u0015\u0001\u0000\u0019\u0015\u0001\u0000\u001f\u0015\u0001\u0000\u0019\u0015\u0001\u0000\u001f\u0015\u0001\u0000\u0019\u0015\u0001\u0000\b\u00154\u0000-\u0015\n\u0000\u0007\u0015\u0010\u0000\u0001\u0015\u0171\u0000,\u0015\u0014\u0000\u00c5\u0015;\u0000D\u0015\u0007\u0000\u0001\u0015\u00b4\u0000\u0004\u0015\u0001\u0000\u001b\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0001\u0015\u0002\u0000\u0001\u0015\u0001\u0000\n\u0015\u0001\u0000\u0004\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0006\u0000\u0001\u0015\u0004\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0003\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0001\u0015\u0002\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0001\u0015\u0001\u0000\u0002\u0015\u0001\u0000\u0001\u0015\u0002\u0000\u0004\u0015\u0001\u0000\u0007\u0015\u0001\u0000\u0004\u0015\u0001\u0000\u0004\u0015\u0001\u0000\u0001\u0015\u0001\u0000\n\u0015\u0001\u0000\u0011\u0015\u0005\u0000\u0003\u0015\u0001\u0000\u0005\u0015\u0001\u0000\u0011\u0015D\u0000\u00d7\u0015)\u00005\u0015\u000b\u0000\u00de\u0015\u0002\u0000\u0182\u0015\u000e\u0000\u0131\u0015\u001f\u0000\u001e\u0015\u00e2\u0000";
    private static final int[] ZZ_ACTION = AutoSqlSanitizer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0001\u0002\u0003\u0001\u0001\u0003\u0001\u0004\u0002\u0001\u0001\u0005\u0001\u0001\u0002\u0006\b\u0007\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001\b\u0001\u0000\u0001\t\u0001\u0000\u0007\u0007\u0001\u0000\u0001\u0006\b\u0007\u0001\u0006\u0001\u0007\u0001\n\u0001\u0007\u0001\u000b\u0001\f\u0005\u0007\u0001\r\u0002\u0007\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011";
    private static final int[] ZZ_ROWMAP = AutoSqlSanitizer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\"\u0000D\u0000f\u0000\u0088\u0000\u00aa\u0000\"\u0000\"\u0000\u00cc\u0000\u00ee\u0000\"\u0000\u0110\u0000\u0132\u0000\u0154\u0000\u0176\u0000\u0198\u0000\u01ba\u0000\u01dc\u0000\u01fe\u0000\u0220\u0000\u0242\u0000\u0264\u0000f\u0000\u0286\u0000\u02a8\u0000\u00aa\u0000\u02ca\u0000\"\u0000\u00ee\u0000\"\u0000\u02ec\u0000\u030e\u0000\u0330\u0000\u0352\u0000\u0374\u0000\u0396\u0000\u03b8\u0000\u03da\u0000\u03fc\u0000\u02ec\u0000\u041e\u0000\u0440\u0000\u0462\u0000\u0484\u0000\u04a6\u0000\u04c8\u0000\u04ea\u0000\u050c\u0000\"\u0000\u052e\u0000\u0176\u0000\u0550\u0000\u0176\u0000\u0176\u0000\u0572\u0000\u0594\u0000\u05b6\u0000\u05d8\u0000\u05fa\u0000\u0176\u0000\u061c\u0000\u063e\u0000\u0176\u0000\u0176\u0000\u0176\u0000\u0176";
    private static final int[] ZZ_TRANS = AutoSqlSanitizer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\n\u0001\f\u0001\r\u0001\u000e\u0003\u000f\u0001\u0010\u0001\u000f\u0001\u0011\u0002\u000f\u0001\u0012\u0001\u0013\u0001\u000f\u0001\u0014\u0004\u000f\u0001\u0015\u0001\u000f\u0001\u0016\u0001\u000f#\u0000\u0001\u0003 \u0000\u0002\u0017\u0001\u0018\u001f\u0017\u0003\u0000\u0001\u0019\u001e\u0000\u0004\u001a\u0001\u001b\u001d\u001a\u000b\u0000\u0001\u001c\u001e\u0000\u0001\u001d\u0001\u0000\u0001\u001d\u0001\u0000\u0002\u000e\u001b\u0000\u0001\u001e\"\u0000\u0001\u000e\u0001\u0000\u0001\u000e\u0001\u0000\u0002\u000e\u0004\u0000\u0001\u000e\u000e\u0000\u0001\u001f\b\u0000\u0001\u000e\u0001\u0000\u0001\u000e\u0001\u0000\u0002\u000e\u0004\u0000\u0001\u000e\u0019\u0000\u0001\u000f\u0001\u0000\u0016\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u0001 \u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\u0011\u000f\u0001!\u0004\u000f\n\u0000\u0001\u000f\u0001\u0000\u000e\u000f\u0001\"\u0007\u000f\n\u0000\u0001\u000f\u0001\u0000\u000f\u000f\u0001#\u0006\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u0001$\u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u0001%\u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\u0010\u000f\u0001&\u0005\u000f\u0002\u0000\u0001\u0017\u001f\u0000\u0003\u0019\u0001'\u001e\u0019\u0004\u0000\u0001\u001a)\u0000\b(\u0018\u0000\u0001\u000f\u0001\u0000\f\u000f\u0001)\t\u000f\n\u0000\u0001\u000f\u0001\u0000\u000f\u000f\u0001*\u0006\u000f\n\u0000\u0001\u000f\u0001\u0000\u0012\u000f\u0001+\u0001,\u0002\u000f\n\u0000\u0001\u000f\u0001\u0000\n\u000f\u0001-\u000b\u000f\n\u0000\u0001\u000f\u0001\u0000\u0011\u000f\u0001.\u0004\u000f\n\u0000\u0001\u000f\u0001\u0000\f\u000f\u0001/\t\u000f\n\u0000\u0001\u000f\u0001\u0000\u0005\u000f\u00010\u0010\u000f\u0003\u0000\u00011(\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u00012\u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\r\u000f\u00013\b\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u00014\u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\u000f\u000f\u00015\u0006\u000f\n\u0000\u0001\u000f\u0001\u0000\u000e\u000f\u00016\u0007\u000f\n\u0000\u0001\u000f\u0001\u0000\b\u000f\u00017\r\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u00018\u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\u0002\u000f\u00019\u0013\u000f\n\u0000\u0001\u000f\u0001\u0000\u0013\u000f\u0001:\u0002\u000f\n\u0000\u0001\u000f\u0001\u0000\u0011\u000f\u0001;\u0004\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u0001<\u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\u0004\u000f\u0001=\u0011\u000f\n\u0000\u0001\u000f\u0001\u0000\u0013\u000f\u0001>\u0002\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u0001?\u000f\u000f\n\u0000\u0001\u000f\u0001\u0000\u0013\u000f\u0001@\u0002\u000f\n\u0000\u0001\u000f\u0001\u0000\u0013\u000f\u0001A\u0002\u000f\n\u0000\u0001\u000f\u0001\u0000\u0006\u000f\u0001B\u000f\u000f";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = AutoSqlSanitizer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\u0004\u0001\u0002\t\u0002\u0001\u0001\t\u000b\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\t\u0001\u0000\u0001\t\u0001\u0000\u0007\u0001\u0001\u0000\t\u0001\u0001\t\u0011\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[2048];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private static final int LIMIT = 32768;
    private final StringBuilder builder = new StringBuilder();
    private static final int FROM_TABLE_REF_MAX_IDENTIFIERS = 3;
    private int parenLevel = 0;
    private boolean insideComment = false;
    private Operation operation = NoOp.INSTANCE;
    private boolean extractionDone = false;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = AutoSqlSanitizer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[27904];
        int offset = 0;
        offset = AutoSqlSanitizer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[66];
        int offset = 0;
        offset = AutoSqlSanitizer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[66];
        int offset = 0;
        offset = AutoSqlSanitizer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[1632];
        int offset = 0;
        offset = AutoSqlSanitizer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[66];
        int offset = 0;
        offset = AutoSqlSanitizer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    static SqlStatementInfo sanitize(String statement) {
        AutoSqlSanitizer sanitizer = new AutoSqlSanitizer(new StringReader(statement));
        try {
            int token;
            while (!sanitizer.yyatEOF() && (token = sanitizer.yylex()) != -1) {
            }
            return sanitizer.getResult();
        }
        catch (IOException e) {
            return SqlStatementInfo.create(null, null, null);
        }
    }

    private void appendCurrentFragment() {
        this.builder.append(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    private boolean isOverLimit() {
        return this.builder.length() > 32768;
    }

    private void setOperation(Operation operation) {
        if (this.operation == NoOp.INSTANCE) {
            this.operation = operation;
        }
    }

    private SqlStatementInfo getResult() {
        if (this.builder.length() > 32768) {
            this.builder.delete(32768, this.builder.length());
        }
        String fullStatement = this.builder.toString();
        return this.operation.getResult(fullStatement);
    }

    AutoSqlSanitizer(Reader in) {
        this.zzReader = in;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    private final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    private final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 2048) {
            this.zzBuffer = new char[2048];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    private final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    private final int yystate() {
        return this.zzLexicalState;
    }

    private final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    private final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    private final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    private final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    private void yypushback(int number) {
        if (number > this.yylength()) {
            AutoSqlSanitizer.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block36: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + AutoSqlSanitizer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 18: {
                    continue block36;
                }
                case 2: {
                    this.builder.append(' ');
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 19: {
                    continue block36;
                }
                case 3: {
                    if (!this.insideComment) {
                        ++this.parenLevel;
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 20: {
                    continue block36;
                }
                case 4: {
                    if (!this.insideComment) {
                        --this.parenLevel;
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 21: {
                    continue block36;
                }
                case 5: {
                    if (!this.insideComment && !this.extractionDone) {
                        this.extractionDone = this.operation.handleComma();
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 22: {
                    continue block36;
                }
                case 6: {
                    this.builder.append('?');
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 23: {
                    continue block36;
                }
                case 7: {
                    if (!this.insideComment && !this.extractionDone) {
                        this.extractionDone = this.operation.handleIdentifier();
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 24: {
                    continue block36;
                }
                case 8: {
                    this.insideComment = false;
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 25: {
                    continue block36;
                }
                case 9: {
                    this.insideComment = true;
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 26: {
                    continue block36;
                }
                case 10: {
                    if (!this.insideComment && !this.extractionDone) {
                        this.extractionDone = this.operation.handleFrom();
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 27: {
                    continue block36;
                }
                case 11: {
                    if (!this.insideComment && !this.extractionDone) {
                        this.extractionDone = this.operation.handleInto();
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 28: {
                    continue block36;
                }
                case 12: {
                    if (!this.insideComment && !this.extractionDone) {
                        this.extractionDone = this.operation.handleJoin();
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 29: {
                    continue block36;
                }
                case 13: {
                    if (!this.insideComment) {
                        this.setOperation(new Merge());
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 30: {
                    continue block36;
                }
                case 14: {
                    if (!this.insideComment) {
                        this.setOperation(new Delete());
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 31: {
                    continue block36;
                }
                case 15: {
                    if (!this.insideComment) {
                        this.setOperation(new Insert());
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 32: {
                    continue block36;
                }
                case 16: {
                    if (!this.insideComment) {
                        this.setOperation(new Select());
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 33: {
                    continue block36;
                }
                case 17: {
                    if (!this.insideComment) {
                        this.setOperation(new Update());
                    }
                    this.appendCurrentFragment();
                    if (this.isOverLimit()) {
                        return -1;
                    }
                }
                case 34: {
                    continue block36;
                }
            }
            AutoSqlSanitizer.zzScanError(1);
        }
    }

    private class Merge
    extends Operation {
        private Merge() {
        }

        @Override
        boolean handleIdentifier() {
            this.mainTable = AutoSqlSanitizer.this.yytext();
            return true;
        }
    }

    private class Update
    extends Operation {
        private Update() {
        }

        @Override
        boolean handleIdentifier() {
            this.mainTable = AutoSqlSanitizer.this.yytext();
            return true;
        }
    }

    private class Delete
    extends Operation {
        boolean expectingTableName;

        private Delete() {
            this.expectingTableName = false;
        }

        @Override
        boolean handleFrom() {
            this.expectingTableName = true;
            return false;
        }

        @Override
        boolean handleIdentifier() {
            if (!this.expectingTableName) {
                return false;
            }
            this.mainTable = AutoSqlSanitizer.this.yytext();
            return true;
        }
    }

    private class Insert
    extends Operation {
        boolean expectingTableName;

        private Insert() {
            this.expectingTableName = false;
        }

        @Override
        boolean handleInto() {
            this.expectingTableName = true;
            return false;
        }

        @Override
        boolean handleIdentifier() {
            if (!this.expectingTableName) {
                return false;
            }
            this.mainTable = AutoSqlSanitizer.this.yytext();
            return true;
        }
    }

    private class Select
    extends Operation {
        private static final int FROM_TABLE_REF_MAX_IDENTIFIERS = 3;
        boolean expectingTableName;
        boolean mainTableSetAlready;
        int identifiersAfterMainFromClause;

        private Select() {
            this.expectingTableName = false;
            this.mainTableSetAlready = false;
            this.identifiersAfterMainFromClause = 0;
        }

        @Override
        boolean handleFrom() {
            if (AutoSqlSanitizer.this.parenLevel == 0) {
                this.expectingTableName = true;
                return false;
            }
            this.mainTable = null;
            return true;
        }

        @Override
        boolean handleJoin() {
            this.mainTable = null;
            return true;
        }

        @Override
        boolean handleIdentifier() {
            if (this.identifiersAfterMainFromClause > 0) {
                ++this.identifiersAfterMainFromClause;
            }
            if (!this.expectingTableName) {
                return false;
            }
            if (AutoSqlSanitizer.this.parenLevel != 0) {
                this.mainTable = null;
                return true;
            }
            if (this.mainTableSetAlready) {
                this.mainTable = null;
                return true;
            }
            this.mainTable = AutoSqlSanitizer.this.yytext();
            this.mainTableSetAlready = true;
            this.expectingTableName = false;
            this.identifiersAfterMainFromClause = 1;
            return false;
        }

        @Override
        boolean handleComma() {
            if (this.identifiersAfterMainFromClause > 0 && this.identifiersAfterMainFromClause <= 3) {
                this.mainTable = null;
                return true;
            }
            return false;
        }
    }

    private static class NoOp
    extends Operation {
        static final Operation INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        SqlStatementInfo getResult(String fullStatement) {
            return SqlStatementInfo.create(fullStatement, null, null);
        }
    }

    private static abstract class Operation {
        String mainTable = null;

        private Operation() {
        }

        boolean handleFrom() {
            return false;
        }

        boolean handleInto() {
            return false;
        }

        boolean handleJoin() {
            return false;
        }

        boolean handleIdentifier() {
            return false;
        }

        boolean handleComma() {
            return false;
        }

        SqlStatementInfo getResult(String fullStatement) {
            return SqlStatementInfo.create(fullStatement, this.getClass().getSimpleName().toUpperCase(), this.mainTable);
        }
    }
}

