/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.contrib.json.classic;

import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.ILoggingEvent;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.classic.spi.IThrowableProxy;
import com.microsoft.applicationinsights.agent.shadow.ch.qos.logback.contrib.json.JsonLayoutBase;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonLayout
extends JsonLayoutBase<ILoggingEvent> {
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String THREAD_ATTR_NAME = "thread";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "logger";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    public static final String MESSAGE_ATTR_NAME = "raw-message";
    public static final String EXCEPTION_ATTR_NAME = "exception";
    public static final String CONTEXT_ATTR_NAME = "context";
    protected boolean includeLevel = true;
    protected boolean includeThreadName = true;
    protected boolean includeMDC = true;
    protected boolean includeLoggerName = true;
    protected boolean includeFormattedMessage = true;
    protected boolean includeMessage;
    protected boolean includeException = true;
    protected boolean includeContextName = true;
    private ThrowableHandlingConverter throwableProxyConverter = new ThrowableProxyConverter();

    @Override
    public void start() {
        this.throwableProxyConverter.start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.throwableProxyConverter.stop();
    }

    @Override
    protected Map toJsonMap(ILoggingEvent iLoggingEvent) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        this.addTimestamp(TIMESTAMP_ATTR_NAME, this.includeTimestamp, iLoggingEvent.getTimeStamp(), linkedHashMap);
        this.add(LEVEL_ATTR_NAME, this.includeLevel, String.valueOf(iLoggingEvent.getLevel()), linkedHashMap);
        this.add(THREAD_ATTR_NAME, this.includeThreadName, iLoggingEvent.getThreadName(), linkedHashMap);
        this.addMap(MDC_ATTR_NAME, this.includeMDC, iLoggingEvent.getMDCPropertyMap(), linkedHashMap);
        this.add(LOGGER_ATTR_NAME, this.includeLoggerName, iLoggingEvent.getLoggerName(), linkedHashMap);
        this.add(FORMATTED_MESSAGE_ATTR_NAME, this.includeFormattedMessage, iLoggingEvent.getFormattedMessage(), linkedHashMap);
        this.add(MESSAGE_ATTR_NAME, this.includeMessage, iLoggingEvent.getMessage(), linkedHashMap);
        this.add(CONTEXT_ATTR_NAME, this.includeContextName, iLoggingEvent.getLoggerContextVO().getName(), linkedHashMap);
        this.addThrowableInfo(EXCEPTION_ATTR_NAME, this.includeException, iLoggingEvent, linkedHashMap);
        this.addCustomDataToJsonMap(linkedHashMap, iLoggingEvent);
        return linkedHashMap;
    }

    protected void addThrowableInfo(String string, boolean bl, ILoggingEvent iLoggingEvent, Map<String, Object> map) {
        String string2;
        IThrowableProxy iThrowableProxy;
        if (bl && iLoggingEvent != null && (iThrowableProxy = iLoggingEvent.getThrowableProxy()) != null && (string2 = this.throwableProxyConverter.convert(iLoggingEvent)) != null && !string2.equals("")) {
            map.put(string, string2);
        }
    }

    protected void addCustomDataToJsonMap(Map<String, Object> map, ILoggingEvent iLoggingEvent) {
    }

    public boolean isIncludeLevel() {
        return this.includeLevel;
    }

    public void setIncludeLevel(boolean bl) {
        this.includeLevel = bl;
    }

    public boolean isIncludeLoggerName() {
        return this.includeLoggerName;
    }

    public void setIncludeLoggerName(boolean bl) {
        this.includeLoggerName = bl;
    }

    public boolean isIncludeFormattedMessage() {
        return this.includeFormattedMessage;
    }

    public void setIncludeFormattedMessage(boolean bl) {
        this.includeFormattedMessage = bl;
    }

    public boolean isIncludeMessage() {
        return this.includeMessage;
    }

    public void setIncludeMessage(boolean bl) {
        this.includeMessage = bl;
    }

    public boolean isIncludeMDC() {
        return this.includeMDC;
    }

    public void setIncludeMDC(boolean bl) {
        this.includeMDC = bl;
    }

    public boolean isIncludeThreadName() {
        return this.includeThreadName;
    }

    public void setIncludeThreadName(boolean bl) {
        this.includeThreadName = bl;
    }

    public boolean isIncludeException() {
        return this.includeException;
    }

    public void setIncludeException(boolean bl) {
        this.includeException = bl;
    }

    public boolean isIncludeContextName() {
        return this.includeContextName;
    }

    public void setIncludeContextName(boolean bl) {
        this.includeContextName = bl;
    }

    public ThrowableHandlingConverter getThrowableProxyConverter() {
        return this.throwableProxyConverter;
    }

    public void setThrowableProxyConverter(ThrowableHandlingConverter throwableHandlingConverter) {
        this.throwableProxyConverter = throwableHandlingConverter;
    }
}

