/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import android.util.Log;
import com.microsoft.azure.storage.OperationContext;

public class Logger {
    public static void debug(OperationContext opContext, String format) {
        if (Logger.shouldLog(opContext, 3)) {
            Log.d((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format));
        }
    }

    public static void debug(OperationContext opContext, String format, Object ... args) {
        if (Logger.shouldLog(opContext, 3)) {
            Log.d((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, args));
        }
    }

    public static void debug(OperationContext opContext, String format, Object arg1) {
        if (Logger.shouldLog(opContext, 3)) {
            Log.d((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1));
        }
    }

    public static void debug(OperationContext opContext, String format, Object arg1, Object arg2) {
        if (Logger.shouldLog(opContext, 3)) {
            Log.d((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1, arg2));
        }
    }

    public static void error(OperationContext opContext, String format) {
        if (Logger.shouldLog(opContext, 6)) {
            Log.e((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format));
        }
    }

    public static void error(OperationContext opContext, String format, Object ... args) {
        if (Logger.shouldLog(opContext, 6)) {
            Log.e((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, args));
        }
    }

    public static void error(OperationContext opContext, String format, Object arg1) {
        if (Logger.shouldLog(opContext, 6)) {
            Log.e((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1));
        }
    }

    public static void error(OperationContext opContext, String format, Object args1, Object args2) {
        if (Logger.shouldLog(opContext, 6)) {
            Log.e((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, args1, args2));
        }
    }

    public static void info(OperationContext opContext, String format) {
        if (Logger.shouldLog(opContext, 4)) {
            Log.i((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format));
        }
    }

    public static void info(OperationContext opContext, String format, Object ... args) {
        if (Logger.shouldLog(opContext, 4)) {
            Log.i((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, args));
        }
    }

    public static void info(OperationContext opContext, String format, Object arg1) {
        if (Logger.shouldLog(opContext, 4)) {
            Log.i((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1));
        }
    }

    public static void info(OperationContext opContext, String format, Object arg1, Object arg2) {
        if (Logger.shouldLog(opContext, 4)) {
            Log.i((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1, arg2));
        }
    }

    public static void verbose(OperationContext opContext, String format) {
        if (Logger.shouldLog(opContext, 2)) {
            Log.v((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format));
        }
    }

    public static void verbose(OperationContext opContext, String format, Object ... args) {
        if (Logger.shouldLog(opContext, 2)) {
            Log.v((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, args));
        }
    }

    public static void verbose(OperationContext opContext, String format, Object arg1) {
        if (Logger.shouldLog(opContext, 2)) {
            Log.v((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1));
        }
    }

    public static void verbose(OperationContext opContext, String format, Object arg1, Object arg2) {
        if (Logger.shouldLog(opContext, 2)) {
            Log.v((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1, arg2));
        }
    }

    public static void warn(OperationContext opContext, String format) {
        if (Logger.shouldLog(opContext, 5)) {
            Log.w((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format));
        }
    }

    public static void warn(OperationContext opContext, String format, Object ... args) {
        if (Logger.shouldLog(opContext, 5)) {
            Log.w((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, args));
        }
    }

    public static void warn(OperationContext opContext, String format, Object arg1) {
        if (Logger.shouldLog(opContext, 5)) {
            Log.w((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1));
        }
    }

    public static void warn(OperationContext opContext, String format, Object arg1, Object arg2) {
        if (Logger.shouldLog(opContext, 5)) {
            Log.w((String)"WindowsAzureStorageSDK", (String)Logger.formatLogEntry(opContext, format, arg1, arg2));
        }
    }

    public static boolean shouldLog(OperationContext opContext, int logLevel) {
        if (opContext != null && opContext.getLogLevel() != null) {
            return opContext.getLogLevel() <= logLevel && Log.isLoggable((String)"WindowsAzureStorageSDK", (int)logLevel);
        }
        if (OperationContext.getDefaultLogLevel() != null) {
            return OperationContext.getDefaultLogLevel() <= logLevel && Log.isLoggable((String)"WindowsAzureStorageSDK", (int)logLevel);
        }
        return false;
    }

    private static String formatLogEntry(OperationContext opContext, String format) {
        return String.format("{%s}: {%s}", opContext == null ? "*" : opContext.getClientRequestID(), format.replace('\n', '.'));
    }

    private static String formatLogEntry(OperationContext opContext, String format, Object ... args) {
        return String.format("{%s}: {%s}", opContext == null ? "*" : opContext.getClientRequestID(), String.format(format, args).replace('\n', '.'));
    }

    private static String formatLogEntry(OperationContext opContext, String format, Object arg1) {
        return String.format("{%s}: {%s}", opContext == null ? "*" : opContext.getClientRequestID(), String.format(format, arg1).replace('\n', '.'));
    }

    private static String formatLogEntry(OperationContext opContext, String format, Object arg1, Object arg2) {
        return String.format("{%s}: {%s}", opContext == null ? "*" : opContext.getClientRequestID(), String.format(format, arg1, arg2).replace('\n', '.'));
    }

    private Logger() {
    }
}

