/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobAttributes;
import com.microsoft.azure.storage.blob.BlobContainerAttributes;
import com.microsoft.azure.storage.blob.BlobContainerProperties;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CopyState;
import com.microsoft.azure.storage.blob.CopyStatus;
import com.microsoft.azure.storage.blob.LeaseDuration;
import com.microsoft.azure.storage.blob.LeaseState;
import com.microsoft.azure.storage.blob.LeaseStatus;
import com.microsoft.azure.storage.blob.PremiumPageBlobTier;
import com.microsoft.azure.storage.blob.RehydrationStatus;
import com.microsoft.azure.storage.blob.StandardBlobTier;
import com.microsoft.azure.storage.core.BaseResponse;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

final class BlobResponse
extends BaseResponse {
    BlobResponse() {
    }

    public static String getAcl(HttpURLConnection request) {
        return request.getHeaderField("x-ms-blob-public-access");
    }

    public static BlobAttributes getBlobAttributes(HttpURLConnection request, StorageUri resourceURI, String snapshotID) throws URISyntaxException, ParseException {
        String rehydrationStatusString;
        PremiumPageBlobTier premiumPageBlobTier;
        String blobTierString;
        String comittedBlockCount;
        String blobType = request.getHeaderField("x-ms-blob-type");
        BlobAttributes attributes = new BlobAttributes(BlobType.parse(blobType));
        BlobProperties properties = attributes.getProperties();
        properties.setCacheControl(request.getHeaderField("Cache-Control"));
        properties.setContentDisposition(request.getHeaderField("Content-Disposition"));
        properties.setContentEncoding(request.getHeaderField("Content-Encoding"));
        properties.setContentLanguage(request.getHeaderField("Content-Language"));
        if (!Utility.isNullOrEmpty(request.getHeaderField("Content-Range"))) {
            properties.setContentMD5(request.getHeaderField("x-ms-blob-content-md5"));
        } else {
            properties.setContentMD5(request.getHeaderField("Content-MD5"));
        }
        properties.setContentType(request.getHeaderField("Content-Type"));
        properties.setEtag(BaseResponse.getEtag(request));
        properties.setServerEncrypted("true".equals(request.getHeaderField("x-ms-server-encrypted")));
        Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
        lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
        lastModifiedCalendar.setTime(new Date(request.getLastModified()));
        properties.setLastModified(lastModifiedCalendar.getTime());
        properties.setLeaseStatus(BlobResponse.getLeaseStatus(request));
        properties.setLeaseState(BlobResponse.getLeaseState(request));
        properties.setLeaseDuration(BlobResponse.getLeaseDuration(request));
        String rangeHeader = request.getHeaderField("Content-Range");
        String xContentLengthHeader = request.getHeaderField("x-ms-blob-content-length");
        if (!Utility.isNullOrEmpty(rangeHeader)) {
            properties.setLength(Long.parseLong(rangeHeader.split("/")[1]));
        } else if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            properties.setLength(Long.parseLong(xContentLengthHeader));
        } else {
            String contentLength = request.getHeaderField("Content-Length");
            if (!Utility.isNullOrEmpty(contentLength)) {
                properties.setLength(Long.parseLong(contentLength));
            }
        }
        String sequenceNumber = request.getHeaderField("x-ms-blob-sequence-number");
        if (!Utility.isNullOrEmpty(sequenceNumber)) {
            properties.setPageBlobSequenceNumber(Long.parseLong(sequenceNumber));
        }
        if (!Utility.isNullOrEmpty(comittedBlockCount = request.getHeaderField("x-ms-blob-committed-block-count"))) {
            properties.setAppendBlobCommittedBlockCount(Integer.parseInt(comittedBlockCount));
        }
        if (!Utility.isNullOrEmpty(blobTierString = request.getHeaderField("x-ms-access-tier")) && properties.getBlobType().equals((Object)BlobType.PAGE_BLOB)) {
            premiumPageBlobTier = PremiumPageBlobTier.parse(blobTierString);
            properties.setPremiumPageBlobTier(premiumPageBlobTier);
        } else if (!Utility.isNullOrEmpty(blobTierString) && properties.getBlobType().equals((Object)BlobType.BLOCK_BLOB)) {
            StandardBlobTier standardBlobTier = StandardBlobTier.parse(blobTierString);
            properties.setStandardBlobTier(standardBlobTier);
        } else if (!Utility.isNullOrEmpty(blobTierString) && properties.getBlobType().equals((Object)BlobType.UNSPECIFIED)) {
            premiumPageBlobTier = PremiumPageBlobTier.parse(blobTierString);
            StandardBlobTier standardBlobTier = StandardBlobTier.parse(blobTierString);
            if (!premiumPageBlobTier.equals((Object)PremiumPageBlobTier.UNKNOWN)) {
                properties.setPremiumPageBlobTier(premiumPageBlobTier);
            } else if (!standardBlobTier.equals((Object)StandardBlobTier.UNKNOWN)) {
                properties.setStandardBlobTier(standardBlobTier);
            } else {
                properties.setPremiumPageBlobTier(PremiumPageBlobTier.UNKNOWN);
                properties.setStandardBlobTier(StandardBlobTier.UNKNOWN);
            }
        }
        String tierInferredString = request.getHeaderField("x-ms-access-tier-inferred");
        if (!Utility.isNullOrEmpty(tierInferredString)) {
            properties.setBlobTierInferred(Boolean.parseBoolean(tierInferredString));
        }
        if (!Utility.isNullOrEmpty(rehydrationStatusString = request.getHeaderField("x-ms-archive-status"))) {
            RehydrationStatus rehydrationStatus = RehydrationStatus.parse(rehydrationStatusString);
            properties.setRehydrationStatus(rehydrationStatus);
        } else {
            properties.setRehydrationStatus(null);
        }
        String incrementalCopyHeaderString = request.getHeaderField("x-ms-incremental-copy");
        if (!Utility.isNullOrEmpty(incrementalCopyHeaderString)) {
            properties.setIncrementalCopy("true".equals(incrementalCopyHeaderString));
        }
        attributes.setStorageUri(resourceURI);
        attributes.setSnapshotID(snapshotID);
        attributes.setMetadata(BaseResponse.getMetadata(request));
        properties.setCopyState(BlobResponse.getCopyState(request));
        attributes.setProperties(properties);
        return attributes;
    }

    public static BlobContainerAttributes getBlobContainerAttributes(HttpURLConnection request, boolean usePathStyleUris) throws StorageException {
        URI tempURI;
        BlobContainerAttributes containerAttributes = new BlobContainerAttributes();
        try {
            tempURI = PathUtility.stripSingleURIQueryAndFragment(request.getURL().toURI());
        }
        catch (URISyntaxException e) {
            StorageException wrappedUnexpectedException = Utility.generateNewUnexpectedStorageException(e);
            throw wrappedUnexpectedException;
        }
        containerAttributes.setName(PathUtility.getContainerNameFromUri(tempURI, usePathStyleUris));
        BlobContainerProperties containerProperties = containerAttributes.getProperties();
        containerProperties.setEtag(BaseResponse.getEtag(request));
        containerProperties.setLastModified(new Date(request.getLastModified()));
        containerAttributes.setMetadata(BlobResponse.getMetadata(request));
        containerProperties.setLeaseStatus(BlobResponse.getLeaseStatus(request));
        containerProperties.setLeaseState(BlobResponse.getLeaseState(request));
        containerProperties.setLeaseDuration(BlobResponse.getLeaseDuration(request));
        containerProperties.setPublicAccess(BlobResponse.getPublicAccessLevel(request));
        return containerAttributes;
    }

    public static CopyState getCopyState(HttpURLConnection request) throws URISyntaxException, ParseException {
        String copyStatusString = request.getHeaderField("x-ms-copy-status");
        if (!Utility.isNullOrEmpty(copyStatusString)) {
            String copyDestinationSnapshotString;
            String copyCompletionTimeString;
            String copySourceString;
            CopyState copyState = new CopyState();
            copyState.setStatus(CopyStatus.parse(copyStatusString));
            copyState.setCopyId(request.getHeaderField("x-ms-copy-id"));
            copyState.setStatusDescription(request.getHeaderField("x-ms-copy-status-description"));
            String copyProgressString = request.getHeaderField("x-ms-copy-progress");
            if (!Utility.isNullOrEmpty(copyProgressString)) {
                String[] progressSequence = copyProgressString.split("/");
                copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
            }
            if (!Utility.isNullOrEmpty(copySourceString = request.getHeaderField("x-ms-copy-source"))) {
                copyState.setSource(new URI(copySourceString));
            }
            if (!Utility.isNullOrEmpty(copyCompletionTimeString = request.getHeaderField("x-ms-copy-completion-time"))) {
                copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(copyCompletionTimeString));
            }
            if (!Utility.isNullOrEmpty(copyDestinationSnapshotString = request.getHeaderField("x-ms-copy-destination-snapshot"))) {
                copyState.setCopyDestinationSnapshotID(copyDestinationSnapshotString);
            }
            return copyState;
        }
        return null;
    }

    public static LeaseDuration getLeaseDuration(HttpURLConnection request) {
        String leaseDuration = request.getHeaderField("x-ms-lease-duration");
        if (!Utility.isNullOrEmpty(leaseDuration)) {
            return LeaseDuration.parse(leaseDuration);
        }
        return LeaseDuration.UNSPECIFIED;
    }

    public static String getLeaseID(HttpURLConnection request) {
        return request.getHeaderField("x-ms-lease-id");
    }

    public static LeaseState getLeaseState(HttpURLConnection request) {
        String leaseState = request.getHeaderField("x-ms-lease-state");
        if (!Utility.isNullOrEmpty(leaseState)) {
            return LeaseState.parse(leaseState);
        }
        return LeaseState.UNSPECIFIED;
    }

    public static LeaseStatus getLeaseStatus(HttpURLConnection request) {
        String leaseStatus = request.getHeaderField("x-ms-lease-status");
        if (!Utility.isNullOrEmpty(leaseStatus)) {
            return LeaseStatus.parse(leaseStatus);
        }
        return LeaseStatus.UNSPECIFIED;
    }

    public static String getLeaseTime(HttpURLConnection request) {
        return request.getHeaderField("x-ms-lease-time");
    }

    public static String getSnapshotTime(HttpURLConnection request) {
        return request.getHeaderField("x-ms-snapshot");
    }

    public static BlobContainerPublicAccessType getPublicAccessLevel(HttpURLConnection request) {
        String publicAccess = request.getHeaderField("x-ms-blob-public-access");
        if (!Utility.isNullOrEmpty(publicAccess)) {
            return BlobContainerPublicAccessType.parse(publicAccess);
        }
        return BlobContainerPublicAccessType.OFF;
    }
}

