/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.CorsProperties;
import com.microsoft.azure.storage.CorsRule;
import com.microsoft.azure.storage.LoggingOperations;
import com.microsoft.azure.storage.LoggingProperties;
import com.microsoft.azure.storage.MetricsLevel;
import com.microsoft.azure.storage.MetricsProperties;
import com.microsoft.azure.storage.ServiceProperties;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import org.xmlpull.v1.XmlSerializer;

final class ServicePropertiesSerializer {
    ServicePropertiesSerializer() {
    }

    public static byte[] serializeToByteArray(ServiceProperties properties) throws IllegalArgumentException, IllegalStateException, IOException {
        StringWriter outWriter = new StringWriter();
        XmlSerializer xmlw = Utility.getXmlSerializer(outWriter);
        xmlw.startDocument("UTF-8", Boolean.valueOf(true));
        xmlw.startTag("", "StorageServiceProperties");
        if (properties.getLogging() != null) {
            ServicePropertiesSerializer.writeLoggingProperties(xmlw, properties.getLogging());
        }
        if (properties.getHourMetrics() != null) {
            ServicePropertiesSerializer.writeMetricsProperties(xmlw, properties.getHourMetrics(), "HourMetrics");
        }
        if (properties.getMinuteMetrics() != null) {
            ServicePropertiesSerializer.writeMetricsProperties(xmlw, properties.getMinuteMetrics(), "MinuteMetrics");
        }
        if (properties.getCors() != null) {
            ServicePropertiesSerializer.writeCorsProperties(xmlw, properties.getCors());
        }
        if (properties.getDefaultServiceVersion() != null) {
            Utility.serializeElement(xmlw, "DefaultServiceVersion", properties.getDefaultServiceVersion());
        }
        xmlw.endTag("", "StorageServiceProperties");
        xmlw.endDocument();
        return outWriter.toString().getBytes("UTF-8");
    }

    private static void writeRetentionPolicy(XmlSerializer xmlw, Integer val) throws IllegalArgumentException, IllegalStateException, IOException {
        xmlw.startTag("", "RetentionPolicy");
        Utility.serializeElement(xmlw, "Enabled", val != null ? "true" : "false");
        if (val != null) {
            Utility.serializeElement(xmlw, "Days", val.toString());
        }
        xmlw.endTag("", "RetentionPolicy");
    }

    private static void writeCorsProperties(XmlSerializer xmlw, CorsProperties cors) throws IllegalArgumentException, IllegalStateException, IOException {
        Utility.assertNotNull("CorsRules", cors.getCorsRules());
        xmlw.startTag("", "Cors");
        for (CorsRule rule : cors.getCorsRules()) {
            if (rule.getAllowedOrigins().isEmpty() || rule.getAllowedMethods().isEmpty() || rule.getMaxAgeInSeconds() < 0) {
                throw new IllegalArgumentException("A CORS rule must contain at least one allowed origin and allowed method, and MaxAgeInSeconds cannot have a value less than zero.");
            }
            xmlw.startTag("", "CorsRule");
            Utility.serializeElement(xmlw, "AllowedOrigins", ServicePropertiesSerializer.joinToString(rule.getAllowedOrigins(), ","));
            Utility.serializeElement(xmlw, "AllowedMethods", ServicePropertiesSerializer.joinToString(rule.getAllowedMethods(), ","));
            Utility.serializeElement(xmlw, "ExposedHeaders", ServicePropertiesSerializer.joinToString(rule.getExposedHeaders(), ","));
            Utility.serializeElement(xmlw, "AllowedHeaders", ServicePropertiesSerializer.joinToString(rule.getAllowedHeaders(), ","));
            Utility.serializeElement(xmlw, "MaxAgeInSeconds", Integer.toString(rule.getMaxAgeInSeconds()));
            xmlw.endTag("", "CorsRule");
        }
        xmlw.endTag("", "Cors");
    }

    private static void writeMetricsProperties(XmlSerializer xmlw, MetricsProperties metrics, String metricsName) throws IllegalArgumentException, IllegalStateException, IOException {
        Utility.assertNotNull("metrics.Configuration", (Object)metrics.getMetricsLevel());
        xmlw.startTag("", metricsName);
        Utility.serializeElement(xmlw, "Version", metrics.getVersion());
        Utility.serializeElement(xmlw, "Enabled", metrics.getMetricsLevel() != MetricsLevel.DISABLED ? "true" : "false");
        if (metrics.getMetricsLevel() != MetricsLevel.DISABLED) {
            Utility.serializeElement(xmlw, "IncludeAPIs", metrics.getMetricsLevel() == MetricsLevel.SERVICE_AND_API ? "true" : "false");
        }
        ServicePropertiesSerializer.writeRetentionPolicy(xmlw, metrics.getRetentionIntervalInDays());
        xmlw.endTag("", metricsName);
    }

    private static void writeLoggingProperties(XmlSerializer xmlw, LoggingProperties logging) throws IllegalArgumentException, IllegalStateException, IOException {
        Utility.assertNotNull("logging.LogOperationTypes", logging.getLogOperationTypes());
        xmlw.startTag("", "Logging");
        Utility.serializeElement(xmlw, "Version", logging.getVersion());
        Utility.serializeElement(xmlw, "Delete", logging.getLogOperationTypes().contains((Object)LoggingOperations.DELETE) ? "true" : "false");
        Utility.serializeElement(xmlw, "Read", logging.getLogOperationTypes().contains((Object)LoggingOperations.READ) ? "true" : "false");
        Utility.serializeElement(xmlw, "Write", logging.getLogOperationTypes().contains((Object)LoggingOperations.WRITE) ? "true" : "false");
        ServicePropertiesSerializer.writeRetentionPolicy(xmlw, logging.getRetentionIntervalInDays());
        xmlw.endTag("", "Logging");
    }

    private static String joinToString(Iterable<?> iterable, String delimiter) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = iterable.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }
}

