/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.ErrorReceivingResponseEvent;
import com.microsoft.azure.storage.RequestCompletedEvent;
import com.microsoft.azure.storage.RequestResult;
import com.microsoft.azure.storage.ResponseReceivedEvent;
import com.microsoft.azure.storage.RetryingEvent;
import com.microsoft.azure.storage.SendingRequestEvent;
import com.microsoft.azure.storage.StorageEvent;
import com.microsoft.azure.storage.StorageEventMultiCaster;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public final class OperationContext {
    private static Integer defaultLogLevel;
    private static boolean enableLoggingByDefault;
    private static Proxy proxyDefault;
    private Proxy proxy;
    private long clientTimeInMs;
    private String clientRequestID;
    private Integer logLevel;
    private final ArrayList<RequestResult> requestResults;
    private HashMap<String, String> userHeaders;
    private static StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> globalSendingRequestEventHandler;
    private static StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> globalResponseReceivedEventHandler;
    private static StorageEventMultiCaster<ErrorReceivingResponseEvent, StorageEvent<ErrorReceivingResponseEvent>> globalErrorReceivingResponseEventHandler;
    private static StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> globalRequestCompletedEventHandler;
    private static StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> globalRetryingEventHandler;
    private StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> sendingRequestEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> responseReceivedEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<ErrorReceivingResponseEvent, StorageEvent<ErrorReceivingResponseEvent>> errorReceivingResponseEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> requestCompletedEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> retryingEventHandler = new StorageEventMultiCaster();

    public OperationContext() {
        this.clientRequestID = UUID.randomUUID().toString();
        this.requestResults = new ArrayList();
    }

    public String getClientRequestID() {
        return this.clientRequestID;
    }

    public long getClientTimeInMs() {
        return this.clientTimeInMs;
    }

    public synchronized RequestResult getLastResult() {
        if (this.requestResults == null || this.requestResults.size() == 0) {
            return null;
        }
        return this.requestResults.get(this.requestResults.size() - 1);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public HashMap<String, String> getUserHeaders() {
        return this.userHeaders;
    }

    public ArrayList<RequestResult> getRequestResults() {
        return this.requestResults;
    }

    public synchronized void appendRequestResult(RequestResult requestResult) {
        this.requestResults.add(requestResult);
    }

    public static Integer getDefaultLogLevel() {
        return defaultLogLevel;
    }

    public static StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> getGlobalSendingRequestEventHandler() {
        return globalSendingRequestEventHandler;
    }

    public static StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> getGlobalResponseReceivedEventHandler() {
        return globalResponseReceivedEventHandler;
    }

    public static StorageEventMultiCaster<ErrorReceivingResponseEvent, StorageEvent<ErrorReceivingResponseEvent>> getGlobalErrorReceivingResponseEventHandler() {
        return globalErrorReceivingResponseEventHandler;
    }

    public static StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> getGlobalRequestCompletedEventHandler() {
        return globalRequestCompletedEventHandler;
    }

    public static StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> getGlobalRetryingEventHandler() {
        return globalRetryingEventHandler;
    }

    public Integer getLogLevel() {
        return this.logLevel;
    }

    public StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> getSendingRequestEventHandler() {
        return this.sendingRequestEventHandler;
    }

    public StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> getResponseReceivedEventHandler() {
        return this.responseReceivedEventHandler;
    }

    public StorageEventMultiCaster<ErrorReceivingResponseEvent, StorageEvent<ErrorReceivingResponseEvent>> getErrorReceivingResponseEventHandler() {
        return this.errorReceivingResponseEventHandler;
    }

    public StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> getRequestCompletedEventHandler() {
        return this.requestCompletedEventHandler;
    }

    public StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> getRetryingEventHandler() {
        return this.retryingEventHandler;
    }

    public void initialize() {
        this.setClientTimeInMs(0L);
        this.requestResults.clear();
    }

    public void setClientRequestID(String clientRequestID) {
        this.clientRequestID = clientRequestID;
    }

    public void setClientTimeInMs(long clientTimeInMs) {
        this.clientTimeInMs = clientTimeInMs;
    }

    public static void setDefaultLogLevel(Integer defaultLogLevel) {
        OperationContext.defaultLogLevel = defaultLogLevel;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setUserHeaders(HashMap<String, String> userHeaders) {
        this.userHeaders = userHeaders;
    }

    public static void setGlobalSendingRequestEventHandler(StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> globalSendingRequestEventHandler) {
        OperationContext.globalSendingRequestEventHandler = globalSendingRequestEventHandler;
    }

    public static void setGlobalResponseReceivedEventHandler(StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> globalResponseReceivedEventHandler) {
        OperationContext.globalResponseReceivedEventHandler = globalResponseReceivedEventHandler;
    }

    public static void setGlobalErrorReceivingResponseEventHandler(StorageEventMultiCaster<ErrorReceivingResponseEvent, StorageEvent<ErrorReceivingResponseEvent>> globalErrorReceivingResponseEventHandler) {
        OperationContext.globalErrorReceivingResponseEventHandler = globalErrorReceivingResponseEventHandler;
    }

    public static void setGlobalRequestCompletedEventHandler(StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> globalRequestCompletedEventHandler) {
        OperationContext.globalRequestCompletedEventHandler = globalRequestCompletedEventHandler;
    }

    public static void setGlobalRetryingEventHandler(StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> globalRetryingEventHandler) {
        OperationContext.globalRetryingEventHandler = globalRetryingEventHandler;
    }

    public void setLogLevel(Integer logLevel) {
        this.logLevel = logLevel;
    }

    public void setSendingRequestEventHandler(StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> sendingRequestEventHandler) {
        this.sendingRequestEventHandler = sendingRequestEventHandler;
    }

    public void setResponseReceivedEventHandler(StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> responseReceivedEventHandler) {
        this.responseReceivedEventHandler = responseReceivedEventHandler;
    }

    public void setErrorReceivingResponseEventHandler(StorageEventMultiCaster<ErrorReceivingResponseEvent, StorageEvent<ErrorReceivingResponseEvent>> errorReceivingResponseEventHandler) {
        this.errorReceivingResponseEventHandler = errorReceivingResponseEventHandler;
    }

    public void setRequestCompletedEventHandler(StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> requestCompletedEventHandler) {
        this.requestCompletedEventHandler = requestCompletedEventHandler;
    }

    public void setRetryingEventHandler(StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> retryingEventHandler) {
        this.retryingEventHandler = retryingEventHandler;
    }

    public static Proxy getDefaultProxy() {
        return proxyDefault;
    }

    public static void setDefaultProxy(Proxy defaultProxy) {
        proxyDefault = defaultProxy;
    }

    static {
        enableLoggingByDefault = false;
        globalSendingRequestEventHandler = new StorageEventMultiCaster();
        globalResponseReceivedEventHandler = new StorageEventMultiCaster();
        globalErrorReceivingResponseEventHandler = new StorageEventMultiCaster();
        globalRequestCompletedEventHandler = new StorageEventMultiCaster();
        globalRetryingEventHandler = new StorageEventMultiCaster();
    }
}

