/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AdalAuthorizatonGrant;
import com.microsoft.aad.adal4j.AdalTokenRequest;
import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationAuthority;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientAssertion;
import com.microsoft.aad.adal4j.ClientAuthenticationPost;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.aad.adal4j.ClientDataHttpHeaders;
import com.microsoft.aad.adal4j.JwtHelper;
import com.microsoft.aad.adal4j.LogHelper;
import com.microsoft.aad.adal4j.SAML11BearerGrant;
import com.microsoft.aad.adal4j.StringHelper;
import com.microsoft.aad.adal4j.UserDiscoveryRequest;
import com.microsoft.aad.adal4j.UserDiscoveryResponse;
import com.microsoft.aad.adal4j.WSTrustRequest;
import com.microsoft.aad.adal4j.WSTrustResponse;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.SAML2BearerGrant;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationContext {
    private final Logger log = LoggerFactory.getLogger(AuthenticationContext.class);
    private final AuthenticationAuthority authenticationAuthority;
    private String correlationId;
    private String authority;
    private final ExecutorService service;
    private final boolean validateAuthority;
    private Proxy proxy;
    private SSLSocketFactory sslSocketFactory;

    public AuthenticationContext(String authority, boolean validateAuthority, ExecutorService service) throws MalformedURLException {
        if (StringHelper.isBlank(authority)) {
            throw new IllegalArgumentException("authority is null or empty");
        }
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        this.service = service;
        this.validateAuthority = validateAuthority;
        this.authority = this.canonicalizeUri(authority);
        this.authenticationAuthority = new AuthenticationAuthority(new URL(this.getAuthority()), this.shouldValidateAuthority());
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private String canonicalizeUri(String authority) {
        if (!authority.endsWith("/")) {
            authority = authority + "/";
        }
        return authority;
    }

    private Future<AuthenticationResult> acquireToken(AdalAuthorizatonGrant authGrant, ClientAuthentication clientAuth, final AuthenticationCallback callback) {
        return this.service.submit((new Callable<AuthenticationResult>(){
            private AdalAuthorizatonGrant authGrant;
            private ClientAuthentication clientAuth;
            private ClientDataHttpHeaders headers;

            @Override
            public AuthenticationResult call() throws Exception {
                AuthenticationResult result = null;
                try {
                    this.authGrant = AuthenticationContext.this.processPasswordGrant(this.authGrant);
                    result = AuthenticationContext.this.acquireTokenCommon(this.authGrant, this.clientAuth, this.headers);
                    AuthenticationContext.this.logResult(result, this.headers);
                    if (callback != null) {
                        callback.onSuccess(result);
                    }
                }
                catch (Exception ex) {
                    AuthenticationContext.this.log.error(LogHelper.createMessage("Request to acquire token failed.", this.headers.getHeaderCorrelationIdValue()), (Throwable)ex);
                    if (callback != null) {
                        callback.onFailure(ex);
                    }
                    throw ex;
                }
                return result;
            }

            private Callable<AuthenticationResult> init(AdalAuthorizatonGrant authGrant, ClientAuthentication clientAuth, ClientDataHttpHeaders headers) {
                this.authGrant = authGrant;
                this.clientAuth = clientAuth;
                this.headers = headers;
                return this;
            }
        }).init(authGrant, clientAuth, new ClientDataHttpHeaders(this.getCorrelationId())));
    }

    public Future<AuthenticationResult> acquireToken(String resource, String clientId, String username, String password, AuthenticationCallback callback) {
        if (StringHelper.isBlank(resource)) {
            throw new IllegalArgumentException("resource is null or empty");
        }
        if (StringHelper.isBlank(clientId)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        if (StringHelper.isBlank(username)) {
            throw new IllegalArgumentException("username is null or empty");
        }
        if (StringHelper.isBlank(password)) {
            throw new IllegalArgumentException("password is null or empty");
        }
        return this.acquireToken(new AdalAuthorizatonGrant((AuthorizationGrant)new ResourceOwnerPasswordCredentialsGrant(username, new Secret(password)), resource), new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(clientId)), callback);
    }

    public Future<AuthenticationResult> acquireToken(String resource, ClientAssertion credential, AuthenticationCallback callback) {
        this.validateInput(resource, credential, true);
        ClientAuthentication clientAuth = this.createClientAuthFromClientAssertion(credential);
        AdalAuthorizatonGrant authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new ClientCredentialsGrant(), resource);
        return this.acquireToken(authGrant, clientAuth, callback);
    }

    private void validateInput(String resource, Object credential, boolean validateResource) {
        if (validateResource && StringHelper.isBlank(resource)) {
            throw new IllegalArgumentException("resource is null or empty");
        }
        if (credential == null) {
            throw new IllegalArgumentException("credential is null");
        }
    }

    public Future<AuthenticationResult> acquireToken(String resource, ClientAssertion assertion, ClientCredential credential, AuthenticationCallback callback) {
        this.validateInput(resource, credential, true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", resource);
        params.put("requested_token_use", "on_behalf_of");
        try {
            AdalAuthorizatonGrant grant = new AdalAuthorizatonGrant((AuthorizationGrant)new JWTBearerGrant(SignedJWT.parse((String)assertion.getAssertion())), params);
            ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
            return this.acquireToken(grant, (ClientAuthentication)clientAuth, callback);
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
    }

    public Future<AuthenticationResult> acquireToken(String resource, ClientCredential credential, AuthenticationCallback callback) {
        this.validateInput(resource, credential, true);
        ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
        AdalAuthorizatonGrant authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new ClientCredentialsGrant(), resource);
        return this.acquireToken(authGrant, (ClientAuthentication)clientAuth, callback);
    }

    public Future<AuthenticationResult> acquireToken(String resource, AsymmetricKeyCredential credential, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireToken(resource, JwtHelper.buildJwt(credential, this.authenticationAuthority.getSelfSignedJwtAudience()), callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, String resource, String clientId, URI redirectUri, AuthenticationCallback callback) {
        ClientAuthenticationPost clientAuth = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(clientId));
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, (Object)clientAuth, resource);
        AdalAuthorizatonGrant authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), redirectUri), resource);
        return this.acquireToken(authGrant, clientAuth, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientAssertion credential, AuthenticationCallback callback) {
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, credential, (String)null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientAssertion credential, String resource, AuthenticationCallback callback) {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, credential, resource);
        ClientAuthentication clientAuth = this.createClientAuthFromClientAssertion(credential);
        AdalAuthorizatonGrant authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), redirectUri), resource);
        return this.acquireToken(authGrant, clientAuth, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientCredential credential, AuthenticationCallback callback) {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, credential, null);
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, credential, null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, ClientCredential credential, String resource, AuthenticationCallback callback) {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, credential, resource);
        ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
        AdalAuthorizatonGrant authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), redirectUri), resource);
        return this.acquireToken(authGrant, (ClientAuthentication)clientAuth, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, AsymmetricKeyCredential credential, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, credential, null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String authorizationCode, URI redirectUri, AsymmetricKeyCredential credential, String resource, AuthenticationCallback callback) throws AuthenticationException {
        this.validateAuthCodeRequestInput(authorizationCode, redirectUri, credential, resource);
        return this.acquireTokenByAuthorizationCode(authorizationCode, redirectUri, JwtHelper.buildJwt(credential, this.authenticationAuthority.getSelfSignedJwtAudience()), resource, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, String clientId, ClientAssertion credential, AuthenticationCallback callback) {
        return this.acquireTokenByRefreshToken(refreshToken, clientId, credential, null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, String clientId, ClientAssertion credential, String resource, AuthenticationCallback callback) {
        this.validateRefreshTokenRequestInput(refreshToken, clientId, credential);
        ClientAuthentication clientAuth = this.createClientAuthFromClientAssertion(credential);
        AdalAuthorizatonGrant authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(refreshToken)), resource);
        return this.acquireToken(authGrant, clientAuth, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, ClientCredential credential, AuthenticationCallback callback) {
        return this.acquireTokenByRefreshToken(refreshToken, credential, (String)null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, ClientCredential credential, String resource, AuthenticationCallback callback) {
        ClientSecretPost clientAuth = new ClientSecretPost(new ClientID(credential.getClientId()), new Secret(credential.getClientSecret()));
        AdalAuthorizatonGrant authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(refreshToken)), resource);
        return this.acquireToken(authGrant, (ClientAuthentication)clientAuth, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, AsymmetricKeyCredential credential, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireTokenByRefreshToken(refreshToken, credential, (String)null, callback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String refreshToken, AsymmetricKeyCredential credential, String resource, AuthenticationCallback callback) throws AuthenticationException {
        return this.acquireTokenByRefreshToken(refreshToken, credential.getClientId(), JwtHelper.buildJwt(credential, this.authenticationAuthority.getSelfSignedJwtAudience()), null, callback);
    }

    private void validateRefreshTokenRequestInput(String refreshToken, String clientId, Object credential) {
        if (StringHelper.isBlank(refreshToken)) {
            throw new IllegalArgumentException("refreshToken is null or empty");
        }
        if (StringHelper.isBlank(clientId)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        this.validateInput(null, credential, false);
    }

    private AuthenticationResult acquireTokenCommon(AdalAuthorizatonGrant authGrant, ClientAuthentication clientAuth, ClientDataHttpHeaders headers) throws Exception {
        this.log.debug(LogHelper.createMessage(String.format("Using Client Http Headers: %s", headers), headers.getHeaderCorrelationIdValue()));
        this.authenticationAuthority.doInstanceDiscovery(headers.getReadonlyHeaderMap(), this.proxy, this.sslSocketFactory);
        URL url = new URL(this.authenticationAuthority.getTokenUri());
        AdalTokenRequest request = new AdalTokenRequest(url, clientAuth, authGrant, headers.getReadonlyHeaderMap(), this.proxy, this.sslSocketFactory);
        AuthenticationResult result = request.executeOAuthRequestAndProcessResponse();
        return result;
    }

    private AdalAuthorizatonGrant processPasswordGrant(AdalAuthorizatonGrant authGrant) throws Exception {
        if (!(authGrant.getAuthorizationGrant() instanceof ResourceOwnerPasswordCredentialsGrant)) {
            return authGrant;
        }
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)authGrant.getAuthorizationGrant();
        UserDiscoveryResponse discoveryResponse = UserDiscoveryRequest.execute(this.authenticationAuthority.getUserRealmEndpoint(grant.getUsername()), this.proxy, this.sslSocketFactory);
        if (discoveryResponse.isAccountFederated()) {
            WSTrustResponse response = WSTrustRequest.execute(discoveryResponse.getFederationMetadataUrl(), grant.getUsername(), grant.getPassword().getValue(), this.proxy, this.sslSocketFactory);
            SAML11BearerGrant updatedGrant = null;
            updatedGrant = response.isTokenSaml2() ? new SAML2BearerGrant(new Base64URL(Base64.encodeBase64String((byte[])response.getToken().getBytes("UTF-8")))) : new SAML11BearerGrant(new Base64URL(Base64.encodeBase64String((byte[])response.getToken().getBytes())));
            authGrant = new AdalAuthorizatonGrant((AuthorizationGrant)updatedGrant, authGrant.getCustomParameters());
        }
        return authGrant;
    }

    private void logResult(AuthenticationResult result, ClientDataHttpHeaders headers) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!StringHelper.isBlank(result.getAccessToken())) {
            String logMessage = "";
            String accessTokenHash = this.computeSha256Hash(result.getAccessToken());
            if (!StringHelper.isBlank(result.getRefreshToken())) {
                String refreshTokenHash = this.computeSha256Hash(result.getRefreshToken());
                logMessage = String.format("Access Token with hash '%s' and Refresh Token with hash '%s' returned", accessTokenHash, refreshTokenHash);
            } else {
                logMessage = String.format("Access Token with hash '%s' returned", accessTokenHash);
            }
            this.log.debug(LogHelper.createMessage(logMessage, headers.getHeaderCorrelationIdValue()));
        }
    }

    private String computeSha256Hash(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(input.getBytes("UTF-8"));
        byte[] hash = digest.digest();
        return Base64.encodeBase64URLSafeString((byte[])hash);
    }

    private ClientAuthentication createClientAuthFromClientAssertion(ClientAssertion credential) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            map.put("client_assertion", credential.getAssertion());
            return PrivateKeyJWT.parse(map);
        }
        catch (ParseException e) {
            throw new AuthenticationException(e);
        }
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public boolean shouldValidateAuthority() {
        return this.validateAuthority;
    }

    public String getAuthority() {
        return this.authority;
    }

    private void validateAuthCodeRequestInput(String authorizationCode, URI redirectUri, Object credential, String resource) {
        if (StringHelper.isBlank(authorizationCode)) {
            throw new IllegalArgumentException("authorization code is null or empty");
        }
        if (redirectUri == null) {
            throw new IllegalArgumentException("redirect uri is null");
        }
        this.validateInput(resource, credential, false);
    }
}

