/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.NamespaceContextImpl;
import com.microsoft.aad.adal4j.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class WSTrustResponse {
    private static final Logger log = LoggerFactory.getLogger(WSTrustResponse.class);
    public static final String SAML1_ASSERTION = "urn:oasis:names:tc:SAML:1.0:assertion";
    private String faultMessage;
    private boolean errorFound;
    private String errorCode;
    private String token;
    private String tokenType;

    private WSTrustResponse() {
    }

    String getFaultMessage() {
        return this.faultMessage;
    }

    boolean isErrorFound() {
        return this.errorFound;
    }

    String getErrorCode() {
        return this.errorCode;
    }

    String getToken() {
        return this.token;
    }

    String getTokenType() {
        return this.tokenType;
    }

    boolean isTokenSaml2() {
        return this.tokenType != null && !SAML1_ASSERTION.equalsIgnoreCase(this.tokenType);
    }

    static WSTrustResponse parse(String response) throws Exception {
        WSTrustResponse responseValue = new WSTrustResponse();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document xmlDocument = builder.parse(new ByteArrayInputStream(response.getBytes(Charset.forName("UTF-8"))));
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new NamespaceContextImpl());
        if (WSTrustResponse.parseError(responseValue, xmlDocument, xPath)) {
            if (StringHelper.isBlank(responseValue.errorCode)) {
                responseValue.errorCode = "NONE";
            }
            if (StringHelper.isBlank(responseValue.faultMessage)) {
                responseValue.faultMessage = "NONE";
            }
            throw new Exception("Server returned error in RSTR - ErrorCode: " + responseValue.errorCode + " : FaultMessage: " + responseValue.faultMessage.trim());
        }
        WSTrustResponse.parseToken(responseValue, xmlDocument, xPath);
        return responseValue;
    }

    private static void parseToken(WSTrustResponse responseValue, Document xmlDocument, XPath xPath) throws Exception {
        NodeList tokenTypeNodes = (NodeList)xPath.compile("//s:Envelope/s:Body/wst:RequestSecurityTokenResponseCollection/wst:RequestSecurityTokenResponse/wst:TokenType").evaluate(xmlDocument, XPathConstants.NODESET);
        if (tokenTypeNodes.getLength() == 0) {
            log.warn("No TokenType elements found in RSTR");
        }
        for (int i = 0; i < tokenTypeNodes.getLength(); ++i) {
            NodeList requestedTokenNodes;
            if (!StringHelper.isBlank(responseValue.token)) {
                log.warn("Found more than one returned token.  Using the first.");
                break;
            }
            Node tokenTypeNode = tokenTypeNodes.item(i);
            responseValue.tokenType = tokenTypeNode.getTextContent();
            if (StringHelper.isBlank(responseValue.tokenType)) {
                log.warn("Could not find token type in RSTR token");
            }
            if ((requestedTokenNodes = (NodeList)xPath.compile("wst:RequestedSecurityToken").evaluate(tokenTypeNode.getParentNode(), XPathConstants.NODESET)).getLength() > 1) {
                throw new Exception("Found too many RequestedSecurityToken nodes for token type: " + responseValue.tokenType);
            }
            if (requestedTokenNodes.getLength() == 0) {
                log.warn("Unable to find RequestsSecurityToken element associated with TokenType element: " + responseValue.tokenType);
                continue;
            }
            responseValue.token = WSTrustResponse.innerXml(requestedTokenNodes.item(0));
            if (StringHelper.isBlank(responseValue.token)) {
                log.warn("Unable to find token associated with TokenType element: " + responseValue.tokenType);
                continue;
            }
            log.info("Found token of type: " + responseValue.tokenType);
        }
        if (StringHelper.isBlank(responseValue.token)) {
            throw new Exception("Unable to find any tokens in RSTR");
        }
    }

    private static boolean parseError(WSTrustResponse responseValue, Document xmlDocument, XPath xPath) throws Exception {
        NodeList subcodeNodes;
        boolean errorFound = false;
        NodeList faultNodes = (NodeList)xPath.compile("//s:Envelope/s:Body/s:Fault/s:Reason").evaluate(xmlDocument, XPathConstants.NODESET);
        if (faultNodes.getLength() > 0) {
            responseValue.faultMessage = faultNodes.item(0).getTextContent();
            if (!StringHelper.isBlank(responseValue.faultMessage)) {
                responseValue.errorFound = true;
            }
        }
        if ((subcodeNodes = (NodeList)xPath.compile("//s:Envelope/s:Body/s:Fault/s:Code/s:Subcode/s:Value").evaluate(xmlDocument, XPathConstants.NODESET)).getLength() > 1) {
            throw new Exception("Found too many fault code values:" + subcodeNodes.getLength());
        }
        if (subcodeNodes.getLength() == 1) {
            responseValue.errorCode = subcodeNodes.item(0).getChildNodes().item(0).getTextContent();
            responseValue.errorCode = responseValue.errorCode.split(":")[1];
            errorFound = true;
        }
        return errorFound;
    }

    static String innerXml(Node node) {
        String xmlString = "";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(node);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            xmlString = sw.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        xmlString = xmlString.replaceAll("<trust:RequestedSecurityToken \\S*>", "");
        xmlString = xmlString.replaceAll("</trust:RequestedSecurityToken>", "");
        return xmlString.trim();
    }
}

