/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.LogHelper;
import com.microsoft.aad.adal4j.StringHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;

class HttpHelper {
    HttpHelper() {
    }

    static String executeHttpGet(Logger log, String url) throws Exception {
        return HttpHelper.executeHttpGet(log, url, null);
    }

    static String executeHttpGet(Logger log, String url, Map<String, String> headers) throws Exception {
        HttpURLConnection conn = HttpHelper.openConnection(url);
        HttpHelper.configureAdditionalHeaders(conn, headers);
        String response = HttpHelper.readResponseFromConnection(conn);
        if (headers != null) {
            HttpHelper.verifyReturnedCorrelationId(log, conn, headers.get("client-request-id"));
        }
        return response;
    }

    static String executeHttpPost(Logger log, String url, String postData) throws Exception {
        return HttpHelper.executeHttpPost(log, url, postData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String executeHttpPost(Logger log, String url, String postData, Map<String, String> headers) throws Exception {
        HttpURLConnection conn = HttpHelper.openConnection(url);
        HttpHelper.configureAdditionalHeaders(conn, headers);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        try (FilterOutputStream wr = null;){
            wr = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)wr).writeBytes(postData);
            ((DataOutputStream)wr).flush();
            String response = HttpHelper.readResponseFromConnection(conn);
            HttpHelper.verifyReturnedCorrelationId(log, conn, headers.get("client-request-id"));
            String string = response;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readResponseFromConnection(HttpURLConnection conn) throws IOException {
        InputStreamReader inReader = new InputStreamReader(conn.getInputStream());
        BufferedReader reader = new BufferedReader(inReader);
        char[] buffer = new char[256];
        StringBuilder out = new StringBuilder();
        try {
            if (conn.getResponseCode() != 200) {
                throw new IOException("Failed: HTTP error code " + conn.getResponseCode());
            }
            int rsz = -1;
            while ((rsz = reader.read(buffer, 0, buffer.length)) > -1) {
                out.append(buffer, 0, rsz);
            }
        }
        finally {
            reader.close();
        }
        return out.toString();
    }

    static HttpURLConnection openConnection(URL finalURL) throws IOException {
        return (HttpURLConnection)finalURL.openConnection();
    }

    static HttpURLConnection openConnection(String url) throws IOException {
        return HttpHelper.openConnection(new URL(url));
    }

    static HttpURLConnection configureAdditionalHeaders(HttpURLConnection conn, Map<String, String> headers) throws MalformedURLException, IOException {
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.setRequestProperty(key, headers.get(key));
            }
        }
        return conn;
    }

    static void verifyReturnedCorrelationId(Logger log, HttpURLConnection conn, String sentCorrelationId) {
        if (StringHelper.isBlank(conn.getHeaderField("client-request-id")) || !conn.getHeaderField("client-request-id").equals(sentCorrelationId)) {
            log.info(LogHelper.createMessage(String.format("Sent (%s) Correlation Id is not same as received (%s).", sentCorrelationId, conn.getHeaderField("client-request-id")), sentCorrelationId));
        }
    }
}

