/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.push;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.utils.AppCenterLog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PushIntentUtils {
    private static final String EXTRA_GCM_PREFIX = "gcm.notification.";
    @VisibleForTesting
    static final String EXTRA_TITLE = "gcm.notification.title";
    @VisibleForTesting
    static final String EXTRA_MESSAGE = "gcm.notification.body";
    @VisibleForTesting
    static final String EXTRA_COLOR = "gcm.notification.color";
    @VisibleForTesting
    static final String EXTRA_SOUND = "gcm.notification.sound";
    @VisibleForTesting
    static final String EXTRA_SOUND_ALT = "gcm.notification.sound2";
    @VisibleForTesting
    static final String EXTRA_ICON = "gcm.notification.icon";
    @VisibleForTesting
    static final String EXTRA_GOOGLE_PREFIX = "google.";
    @VisibleForTesting
    static final String EXTRA_GOOGLE_MESSAGE_ID = "google.message_id";
    @VisibleForTesting
    static final Set<String> EXTRA_STANDARD_KEYS = new HashSet<String>(){
        {
            this.add("collapse_key");
            this.add("from");
        }
    };

    PushIntentUtils() {
    }

    static Map<String, String> getCustomData(Intent pushIntent) {
        HashMap<String, String> customData = new HashMap<String, String>();
        HashMap<String, String> standardData = new HashMap<String, String>();
        Bundle intentExtras = pushIntent.getExtras();
        if (intentExtras != null) {
            for (String key : intentExtras.keySet()) {
                String value = String.valueOf(intentExtras.get(key));
                if (key.startsWith(EXTRA_GCM_PREFIX) || key.startsWith(EXTRA_GOOGLE_PREFIX) || EXTRA_STANDARD_KEYS.contains(key)) {
                    standardData.put(key, value);
                    continue;
                }
                customData.put(key, value);
            }
        }
        AppCenterLog.debug((String)"AppCenterPush", (String)("Push standard data: " + standardData));
        AppCenterLog.debug((String)"AppCenterPush", (String)("Push custom data: " + customData));
        return customData;
    }

    static String getTitle(Intent pushIntent) {
        return pushIntent.getStringExtra(EXTRA_TITLE);
    }

    static String getMessage(Intent pushIntent) {
        return pushIntent.getStringExtra(EXTRA_MESSAGE);
    }

    static String getMessageId(Intent pushIntent) {
        return pushIntent.getStringExtra(EXTRA_GOOGLE_MESSAGE_ID);
    }

    static void setMessageId(String messageId, Intent pushIntent) {
        pushIntent.putExtra(EXTRA_GOOGLE_MESSAGE_ID, messageId);
    }

    static String getSound(Intent pushIntent) {
        String sound = pushIntent.getStringExtra(EXTRA_SOUND_ALT);
        return sound == null ? pushIntent.getStringExtra(EXTRA_SOUND) : sound;
    }

    static String getColor(Intent pushIntent) {
        return pushIntent.getStringExtra(EXTRA_COLOR);
    }

    static String getIcon(Intent pushIntent) {
        return pushIntent.getStringExtra(EXTRA_ICON);
    }
}

