/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.push;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.FirebaseMessagingService;

class FirebaseUtils {
    @VisibleForTesting
    FirebaseUtils() {
    }

    static boolean isFirebaseAvailable() {
        try {
            FirebaseUtils.getFirebaseInstanceId();
            return true;
        }
        catch (FirebaseUnavailableException e) {
            return false;
        }
    }

    static void setAnalyticsEnabled(@NonNull Context context, boolean enabled) {
        FirebaseAnalytics instance = FirebaseAnalytics.getInstance((Context)context);
        instance.setAnalyticsCollectionEnabled(enabled);
    }

    static void setFirebaseMessagingServiceEnabled(@NonNull Context context, boolean enabled) {
        PackageManager packageManager = context.getPackageManager();
        ComponentName firebaseComponentName = new ComponentName(context, FirebaseMessagingService.class.getName());
        packageManager.setComponentEnabledSetting(firebaseComponentName, enabled ? 0 : 2, 1);
    }

    @Nullable
    static String getToken() throws FirebaseUnavailableException {
        return FirebaseUtils.getFirebaseInstanceId().getToken();
    }

    @NonNull
    private static FirebaseInstanceId getFirebaseInstanceId() throws FirebaseUnavailableException {
        try {
            FirebaseInstanceId instance = FirebaseInstanceId.getInstance();
            if (instance == null) {
                throw new FirebaseUnavailableException("null instance");
            }
            return instance;
        }
        catch (IllegalStateException e) {
            throw new FirebaseUnavailableException(e);
        }
    }

    static class FirebaseUnavailableException
    extends Exception {
        FirebaseUnavailableException(Throwable cause) {
            super(cause);
        }

        FirebaseUnavailableException(String message) {
            super(message);
        }
    }
}

