/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.data;

import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.appcenter.data.exception.DataException;
import com.microsoft.appcenter.data.models.DocumentWrapper;
import com.microsoft.appcenter.data.models.LocalDocument;
import com.microsoft.appcenter.data.models.Page;
import com.microsoft.appcenter.data.models.PaginatedDocuments;
import com.microsoft.appcenter.data.models.TokenResult;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.context.AuthTokenContext;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Utils {
    private static final Gson sGson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateAdapter()).serializeNulls().create();
    private static final JsonParser sParser = new JsonParser();

    private static <T> DocumentWrapper<T> parseLocalDocument(LocalDocument localDocument, Class<T> documentType) {
        DocumentWrapper<T> documentWrapper = Utils.parseDocument(localDocument.getDocument(), localDocument.getPartition(), localDocument.getDocumentId(), localDocument.getETag(), localDocument.getOperationTime() / 1000L, documentType);
        documentWrapper.setFromCache(true);
        documentWrapper.setPendingOperation(localDocument.getOperation());
        return documentWrapper;
    }

    static <T> PaginatedDocuments<T> localDocumentsToNonExpiredPaginated(Iterable<LocalDocument> localDocuments, Class<T> documentType) {
        PaginatedDocuments paginatedDocuments = new PaginatedDocuments();
        Page page = new Page();
        ArrayList documentWrappers = new ArrayList();
        for (LocalDocument localDocument : localDocuments) {
            if (localDocument.isExpired()) continue;
            documentWrappers.add(Utils.parseLocalDocument(localDocument, documentType));
        }
        page.setItems(documentWrappers);
        paginatedDocuments.setCurrentPage(page);
        return paginatedDocuments;
    }

    static <T> DocumentWrapper<T> parseDocument(String cosmosDbPayload, Class<T> documentType) {
        JsonObject body;
        try {
            body = sParser.parse(cosmosDbPayload).getAsJsonObject();
        }
        catch (RuntimeException e) {
            return new DocumentWrapper(e);
        }
        return Utils.parseDocument(body, documentType);
    }

    static <T> DocumentWrapper<T> parseDocument(String documentJson, String partition, String documentId, String eTag, long lastUpdatedTime, Class<T> documentType) {
        JsonElement documentElement = documentJson == null ? null : sParser.parse(documentJson);
        return Utils.parseDocument(documentElement, partition, documentId, eTag, lastUpdatedTime, documentType);
    }

    static String getETag(String cosmosDbPayload) {
        if (cosmosDbPayload == null) {
            return null;
        }
        JsonElement parsedPayload = sParser.parse(cosmosDbPayload);
        if (!parsedPayload.isJsonObject()) {
            return null;
        }
        JsonObject cosmosResponseJson = parsedPayload.getAsJsonObject();
        return cosmosResponseJson.has("_etag") ? cosmosResponseJson.get("_etag").getAsString() : null;
    }

    private static <T> DocumentWrapper<T> parseDocument(JsonObject obj, Class<T> documentType) {
        JsonElement document = obj.get("document");
        JsonElement partition = obj.get("PartitionKey");
        JsonElement documentId = obj.get("id");
        JsonElement eTag = obj.get("_etag");
        JsonElement timestamp = obj.get("_ts");
        if (Utils.isNullOrJsonNull(partition) || Utils.isNullOrJsonNull(documentId) || Utils.isNullOrJsonNull(timestamp)) {
            return new DocumentWrapper(new DataException("Failed to deserialize document."));
        }
        return Utils.parseDocument(document, partition.getAsString(), documentId.getAsString(), !Utils.isNullOrJsonNull(eTag) ? eTag.getAsString() : null, timestamp.getAsLong(), documentType);
    }

    private static <T> DocumentWrapper<T> parseDocument(JsonElement documentObject, String partition, String documentId, String eTag, long lastUpdatedTime, Class<T> documentType) {
        Object document = null;
        DataException error = null;
        if (documentObject != null) {
            try {
                document = sGson.fromJson(documentObject, documentType);
            }
            catch (JsonParseException exception) {
                error = new DataException("Failed to deserialize document.", (Exception)((Object)exception));
            }
        }
        return new DocumentWrapper<Object>(document, partition, documentId, eTag, lastUpdatedTime, error);
    }

    private static boolean isNullOrJsonNull(JsonElement value) {
        return value == null || value.isJsonNull();
    }

    public static <T> Page<T> parseDocuments(String cosmosDbPayload, Class<T> documentType) {
        JsonArray array;
        try {
            JsonObject objects = sParser.parse(cosmosDbPayload).getAsJsonObject();
            array = objects.get("Documents").getAsJsonArray();
        }
        catch (RuntimeException e) {
            AppCenterLog.error((String)"AppCenterData", (String)"Failed to deserialize Page.", (Throwable)e);
            return new Page(new DataException("Failed to deserialize Page.", e));
        }
        ArrayList documents = new ArrayList();
        for (JsonElement object : array) {
            documents.add(Utils.parseDocument(object.getAsJsonObject(), documentType));
        }
        return new Page().setItems(documents);
    }

    static synchronized void logApiCallFailure(Exception e) {
        AppCenterLog.error((String)"AppCenterData", (String)"Failed to call App Center APIs", (Throwable)e);
    }

    static String removeAccountIdFromPartitionName(String partition) {
        if (partition.equals("readonly")) {
            return partition;
        }
        return partition.substring(0, partition.length() - 37);
    }

    public static Gson getGson() {
        return sGson;
    }

    static String getTableName(String partition) {
        if ("user".equals(partition)) {
            return Utils.getUserTableName();
        }
        return "app_documents";
    }

    @NonNull
    static String getTableName(String partition, String accountId) {
        if ("user".equals(partition)) {
            return Utils.getUserTableName(accountId);
        }
        return "app_documents";
    }

    static String getUserTableName() {
        String accountId = AuthTokenContext.getInstance().getAccountId();
        return accountId == null ? null : Utils.getUserTableName(accountId);
    }

    @NonNull
    static String getTableName(@NonNull TokenResult tokenResult) {
        if (tokenResult.getPartition().startsWith("user")) {
            return Utils.getUserTableName(tokenResult.getAccountId());
        }
        return "app_documents";
    }

    static String getUserTableName(String accountId) {
        return String.format("user_%s_documents", accountId).replace("-", "");
    }

    static String getOutgoingId(String partition, String documentId) {
        return String.format("%s_%s", partition, documentId);
    }

    public static boolean isValidTokenResult(TokenResult tokenResult) {
        return tokenResult.getDbAccount() != null && tokenResult.getDbName() != null && tokenResult.getDbCollectionName() != null && tokenResult.getToken() != null;
    }

    private static class DateAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

        DateAdapter() {
            this.mDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public synchronized JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(this.mDateFormat.format(src));
        }

        public synchronized Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return this.mDateFormat.parse(json.getAsString());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

