/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.microsoft.appcenter.crashes.Crashes;
import com.microsoft.appcenter.crashes.ingestion.models.ErrorAttachmentLog;
import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.crashes.model.ErrorReport;
import com.microsoft.appcenter.crashes.utils.ErrorLogHelper;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.DeviceInfoHelper;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.storage.FileManager;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WrapperSdkExceptionManager {
    @VisibleForTesting
    static final Map<String, String> sWrapperExceptionDataContainer = new HashMap<String, String>();
    private static final String DATA_FILE_EXTENSION = ".dat";

    @VisibleForTesting
    WrapperSdkExceptionManager() {
    }

    public static UUID saveWrapperException(Thread thread, Throwable throwable, Exception modelException, String rawSerializedException) {
        try {
            UUID errorId = Crashes.getInstance().saveUncaughtException(thread, throwable, modelException);
            if (errorId != null && rawSerializedException != null) {
                sWrapperExceptionDataContainer.put(errorId.toString(), rawSerializedException);
                File dataFile = WrapperSdkExceptionManager.getFile(errorId);
                FileManager.write((File)dataFile, (String)rawSerializedException);
                AppCenterLog.debug((String)"AppCenterCrashes", (String)("Saved raw wrapper exception data into " + dataFile));
            }
            return errorId;
        }
        catch (java.lang.Exception e) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to save wrapper exception data to file", (Throwable)e);
            return null;
        }
    }

    public static void deleteWrapperExceptionData(UUID errorId) {
        if (errorId == null) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to delete wrapper exception data: null errorId");
            return;
        }
        File dataFile = WrapperSdkExceptionManager.getFile(errorId);
        if (dataFile.exists()) {
            String loadResult = WrapperSdkExceptionManager.loadWrapperExceptionData(errorId);
            if (loadResult == null) {
                AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to load wrapper exception data.");
            }
            FileManager.delete((File)dataFile);
        }
    }

    public static String loadWrapperExceptionData(UUID errorId) {
        if (errorId == null) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to load wrapper exception data: null errorId");
            return null;
        }
        String data = sWrapperExceptionDataContainer.get(errorId.toString());
        if (data != null) {
            return data;
        }
        File dataFile = WrapperSdkExceptionManager.getFile(errorId);
        if (dataFile.exists()) {
            data = FileManager.read((File)dataFile);
            if (data != null) {
                sWrapperExceptionDataContainer.put(errorId.toString(), data);
            }
            return data;
        }
        return null;
    }

    private static File getFile(@NonNull UUID errorId) {
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        String filename = errorId.toString() + DATA_FILE_EXTENSION;
        return new File(errorStorageDirectory, filename);
    }

    public static String trackException(Exception modelException, Map<String, String> properties, Iterable<ErrorAttachmentLog> attachments) {
        return Crashes.getInstance().queueException(modelException, properties, attachments).toString();
    }

    public static void setAutomaticProcessing(boolean automaticProcessing) {
        Crashes.getInstance().setAutomaticProcessing(automaticProcessing);
    }

    public static AppCenterFuture<Collection<ErrorReport>> getUnprocessedErrorReports() {
        return Crashes.getInstance().getUnprocessedErrorReports();
    }

    public static AppCenterFuture<Boolean> sendCrashReportsOrAwaitUserConfirmation(Collection<String> filteredReportIds) {
        return Crashes.getInstance().sendCrashReportsOrAwaitUserConfirmation(filteredReportIds);
    }

    public static ErrorReport buildHandledErrorReport(Context context, String errorReportId) {
        ErrorReport report = new ErrorReport();
        report.setId(errorReportId);
        report.setAppErrorTime(new Date());
        report.setAppStartTime(new Date(Crashes.getInstance().getInitializeTimestamp()));
        try {
            report.setDevice(Crashes.getInstance().getDeviceInfo(context));
        }
        catch (DeviceInfoHelper.DeviceInfoException e) {
            AppCenterLog.warn((String)"AppCenterCrashes", (String)("Handled error report cannot get device info, errorReportId=" + errorReportId));
        }
        return report;
    }

    public static void sendErrorAttachments(String errorReportId, Iterable<ErrorAttachmentLog> attachments) {
        Crashes.getInstance().sendErrorAttachments(errorReportId, attachments);
    }
}

