/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes.utils;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.Constants;
import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.crashes.ingestion.models.ManagedErrorLog;
import com.microsoft.appcenter.crashes.ingestion.models.StackFrame;
import com.microsoft.appcenter.crashes.ingestion.models.Thread;
import com.microsoft.appcenter.crashes.model.ErrorReport;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.DeviceInfoHelper;
import com.microsoft.appcenter.utils.UUIDUtils;
import com.microsoft.appcenter.utils.storage.StorageHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ErrorLogHelper {
    public static final String ERROR_LOG_FILE_EXTENSION = ".json";
    public static final String THROWABLE_FILE_EXTENSION = ".throwable";
    private static final String MINIDUMP_DIRECTORY = "minidump";
    private static final String NEW_MINIDUMP_DIRECTORY = "new";
    private static final String PENDING_MINIDUMP_DIRECTORY = "pending";
    @VisibleForTesting
    public static final int FRAME_LIMIT = 256;
    @VisibleForTesting
    static final String ERROR_DIRECTORY = "error";
    private static final int FRAME_LIMIT_HALF = 128;
    private static File sErrorLogDirectory;
    public static final int MAX_PROPERTY_COUNT = 5;
    public static final int MAX_PROPERTY_ITEM_LENGTH = 64;
    private static File sNewMinidumpDirectory;
    private static File sPendingMinidumpDirectory;

    @NonNull
    public static ManagedErrorLog createErrorLog(@NonNull Context context, @NonNull java.lang.Thread thread, @NonNull Throwable throwable, @NonNull Map<java.lang.Thread, StackTraceElement[]> allStackTraces, long initializeTimestamp) {
        return ErrorLogHelper.createErrorLog(context, thread, ErrorLogHelper.getModelExceptionFromThrowable(throwable), allStackTraces, initializeTimestamp, true);
    }

    @NonNull
    public static ManagedErrorLog createErrorLog(@NonNull Context context, @NonNull java.lang.Thread thread, @NonNull Exception exception, @NonNull Map<java.lang.Thread, StackTraceElement[]> allStackTraces, long initializeTimestamp, boolean fatal) {
        ManagedErrorLog errorLog = new ManagedErrorLog();
        errorLog.setId(UUIDUtils.randomUUID());
        errorLog.setTimestamp(new Date());
        try {
            errorLog.setDevice(DeviceInfoHelper.getDeviceInfo((Context)context));
        }
        catch (DeviceInfoHelper.DeviceInfoException e) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Could not attach device properties snapshot to error log, will attach at sending time", (Throwable)e);
        }
        errorLog.setProcessId(Process.myPid());
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null) {
            for (ActivityManager.RunningAppProcessInfo info : activityManager.getRunningAppProcesses()) {
                if (info.pid != Process.myPid()) continue;
                errorLog.setProcessName(info.processName);
            }
        }
        errorLog.setArchitecture(ErrorLogHelper.getArchitecture());
        errorLog.setErrorThreadId(thread.getId());
        errorLog.setErrorThreadName(thread.getName());
        errorLog.setFatal(fatal);
        errorLog.setAppLaunchTimestamp(new Date(initializeTimestamp));
        errorLog.setException(exception);
        ArrayList<Thread> threads = new ArrayList<Thread>(allStackTraces.size());
        for (Map.Entry<java.lang.Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            Thread javaThread = new Thread();
            javaThread.setId(entry.getKey().getId());
            javaThread.setName(entry.getKey().getName());
            javaThread.setFrames(ErrorLogHelper.getModelFramesFromStackTrace(entry.getValue()));
            threads.add(javaThread);
        }
        errorLog.setThreads(threads);
        return errorLog;
    }

    @TargetApi(value=21)
    private static String getArchitecture() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS[0];
        }
        return Build.CPU_ABI;
    }

    @NonNull
    public static synchronized File getErrorStorageDirectory() {
        if (sErrorLogDirectory == null) {
            sErrorLogDirectory = new File(Constants.FILES_PATH, ERROR_DIRECTORY);
            StorageHelper.InternalStorage.mkdir((String)sErrorLogDirectory.getAbsolutePath());
        }
        return sErrorLogDirectory;
    }

    @NonNull
    public static synchronized File getNewMinidumpDirectory() {
        if (sNewMinidumpDirectory == null) {
            File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
            File minidumpDirectory = new File(errorStorageDirectory.getAbsolutePath(), MINIDUMP_DIRECTORY);
            sNewMinidumpDirectory = new File(minidumpDirectory, NEW_MINIDUMP_DIRECTORY);
            StorageHelper.InternalStorage.mkdir((String)sNewMinidumpDirectory.getPath());
        }
        return sNewMinidumpDirectory;
    }

    @NonNull
    public static synchronized File getPendingMinidumpDirectory() {
        if (sPendingMinidumpDirectory == null) {
            File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
            File minidumpDirectory = new File(errorStorageDirectory.getAbsolutePath(), MINIDUMP_DIRECTORY);
            sPendingMinidumpDirectory = new File(minidumpDirectory, PENDING_MINIDUMP_DIRECTORY);
            StorageHelper.InternalStorage.mkdir((String)sPendingMinidumpDirectory.getPath());
        }
        return sPendingMinidumpDirectory;
    }

    @NonNull
    public static File[] getStoredErrorLogFiles() {
        File[] files = ErrorLogHelper.getErrorStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ErrorLogHelper.ERROR_LOG_FILE_EXTENSION);
            }
        });
        return files != null ? files : new File[]{};
    }

    @NonNull
    public static File[] getNewMinidumpFiles() {
        File[] files = ErrorLogHelper.getNewMinidumpDirectory().listFiles();
        return files != null ? files : new File[]{};
    }

    @Nullable
    public static File getLastErrorLogFile() {
        return StorageHelper.InternalStorage.lastModifiedFile((File)ErrorLogHelper.getErrorStorageDirectory(), (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ErrorLogHelper.ERROR_LOG_FILE_EXTENSION);
            }
        });
    }

    @Nullable
    public static File getStoredThrowableFile(@NonNull UUID id) {
        return ErrorLogHelper.getStoredFile(id, THROWABLE_FILE_EXTENSION);
    }

    public static void removeStoredThrowableFile(@NonNull UUID id) {
        File file = ErrorLogHelper.getStoredThrowableFile(id);
        if (file != null) {
            AppCenterLog.info((String)"AppCenterCrashes", (String)("Deleting throwable file " + file.getName()));
            StorageHelper.InternalStorage.delete((File)file);
        }
    }

    @Nullable
    static File getStoredErrorLogFile(@NonNull UUID id) {
        return ErrorLogHelper.getStoredFile(id, ERROR_LOG_FILE_EXTENSION);
    }

    public static void removeStoredErrorLogFile(@NonNull UUID id) {
        File file = ErrorLogHelper.getStoredErrorLogFile(id);
        if (file != null) {
            AppCenterLog.info((String)"AppCenterCrashes", (String)("Deleting error log file " + file.getName()));
            StorageHelper.InternalStorage.delete((File)file);
        }
    }

    @NonNull
    public static ErrorReport getErrorReportFromErrorLog(@NonNull ManagedErrorLog log, Throwable throwable) {
        ErrorReport report = new ErrorReport();
        report.setId(log.getId().toString());
        report.setThreadName(log.getErrorThreadName());
        report.setThrowable(throwable);
        report.setAppStartTime(log.getAppLaunchTimestamp());
        report.setAppErrorTime(log.getTimestamp());
        report.setDevice(log.getDevice());
        return report;
    }

    @VisibleForTesting
    static void setErrorLogDirectory(File file) {
        sErrorLogDirectory = file;
    }

    @Nullable
    private static File getStoredFile(final @NonNull UUID id, final @NonNull String extension) {
        File[] files = ErrorLogHelper.getErrorStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(id.toString()) && filename.endsWith(extension);
            }
        });
        return files != null && files.length > 0 ? files[0] : null;
    }

    @NonNull
    public static Exception getModelExceptionFromThrowable(@NonNull Throwable t) {
        Exception topException = null;
        Exception parentException = null;
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            Exception exception = new Exception();
            exception.setType(cause.getClass().getName());
            exception.setMessage(cause.getMessage());
            exception.setFrames(ErrorLogHelper.getModelFramesFromStackTrace(cause));
            if (topException == null) {
                topException = exception;
            } else {
                parentException.setInnerExceptions(Collections.singletonList(exception));
            }
            parentException = exception;
        }
        return topException;
    }

    @NonNull
    private static List<StackFrame> getModelFramesFromStackTrace(@NonNull Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length > 256) {
            StackTraceElement[] stackTraceTruncated = new StackTraceElement[256];
            System.arraycopy(stackTrace, 0, stackTraceTruncated, 0, 128);
            System.arraycopy(stackTrace, stackTrace.length - 128, stackTraceTruncated, 128, 128);
            throwable.setStackTrace(stackTraceTruncated);
            AppCenterLog.warn((String)"AppCenterCrashes", (String)("Crash frames truncated from " + stackTrace.length + " to " + stackTraceTruncated.length + " frames."));
            stackTrace = stackTraceTruncated;
        }
        return ErrorLogHelper.getModelFramesFromStackTrace(stackTrace);
    }

    @NonNull
    private static List<StackFrame> getModelFramesFromStackTrace(@NonNull StackTraceElement[] stackTrace) {
        ArrayList<StackFrame> stackFrames = new ArrayList<StackFrame>();
        for (StackTraceElement stackTraceElement : stackTrace) {
            stackFrames.add(ErrorLogHelper.getModelStackFrame(stackTraceElement));
        }
        return stackFrames;
    }

    @NonNull
    private static StackFrame getModelStackFrame(StackTraceElement stackTraceElement) {
        StackFrame stackFrame = new StackFrame();
        stackFrame.setClassName(stackTraceElement.getClassName());
        stackFrame.setMethodName(stackTraceElement.getMethodName());
        stackFrame.setLineNumber(stackTraceElement.getLineNumber());
        stackFrame.setFileName(stackTraceElement.getFileName());
        return stackFrame;
    }

    public static Map<String, String> validateProperties(Map<String, String> properties, String logType) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String message;
            String key = property.getKey();
            String value = property.getValue();
            if (result.size() >= 5) {
                message = String.format("%s : properties cannot contain more than %s items. Skipping other properties.", logType, 5);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                break;
            }
            if (key == null || key.isEmpty()) {
                message = String.format("%s : a property key cannot be null or empty. Property will be skipped.", logType);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                continue;
            }
            if (value == null) {
                message = String.format("%s : property '%s' : property value cannot be null. Property '%s' will be skipped.", logType, key, key);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                continue;
            }
            if (key.length() > 64) {
                message = String.format("%s : property '%s' : property key length cannot be longer than %s characters. Property key will be truncated.", logType, key, 64);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                key = key.substring(0, 64);
            }
            if (value.length() > 64) {
                message = String.format("%s : property '%s' : property value cannot be longer than %s characters. Property value will be truncated.", logType, key, 64);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                value = value.substring(0, 64);
            }
            result.put(key, value);
        }
        return result;
    }
}

