/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.auth;

import android.accounts.NetworkErrorException;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.microsoft.appcenter.AbstractAppCenterService;
import com.microsoft.appcenter.AppCenter;
import com.microsoft.appcenter.auth.SignInResult;
import com.microsoft.appcenter.auth.UserInformation;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.http.HttpClient;
import com.microsoft.appcenter.http.HttpException;
import com.microsoft.appcenter.http.HttpUtils;
import com.microsoft.appcenter.http.ServiceCall;
import com.microsoft.appcenter.http.ServiceCallback;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.HandlerUtils;
import com.microsoft.appcenter.utils.NetworkStateHelper;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import com.microsoft.appcenter.utils.context.AbstractTokenContextListener;
import com.microsoft.appcenter.utils.context.AuthTokenContext;
import com.microsoft.appcenter.utils.storage.FileManager;
import com.microsoft.appcenter.utils.storage.SharedPreferencesManager;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.ILoggerCallback;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.exception.MsalUiRequiredException;
import com.microsoft.identity.common.internal.authorities.Authority;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Auth
extends AbstractAppCenterService
implements NetworkStateHelper.Listener {
    @VisibleForTesting
    static final String TAG_DELIMITER = ":";
    @VisibleForTesting
    static final ILoggerCallback AUTHENTICATION_EXTERNAL_LOGGER = new ILoggerCallback(){

        public void log(String tag, Logger.LogLevel logLevel, String message, boolean containsPII) {
            if (!containsPII) {
                String prefixedTag = "AppCenterAuth:" + tag;
                if (Logger.LogLevel.VERBOSE == logLevel) {
                    AppCenterLog.verbose((String)prefixedTag, (String)message);
                } else if (Logger.LogLevel.INFO == logLevel) {
                    AppCenterLog.info((String)prefixedTag, (String)message);
                } else if (Logger.LogLevel.WARNING == logLevel) {
                    AppCenterLog.warn((String)prefixedTag, (String)message);
                } else if (Logger.LogLevel.ERROR == logLevel) {
                    AppCenterLog.error((String)prefixedTag, (String)message);
                }
            }
        }
    };
    @SuppressLint(value={"StaticFieldLeak"})
    private static Auth sInstance;
    private String mConfigUrl = "https://config.appcenter.ms";
    private Context mContext;
    private String mAppSecret;
    private PublicClientApplication mAuthenticationClient;
    private String mAuthorityUrl;
    private String mIdentityScope;
    private ServiceCall mGetConfigCall;
    private Activity mActivity;
    private DefaultAppCenterFuture<SignInResult> mLastSignInFuture;
    private DefaultAppCenterFuture<SignInResult> mLastRefreshFuture;
    private String mHomeAccountIdToRefresh;
    private final AuthTokenContext.Listener mAuthTokenContextListener = new AbstractTokenContextListener(){

        public void onTokenRequiresRefresh(String homeAccountId) {
            boolean networkConnected = NetworkStateHelper.getSharedInstance((Context)Auth.this.mContext).isNetworkConnected();
            Auth.this.refreshToken(homeAccountId, networkConnected);
        }
    };

    public static synchronized Auth getInstance() {
        if (sInstance == null) {
            sInstance = new Auth();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static void setConfigUrl(String configUrl) {
        Auth.getInstance().setInstanceConfigUrl(configUrl);
    }

    public static AppCenterFuture<Boolean> isEnabled() {
        return Auth.getInstance().isInstanceEnabledAsync();
    }

    public static AppCenterFuture<Void> setEnabled(boolean enabled) {
        return Auth.getInstance().setInstanceEnabledAsync(enabled);
    }

    public static AppCenterFuture<SignInResult> signIn() {
        return Auth.getInstance().instanceSignIn();
    }

    public static void signOut() {
        Auth.getInstance().instanceSignOut();
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull Channel channel, String appSecret, String transmissionTargetToken, boolean startedFromApp) {
        this.mContext = context;
        this.mAppSecret = appSecret;
        Logger.getInstance().setLogLevel(Logger.LogLevel.VERBOSE);
        try {
            Logger.getInstance().setExternalLogger(AUTHENTICATION_EXTERNAL_LOGGER);
        }
        catch (Exception e) {
            AppCenterLog.warn((String)"AppCenterAuth", (String)"Enabling MSAL logging failed.", (Throwable)e);
        }
        AuthTokenContext.getInstance().doNotResetAuthAfterStart();
        super.onStarted(context, channel, appSecret, transmissionTargetToken, startedFromApp);
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        if (enabled) {
            AuthTokenContext.getInstance().addListener(this.mAuthTokenContextListener);
            NetworkStateHelper.getSharedInstance((Context)this.mContext).addListener((NetworkStateHelper.Listener)this);
            this.loadConfigurationFromCache();
            this.downloadConfiguration();
        } else {
            AuthTokenContext.getInstance().removeListener(this.mAuthTokenContextListener);
            NetworkStateHelper.getSharedInstance((Context)this.mContext).removeListener((NetworkStateHelper.Listener)this);
            if (this.mGetConfigCall != null) {
                this.mGetConfigCall.cancel();
                this.mGetConfigCall = null;
            }
            this.mAuthenticationClient = null;
            this.mIdentityScope = null;
            this.cancelPendingOperations(new IllegalStateException("Auth is disabled."));
            this.mLastSignInFuture = null;
            this.mLastRefreshFuture = null;
            this.clearCache();
            this.removeTokenAndAccount();
        }
    }

    protected String getGroupName() {
        return "group_auth";
    }

    public String getServiceName() {
        return "Auth";
    }

    protected String getLoggerTag() {
        return "AppCenterAuth";
    }

    public synchronized void onActivityResumed(Activity activity) {
        this.mActivity = activity;
    }

    public synchronized void onActivityPaused(Activity activity) {
        this.mActivity = null;
    }

    public synchronized void onNetworkStateUpdated(boolean connected) {
        if (!connected || this.mHomeAccountIdToRefresh == null) {
            return;
        }
        final String homeAccountId = this.mHomeAccountIdToRefresh;
        this.mHomeAccountIdToRefresh = null;
        this.post(new Runnable(){

            @Override
            public void run() {
                Auth.this.refreshToken(homeAccountId, true);
            }
        });
    }

    private synchronized void setInstanceConfigUrl(String configUrl) {
        this.mConfigUrl = configUrl;
    }

    @WorkerThread
    private synchronized void removeTokenAndAccount() {
        AuthTokenContext authTokenContext = AuthTokenContext.getInstance();
        this.removeAccount(authTokenContext.getHomeAccountId());
        authTokenContext.setAuthToken(null, null, null);
    }

    private synchronized void cancelPendingOperations(Exception exception) {
        if (this.isFutureInProgress((AppCenterFuture<SignInResult>)this.mLastSignInFuture)) {
            this.mLastSignInFuture.complete((Object)new SignInResult(null, exception));
        }
        if (this.isFutureInProgress((AppCenterFuture<SignInResult>)this.mLastRefreshFuture)) {
            this.mLastRefreshFuture.complete((Object)new SignInResult(null, exception));
        }
        this.mHomeAccountIdToRefresh = null;
    }

    private synchronized void downloadConfiguration() {
        HttpClient httpClient = HttpUtils.createHttpClient((Context)this.mContext);
        HashMap<String, String> headers = new HashMap<String, String>();
        String eTag = SharedPreferencesManager.getString((String)"Auth.configFileETag");
        if (eTag != null) {
            headers.put("If-None-Match", eTag);
        }
        String url = String.format("%s/auth/%s.json", this.mConfigUrl, this.mAppSecret);
        this.mGetConfigCall = httpClient.callAsync(url, "GET", headers, new HttpClient.CallTemplate(){

            public String buildRequestBody() {
                return null;
            }

            public void onBeforeCalling(URL url, Map<String, String> headers) {
                if (AppCenter.getLogLevel() <= 2) {
                    String urlString = url.toString().replaceAll(Auth.this.mAppSecret, HttpUtils.hideSecret((String)Auth.this.mAppSecret));
                    AppCenterLog.verbose((String)"AppCenterAuth", (String)("Calling " + urlString + "..."));
                    AppCenterLog.verbose((String)"AppCenterAuth", (String)("Headers: " + headers));
                }
            }
        }, new ServiceCallback(){

            public void onCallSucceeded(final String payload, final Map<String, String> headers) {
                Auth.this.post(new Runnable(){

                    @Override
                    public void run() {
                        Auth.this.processDownloadedConfig(payload, (String)headers.get("ETag"));
                    }
                });
            }

            public void onCallFailed(final Exception e) {
                Auth.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (e instanceof HttpException && ((HttpException)e).getStatusCode() == 304) {
                            Auth.this.processDownloadNotModified();
                        } else {
                            Auth.this.processDownloadError(e);
                        }
                    }
                });
            }
        });
    }

    @WorkerThread
    private synchronized void processDownloadedConfig(String payload, String eTag) {
        boolean continueSignIn = this.isPendingSignInWaitingForConfiguration();
        this.mGetConfigCall = null;
        this.saveConfigFile(payload, eTag);
        AppCenterLog.info((String)"AppCenterAuth", (String)"Configure auth from downloaded configuration.");
        this.initAuthenticationClient(payload);
        if (continueSignIn) {
            this.selectSignInTypeAndSignIn(this.mLastSignInFuture);
        }
    }

    private synchronized void processDownloadNotModified() {
        this.mGetConfigCall = null;
        AppCenterLog.info((String)"AppCenterAuth", (String)"Auth configuration didn't change.");
        if (this.isPendingSignInWaitingForConfiguration()) {
            this.mLastSignInFuture.complete((Object)new SignInResult(null, new IllegalStateException("Cannot load auth configuration from the server.")));
        }
    }

    @WorkerThread
    private void loadConfigurationFromCache() {
        File configFile = this.getConfigFile();
        if (configFile.exists()) {
            AppCenterLog.info((String)"AppCenterAuth", (String)"Configure auth from cached configuration.");
            this.initAuthenticationClient(FileManager.read((File)configFile));
        }
    }

    private synchronized void processDownloadError(Exception e) {
        this.mGetConfigCall = null;
        AppCenterLog.error((String)"AppCenterAuth", (String)"Cannot load auth configuration from the server.", (Throwable)e);
        if (this.isPendingSignInWaitingForConfiguration()) {
            this.mLastSignInFuture.complete((Object)new SignInResult(null, new IllegalStateException("Cannot load auth configuration from the server.")));
        }
    }

    @WorkerThread
    private synchronized void initAuthenticationClient(String configurationPayload) {
        try {
            JSONObject configuration = new JSONObject(configurationPayload);
            String identityScope = configuration.getString("identity_scope");
            String authorityUrl = null;
            String type = null;
            JSONArray authorities = configuration.getJSONArray("authorities");
            for (int i = 0; i < authorities.length(); ++i) {
                JSONObject authority = authorities.getJSONObject(i);
                if (!authority.optBoolean("default")) continue;
                if ("B2C".equals(authority.getString("type"))) {
                    type = "B2C";
                    authorityUrl = authority.getString("authority_url");
                    continue;
                }
                if (!"AAD".equals(authority.getString("type"))) continue;
                type = "AAD";
            }
            if (type == null) {
                throw new IllegalStateException("Cannot find a default b2c or aad authority configured to be the default.");
            }
            this.mAuthenticationClient = new PublicClientApplication(this.mContext, this.getConfigFile());
            this.mAuthorityUrl = authorityUrl != null ? authorityUrl : ((Authority)this.mAuthenticationClient.getConfiguration().getAuthorities().get(0)).getAuthorityURL().toString();
            AppCenterLog.debug((String)"AppCenterAuth", (String)("Authority url=" + this.mAuthorityUrl));
            this.mIdentityScope = identityScope;
            AppCenterLog.info((String)"AppCenterAuth", (String)"Auth service configured successfully.");
        }
        catch (RuntimeException | JSONException e) {
            AppCenterLog.error((String)"AppCenterAuth", (String)"The configuration is invalid.", (Throwable)e);
            this.clearCache();
        }
    }

    @NonNull
    private File getConfigFile() {
        return new File(this.mContext.getFilesDir(), "appcenter/auth/config.json");
    }

    @WorkerThread
    private void saveConfigFile(String payload, String eTag) {
        File file = this.getConfigFile();
        FileManager.mkdir((String)file.getParent());
        try {
            FileManager.write((File)file, (String)payload);
            SharedPreferencesManager.putString((String)"Auth.configFileETag", (String)eTag);
            AppCenterLog.debug((String)"AppCenterAuth", (String)"Auth configuration saved in cache.");
        }
        catch (IOException e) {
            AppCenterLog.warn((String)"AppCenterAuth", (String)"Failed to cache auth configuration.", (Throwable)e);
        }
    }

    @WorkerThread
    private void clearCache() {
        SharedPreferencesManager.remove((String)"Auth.configFileETag");
        FileManager.delete((File)this.getConfigFile());
        AppCenterLog.debug((String)"AppCenterAuth", (String)"Auth configuration cache cleared.");
    }

    private synchronized AppCenterFuture<SignInResult> instanceSignIn() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        if (this.isFutureInProgress((AppCenterFuture<SignInResult>)this.mLastSignInFuture)) {
            future.complete((Object)new SignInResult(null, new IllegalStateException("Sign-in already in progress.")));
            return future;
        }
        if (this.isFutureInProgress((AppCenterFuture<SignInResult>)this.mLastRefreshFuture)) {
            this.mLastRefreshFuture.complete((Object)new SignInResult(null, new CancellationException()));
        }
        this.mLastSignInFuture = future;
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                Auth.this.selectSignInTypeAndSignIn((DefaultAppCenterFuture<SignInResult>)future);
            }
        }, future, new SignInResult(null, new IllegalStateException("Auth is disabled.")));
        return future;
    }

    private void instanceSignOut() {
        this.post(new Runnable(){

            @Override
            public void run() {
                AuthTokenContext authTokenContext = AuthTokenContext.getInstance();
                if (authTokenContext.getAuthToken() == null) {
                    AppCenterLog.warn((String)"AppCenterAuth", (String)"Cannot sign out because a user has not signed in.");
                    return;
                }
                Auth.this.cancelPendingOperations(new CancellationException("User cancelled sign-in."));
                Auth.this.removeTokenAndAccount();
                AppCenterLog.info((String)"AppCenterAuth", (String)"User sign-out succeeded.");
            }
        });
    }

    @WorkerThread
    private void removeAccount(String homeAccountIdentifier) {
        if (this.mAuthenticationClient == null) {
            return;
        }
        IAccount account = this.retrieveAccount(homeAccountIdentifier);
        if (account != null) {
            this.mAuthenticationClient.removeAccount(account, new PublicClientApplication.AccountsRemovedCallback(){

                public void onAccountsRemoved(Boolean isSuccess) {
                    AppCenterLog.debug((String)"AppCenterAuth", (String)String.format("Remove account isSuccess=%s", isSuccess));
                }
            });
        }
    }

    @WorkerThread
    private IAccount retrieveAccount(String id) {
        if (id == null) {
            AppCenterLog.debug((String)"AppCenterAuth", (String)"Cannot retrieve account: user id null.");
            return null;
        }
        IAccount account = this.mAuthenticationClient.getAccount(id, this.mAuthorityUrl);
        if (account == null) {
            AppCenterLog.warn((String)"AppCenterAuth", (String)String.format("Cannot retrieve account: account id is null or missing: %s.", id));
        }
        return account;
    }

    @WorkerThread
    private synchronized void selectSignInTypeAndSignIn(final DefaultAppCenterFuture<SignInResult> future) {
        if (!NetworkStateHelper.getSharedInstance((Context)this.mContext).isNetworkConnected()) {
            future.complete((Object)new SignInResult(null, (Exception)new NetworkErrorException("Sign-in failed. No internet connection.")));
            return;
        }
        if (this.mAuthenticationClient == null) {
            if (this.mGetConfigCall != null) {
                AppCenterLog.info((String)"AppCenterAuth", (String)"Downloading configuration in process. Waiting for it before sign-in.");
            } else {
                future.complete((Object)new SignInResult(null, new IllegalStateException("signIn is called while it's not configured.")));
            }
            return;
        }
        AuthTokenContext authTokenContext = AuthTokenContext.getInstance();
        IAccount account = this.retrieveAccount(authTokenContext.getHomeAccountId());
        if (account != null) {
            this.silentSignIn(future, account, true);
        } else {
            HandlerUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Auth.this.signInInteractively((DefaultAppCenterFuture<SignInResult>)future);
                }
            });
        }
    }

    @UiThread
    private synchronized void signInInteractively(final DefaultAppCenterFuture<SignInResult> future) {
        if (this.mAuthenticationClient != null && this.mActivity != null) {
            AppCenterLog.info((String)"AppCenterAuth", (String)"Signing in using browser.");
            this.mAuthenticationClient.acquireToken(this.mActivity, new String[]{this.mIdentityScope}, new AuthenticationCallback(){

                public void onSuccess(IAuthenticationResult authenticationResult) {
                    Auth.this.handleSignInSuccess((DefaultAppCenterFuture<SignInResult>)future, authenticationResult);
                }

                public void onError(MsalException exception) {
                    Auth.this.handleSignInError((DefaultAppCenterFuture<SignInResult>)future, exception);
                }

                public void onCancel() {
                    Auth.this.handleSignInCancellation((DefaultAppCenterFuture<SignInResult>)future);
                }
            });
        } else {
            future.complete((Object)new SignInResult(null, new IllegalStateException("signIn is called while it's not configured or not in the foreground.")));
        }
    }

    private synchronized void silentSignIn(final DefaultAppCenterFuture<SignInResult> future, @NonNull IAccount account, final boolean withUIFallback) {
        AppCenterLog.info((String)"AppCenterAuth", (String)"Sign in silently in the background.");
        this.mAuthenticationClient.acquireTokenSilentAsync(new String[]{this.mIdentityScope}, account, null, true, new AuthenticationCallback(){

            public void onSuccess(IAuthenticationResult authenticationResult) {
                Auth.this.handleSignInSuccess((DefaultAppCenterFuture<SignInResult>)future, authenticationResult);
            }

            public void onError(MsalException exception) {
                if (withUIFallback && exception instanceof MsalUiRequiredException) {
                    AppCenterLog.info((String)"AppCenterAuth", (String)"No token in cache, proceed with interactive sign-in experience.");
                    Auth.this.postOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Auth.this.signInInteractively((DefaultAppCenterFuture<SignInResult>)future);
                        }
                    });
                } else {
                    Auth.this.handleSignInError((DefaultAppCenterFuture<SignInResult>)future, exception);
                }
            }

            public void onCancel() {
                Auth.this.handleSignInCancellation((DefaultAppCenterFuture<SignInResult>)future);
            }
        });
    }

    @WorkerThread
    private synchronized void refreshToken(String homeAccountId, boolean networkConnected) {
        DefaultAppCenterFuture future;
        if (this.mAuthenticationClient == null) {
            AppCenterLog.warn((String)"AppCenterAuth", (String)"Failed to refresh token: Auth isn't configured.");
            AuthTokenContext.getInstance().setAuthToken(null, null, null);
            return;
        }
        if (this.isFutureInProgress((AppCenterFuture<SignInResult>)this.mLastSignInFuture)) {
            AppCenterLog.debug((String)"AppCenterAuth", (String)"Failed to refresh token: sign-in already in progress.");
            return;
        }
        if (this.isFutureInProgress((AppCenterFuture<SignInResult>)this.mLastRefreshFuture)) {
            AppCenterLog.debug((String)"AppCenterAuth", (String)"Token refresh already in progress. Skip this refresh request.");
            return;
        }
        if (!networkConnected) {
            this.mHomeAccountIdToRefresh = homeAccountId;
            AppCenterLog.debug((String)"AppCenterAuth", (String)"Network not connected. The token will be refreshed after coming back online.");
            return;
        }
        this.mLastRefreshFuture = future = new DefaultAppCenterFuture();
        IAccount account = this.retrieveAccount(homeAccountId);
        if (account != null) {
            this.silentSignIn((DefaultAppCenterFuture<SignInResult>)future, account, false);
        } else {
            AppCenterLog.warn((String)"AppCenterAuth", (String)"Failed to refresh token: unable to retrieve account.");
            AuthTokenContext.getInstance().setAuthToken(null, null, null);
        }
    }

    private void handleSignInSuccess(final @NonNull DefaultAppCenterFuture<SignInResult> future, final IAuthenticationResult authenticationResult) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (future.isDone()) {
                    AppCenterLog.debug((String)"AppCenterAuth", (String)"The future is already completed. Ignoring the result.");
                    return;
                }
                IAccount account = authenticationResult.getAccount();
                String homeAccountId = account.getHomeAccountIdentifier().getIdentifier();
                Date expiresOn = authenticationResult.getExpiresOn();
                String token = authenticationResult.getIdToken();
                if (token == null) {
                    AppCenterLog.warn((String)"AppCenterAuth", (String)"Sign-in result does not contain ID token, using access token.");
                    token = authenticationResult.getAccessToken();
                }
                AuthTokenContext.getInstance().setAuthToken(token, homeAccountId, expiresOn);
                String accessToken = authenticationResult.getAccessToken();
                String accountId = account.getAccountIdentifier().getIdentifier();
                AppCenterLog.info((String)"AppCenterAuth", (String)"User sign-in succeeded.");
                future.complete((Object)new SignInResult(new UserInformation(accountId, accessToken, token), null));
            }
        });
    }

    private void handleSignInError(final @NonNull DefaultAppCenterFuture<SignInResult> future, final MsalException exception) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (future.isDone()) {
                    AppCenterLog.debug((String)"AppCenterAuth", (String)"The future is already completed. Ignoring the result.");
                    return;
                }
                AuthTokenContext.getInstance().setAuthToken(null, null, null);
                AppCenterLog.error((String)"AppCenterAuth", (String)"User sign-in failed.", (Throwable)exception);
                future.complete((Object)new SignInResult(null, (Exception)exception));
            }
        });
    }

    private void handleSignInCancellation(final @NonNull DefaultAppCenterFuture<SignInResult> future) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (future.isDone()) {
                    AppCenterLog.debug((String)"AppCenterAuth", (String)"The future is already completed. Ignoring the result.");
                    return;
                }
                AuthTokenContext.getInstance().setAuthToken(null, null, null);
                AppCenterLog.warn((String)"AppCenterAuth", (String)"User canceled sign-in.");
                future.complete((Object)new SignInResult(null, new CancellationException("User cancelled sign-in.")));
            }
        });
    }

    private boolean isPendingSignInWaitingForConfiguration() {
        return this.mAuthenticationClient == null && this.isFutureInProgress((AppCenterFuture<SignInResult>)this.mLastSignInFuture);
    }

    private boolean isFutureInProgress(AppCenterFuture<SignInResult> future) {
        return future != null && !future.isDone();
    }
}

