/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics.ingestion.models;

import com.microsoft.appcenter.analytics.ingestion.models.LogWithNameAndProperties;
import com.microsoft.appcenter.ingestion.models.json.JSONUtils;
import com.microsoft.appcenter.ingestion.models.properties.TypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.TypedPropertyUtils;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class EventLog
extends LogWithNameAndProperties {
    public static final String TYPE = "event";
    private UUID id;
    private List<TypedProperty> typedProperties;

    public String getType() {
        return TYPE;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public List<TypedProperty> getTypedProperties() {
        return this.typedProperties;
    }

    public void setTypedProperties(List<TypedProperty> typedProperties) {
        this.typedProperties = typedProperties;
    }

    @Override
    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setId(UUID.fromString(object.getString("id")));
        this.setTypedProperties(TypedPropertyUtils.read((JSONObject)object));
    }

    @Override
    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        writer.key("id").value((Object)this.getId());
        JSONUtils.writeArray((JSONStringer)writer, (String)"typedProperties", this.getTypedProperties());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventLog eventLog = (EventLog)((Object)o);
        if (this.id != null ? !this.id.equals(eventLog.id) : eventLog.id != null) {
            return false;
        }
        return this.typedProperties != null ? this.typedProperties.equals(eventLog.typedProperties) : eventLog.typedProperties == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.typedProperties != null ? this.typedProperties.hashCode() : 0);
        return result;
    }
}

