/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics.channel;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import com.microsoft.appcenter.SessionContext;
import com.microsoft.appcenter.analytics.ingestion.models.StartSessionLog;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.StartServiceLog;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.UUIDUtils;
import java.util.Date;
import java.util.UUID;

public class SessionTracker
extends AbstractChannelListener {
    private static final long SESSION_TIMEOUT = 20000L;
    private final Channel mChannel;
    private final String mGroupName;
    private UUID mSid;
    private long mLastQueuedLogTime;
    private Long mLastResumedTime;
    private Long mLastPausedTime;

    public SessionTracker(Channel channel, String groupName) {
        this.mChannel = channel;
        this.mGroupName = groupName;
    }

    public void onPreparingLog(@NonNull Log log, @NonNull String groupName) {
        if (log instanceof StartSessionLog || log instanceof StartServiceLog) {
            return;
        }
        Date timestamp = log.getTimestamp();
        if (timestamp != null) {
            SessionContext.SessionInfo pastSession = SessionContext.getInstance().getSessionAt(timestamp.getTime());
            if (pastSession != null) {
                log.setSid(pastSession.getSessionId());
            }
        } else {
            this.sendStartSessionIfNeeded();
            log.setSid(this.mSid);
            this.mLastQueuedLogTime = SystemClock.elapsedRealtime();
        }
    }

    private void sendStartSessionIfNeeded() {
        if (this.mSid == null || this.hasSessionTimedOut()) {
            this.mSid = UUIDUtils.randomUUID();
            SessionContext.getInstance().addSession(this.mSid);
            this.mLastQueuedLogTime = SystemClock.elapsedRealtime();
            StartSessionLog startSessionLog = new StartSessionLog();
            startSessionLog.setSid(this.mSid);
            this.mChannel.enqueue((Log)startSessionLog, this.mGroupName);
        }
    }

    public void onActivityResumed() {
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)"onActivityResumed");
        this.mLastResumedTime = SystemClock.elapsedRealtime();
        this.sendStartSessionIfNeeded();
    }

    public void onActivityPaused() {
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)"onActivityPaused");
        this.mLastPausedTime = SystemClock.elapsedRealtime();
    }

    public void clearSessions() {
        SessionContext.getInstance().clearSessions();
    }

    private boolean hasSessionTimedOut() {
        boolean noLogSentForLong;
        long now = SystemClock.elapsedRealtime();
        boolean bl = noLogSentForLong = now - this.mLastQueuedLogTime >= 20000L;
        if (this.mLastPausedTime == null) {
            return this.mLastResumedTime == null && noLogSentForLong;
        }
        if (this.mLastResumedTime == null) {
            return noLogSentForLong;
        }
        boolean isBackgroundForLong = this.mLastPausedTime >= this.mLastResumedTime && now - this.mLastPausedTime >= 20000L;
        boolean wasBackgroundForLong = this.mLastResumedTime - Math.max(this.mLastPausedTime, this.mLastQueuedLogTime) >= 20000L;
        AppCenterLog.debug((String)"AppCenterAnalytics", (String)("noLogSentForLong=" + noLogSentForLong + " isBackgroundForLong=" + isBackgroundForLong + " wasBackgroundForLong=" + wasBackgroundForLong));
        return noLogSentForLong && (isBackgroundForLong || wasBackgroundForLong);
    }
}

