/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.microsoft.appcenter.analytics.Analytics;
import com.microsoft.appcenter.analytics.AuthenticationProvider;
import com.microsoft.appcenter.analytics.PropertyConfigurator;
import com.microsoft.appcenter.channel.AbstractChannelListener;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.one.CommonSchemaLog;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import com.microsoft.appcenter.utils.async.DefaultAppCenterFuture;
import com.microsoft.appcenter.utils.storage.StorageHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class AnalyticsTransmissionTarget {
    @VisibleForTesting
    static AuthenticationProvider sAuthenticationProvider;
    private final String mTransmissionTargetToken;
    final AnalyticsTransmissionTarget mParentTarget;
    private final Map<String, AnalyticsTransmissionTarget> mChildrenTargets = new HashMap<String, AnalyticsTransmissionTarget>();
    private Channel mChannel;
    private PropertyConfigurator mPropertyConfigurator;

    AnalyticsTransmissionTarget(@NonNull String transmissionTargetToken, AnalyticsTransmissionTarget parentTarget, Channel channel) {
        this.mTransmissionTargetToken = transmissionTargetToken;
        this.mParentTarget = parentTarget;
        this.mChannel = channel;
        this.mPropertyConfigurator = new PropertyConfigurator(channel, this);
    }

    public static synchronized void addAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        if (authenticationProvider == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication provider may not be null.");
            return;
        }
        if (authenticationProvider.getType() == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication provider type may not be null.");
            return;
        }
        if (authenticationProvider.getTicketKey() == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication ticket key may not be null.");
            return;
        }
        if (authenticationProvider.getTokenProvider() == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Authentication token provider may not be null.");
            return;
        }
        sAuthenticationProvider = authenticationProvider;
        authenticationProvider.acquireTokenAsync();
    }

    public void trackEvent(String name) {
        this.trackEvent(name, null);
    }

    public void trackEvent(String name, Map<String, String> properties) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        AnalyticsTransmissionTarget target = this;
        while (target != null) {
            target.getPropertyConfigurator().mergeEventProperties(mergedProperties);
            target = target.mParentTarget;
        }
        if (properties != null) {
            mergedProperties.putAll(properties);
        } else if (mergedProperties.isEmpty()) {
            mergedProperties = null;
        }
        Analytics.trackEvent(name, mergedProperties, this);
    }

    public synchronized AnalyticsTransmissionTarget getTransmissionTarget(String transmissionTargetToken) {
        AnalyticsTransmissionTarget childTarget = this.mChildrenTargets.get(transmissionTargetToken);
        if (childTarget == null) {
            childTarget = new AnalyticsTransmissionTarget(transmissionTargetToken, this, this.mChannel);
            this.mChildrenTargets.put(transmissionTargetToken, childTarget);
        }
        return childTarget;
    }

    public AppCenterFuture<Boolean> isEnabledAsync() {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        Analytics.getInstance().postCommand(new Runnable(){

            @Override
            public void run() {
                future.complete((Object)AnalyticsTransmissionTarget.this.isEnabled());
            }
        }, future, false);
        return future;
    }

    public AppCenterFuture<Void> setEnabledAsync(final boolean enabled) {
        final DefaultAppCenterFuture future = new DefaultAppCenterFuture();
        Analytics.getInstance().postCommand(new Runnable(){

            @Override
            public void run() {
                if (AnalyticsTransmissionTarget.this.areAncestorsEnabled()) {
                    LinkedList<AnalyticsTransmissionTarget> descendantTargets = new LinkedList<AnalyticsTransmissionTarget>();
                    descendantTargets.add(AnalyticsTransmissionTarget.this);
                    while (!descendantTargets.isEmpty()) {
                        ListIterator<AnalyticsTransmissionTarget> descendantIterator = descendantTargets.listIterator();
                        while (descendantIterator.hasNext()) {
                            AnalyticsTransmissionTarget descendantTarget = (AnalyticsTransmissionTarget)descendantIterator.next();
                            descendantIterator.remove();
                            StorageHelper.PreferencesStorage.putBoolean((String)descendantTarget.getEnabledPreferenceKey(), (boolean)enabled);
                            for (AnalyticsTransmissionTarget childTarget : descendantTarget.mChildrenTargets.values()) {
                                descendantIterator.add(childTarget);
                            }
                        }
                    }
                } else {
                    AppCenterLog.error((String)"AppCenterAnalytics", (String)"One of the parent transmission target is disabled, cannot change state.");
                }
                future.complete(null);
            }
        }, future, null);
        return future;
    }

    String getTransmissionTargetToken() {
        return this.mTransmissionTargetToken;
    }

    static Channel.Listener getChannelListener() {
        return new AbstractChannelListener(){

            public void onPreparingLog(@NonNull Log log, @NonNull String groupName) {
                AnalyticsTransmissionTarget.addTicketToLog(log);
            }
        };
    }

    private static synchronized void addTicketToLog(@NonNull Log log) {
        if (sAuthenticationProvider != null && log instanceof CommonSchemaLog) {
            CommonSchemaLog csLog = (CommonSchemaLog)log;
            String ticketKey = sAuthenticationProvider.getTicketKeyHash();
            csLog.getExt().getProtocol().setTicketKeys(Collections.singletonList(ticketKey));
            sAuthenticationProvider.checkTokenExpiry();
        }
    }

    @NonNull
    private String getEnabledPreferenceKey() {
        return Analytics.getInstance().getEnabledPreferenceKeyPrefix() + this.mTransmissionTargetToken.split("-")[0];
    }

    @WorkerThread
    private boolean isEnabledInStorage() {
        return StorageHelper.PreferencesStorage.getBoolean((String)this.getEnabledPreferenceKey(), (boolean)true);
    }

    @WorkerThread
    private boolean areAncestorsEnabled() {
        AnalyticsTransmissionTarget target = this.mParentTarget;
        while (target != null) {
            if (!target.isEnabledInStorage()) {
                return false;
            }
            target = target.mParentTarget;
        }
        return true;
    }

    @WorkerThread
    boolean isEnabled() {
        return this.areAncestorsEnabled() && this.isEnabledInStorage();
    }

    public PropertyConfigurator getPropertyConfigurator() {
        return this.mPropertyConfigurator;
    }
}

