/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import android.app.Activity;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import com.microsoft.appcenter.AbstractAppCenterService;
import com.microsoft.appcenter.analytics.channel.AnalyticsListener;
import com.microsoft.appcenter.analytics.channel.SessionTracker;
import com.microsoft.appcenter.analytics.ingestion.models.EventLog;
import com.microsoft.appcenter.analytics.ingestion.models.PageLog;
import com.microsoft.appcenter.analytics.ingestion.models.json.EventLogFactory;
import com.microsoft.appcenter.analytics.ingestion.models.json.PageLogFactory;
import com.microsoft.appcenter.analytics.ingestion.models.json.StartSessionLogFactory;
import com.microsoft.appcenter.channel.Channel;
import com.microsoft.appcenter.ingestion.models.Log;
import com.microsoft.appcenter.ingestion.models.json.LogFactory;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.UUIDUtils;
import com.microsoft.appcenter.utils.async.AppCenterFuture;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class Analytics
extends AbstractAppCenterService {
    private static final String SERVICE_NAME = "Analytics";
    public static final String LOG_TAG = "AppCenterAnalytics";
    private static final String ANALYTICS_GROUP = "group_analytics";
    private static final String ACTIVITY_SUFFIX = "Activity";
    private static final int MAX_PROPERTY_COUNT = 5;
    @VisibleForTesting
    static final int MAX_NAME_LENGTH = 256;
    @VisibleForTesting
    static final int MAX_PROPERTY_ITEM_LENGTH = 64;
    private static Analytics sInstance = null;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private WeakReference<Activity> mCurrentActivity;
    private SessionTracker mSessionTracker;
    private AnalyticsListener mAnalyticsListener;
    private boolean mAutoPageTrackingEnabled = false;

    private Analytics() {
        this.mFactories.put("startSession", new StartSessionLogFactory());
        this.mFactories.put("page", new PageLogFactory());
        this.mFactories.put("event", new EventLogFactory());
    }

    public static synchronized Analytics getInstance() {
        if (sInstance == null) {
            sInstance = new Analytics();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static AppCenterFuture<Boolean> isEnabled() {
        return Analytics.getInstance().isInstanceEnabledAsync();
    }

    public static AppCenterFuture<Void> setEnabled(boolean enabled) {
        return Analytics.getInstance().setInstanceEnabledAsync(enabled);
    }

    @VisibleForTesting
    protected static void setListener(AnalyticsListener listener) {
        Analytics.getInstance().setInstanceListener(listener);
    }

    protected static boolean isAutoPageTrackingEnabled() {
        return Analytics.getInstance().isInstanceAutoPageTrackingEnabled();
    }

    protected static void setAutoPageTrackingEnabled(boolean autoPageTrackingEnabled) {
        Analytics.getInstance().setInstanceAutoPageTrackingEnabled(autoPageTrackingEnabled);
    }

    protected static void trackPage(String name) {
        Analytics.trackPage(name, null);
    }

    protected static void trackPage(String name, Map<String, String> properties) {
        String logType = "Page";
        if ((name = Analytics.validateName(name, "Page")) != null) {
            Map<String, String> validatedProperties = Analytics.validateProperties(properties, name, "Page");
            Analytics.getInstance().trackPageAsync(name, validatedProperties);
        }
    }

    public static void trackEvent(String name) {
        Analytics.trackEvent(name, null);
    }

    public static void trackEvent(String name, Map<String, String> properties) {
        String logType = "Event";
        if ((name = Analytics.validateName(name, "Event")) != null) {
            Map<String, String> validatedProperties = Analytics.validateProperties(properties, name, "Event");
            Analytics.getInstance().trackEventAsync(name, validatedProperties);
        }
    }

    private static String generatePageName(Class<?> activityClass) {
        String suffix;
        String name = activityClass.getSimpleName();
        if (name.endsWith(suffix = ACTIVITY_SUFFIX) && name.length() > suffix.length()) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    private static String validateName(String name, String logType) {
        if (name == null || name.isEmpty()) {
            AppCenterLog.error((String)LOG_TAG, (String)(logType + " name cannot be null or empty."));
            return null;
        }
        if (name.length() > 256) {
            AppCenterLog.warn((String)LOG_TAG, (String)String.format("%s '%s' : name length cannot be longer than %s characters. Name will be truncated.", logType, name, 256));
            name = name.substring(0, 256);
        }
        return name;
    }

    private static Map<String, String> validateProperties(Map<String, String> properties, String logName, String logType) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String message;
            String key = property.getKey();
            String value = property.getValue();
            if (result.size() >= 5) {
                message = String.format("%s '%s' : properties cannot contain more than %s items. Skipping other properties.", logType, logName, 5);
                AppCenterLog.warn((String)LOG_TAG, (String)message);
                break;
            }
            if (key == null || key.isEmpty()) {
                message = String.format("%s '%s' : a property key cannot be null or empty. Property will be skipped.", logType, logName);
                AppCenterLog.warn((String)LOG_TAG, (String)message);
                continue;
            }
            if (value == null) {
                message = String.format("%s '%s' : property '%s' : property value cannot be null. Property '%s' will be skipped.", logType, logName, key, key);
                AppCenterLog.warn((String)LOG_TAG, (String)message);
                continue;
            }
            if (key.length() > 64) {
                message = String.format("%s '%s' : property '%s' : property key length cannot be longer than %s characters. Property key will be truncated.", logType, logName, key, 64);
                AppCenterLog.warn((String)LOG_TAG, (String)message);
                key = key.substring(0, 64);
            }
            if (value.length() > 64) {
                message = String.format("%s '%s' : property '%s' : property value cannot be longer than %s characters. Property value will be truncated.", logType, logName, key, 64);
                AppCenterLog.warn((String)LOG_TAG, (String)message);
                value = value.substring(0, 64);
            }
            result.put(key, value);
        }
        return result;
    }

    protected String getGroupName() {
        return ANALYTICS_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    public synchronized void onActivityResumed(final Activity activity) {
        final Runnable updateCurrentActivityRunnable = new Runnable(){

            @Override
            public void run() {
                Analytics.this.mCurrentActivity = new WeakReference<Activity>(activity);
            }
        };
        this.post(new Runnable(){

            @Override
            public void run() {
                updateCurrentActivityRunnable.run();
                Analytics.this.processOnResume(activity);
            }
        }, updateCurrentActivityRunnable, updateCurrentActivityRunnable);
    }

    private void processOnResume(Activity activity) {
        this.mSessionTracker.onActivityResumed();
        if (this.mAutoPageTrackingEnabled) {
            this.queuePage(Analytics.generatePageName(activity.getClass()), null);
        }
    }

    public synchronized void onActivityPaused(Activity activity) {
        final Runnable updateCurrentActivityRunnable = new Runnable(){

            @Override
            public void run() {
                Analytics.this.mCurrentActivity = null;
            }
        };
        this.post(new Runnable(){

            @Override
            public void run() {
                updateCurrentActivityRunnable.run();
                Analytics.this.mSessionTracker.onActivityPaused();
            }
        }, updateCurrentActivityRunnable, updateCurrentActivityRunnable);
    }

    protected Channel.GroupListener getChannelListener() {
        return new Channel.GroupListener(){

            public void onBeforeSending(Log log) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onBeforeSending(log);
                }
            }

            public void onSuccess(Log log) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onSendingSucceeded(log);
                }
            }

            public void onFailure(Log log, Exception e) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onSendingFailed(log, e);
                }
            }
        };
    }

    protected synchronized void applyEnabledState(boolean enabled) {
        if (enabled) {
            Activity activity;
            this.mSessionTracker = new SessionTracker(this.mChannel, ANALYTICS_GROUP);
            this.mChannel.addListener((Channel.Listener)this.mSessionTracker);
            if (this.mCurrentActivity != null && (activity = (Activity)this.mCurrentActivity.get()) != null) {
                this.processOnResume(activity);
            }
        } else {
            this.mChannel.removeListener((Channel.Listener)this.mSessionTracker);
            this.mSessionTracker.clearSessions();
            this.mSessionTracker = null;
        }
    }

    private synchronized void trackPageAsync(final String name, final Map<String, String> properties) {
        this.post(new Runnable(){

            @Override
            public void run() {
                Analytics.this.queuePage(name, properties);
            }
        });
    }

    @WorkerThread
    private void queuePage(String name, Map<String, String> properties) {
        PageLog pageLog = new PageLog();
        pageLog.setName(name);
        pageLog.setProperties(properties);
        this.mChannel.enqueue((Log)pageLog, ANALYTICS_GROUP);
    }

    private synchronized void trackEventAsync(final String name, final Map<String, String> properties) {
        this.post(new Runnable(){

            @Override
            public void run() {
                EventLog eventLog = new EventLog();
                eventLog.setId(UUIDUtils.randomUUID());
                eventLog.setName(name);
                eventLog.setProperties(properties);
                Analytics.this.mChannel.enqueue((Log)eventLog, Analytics.ANALYTICS_GROUP);
            }
        });
    }

    private boolean isInstanceAutoPageTrackingEnabled() {
        return this.mAutoPageTrackingEnabled;
    }

    private synchronized void setInstanceAutoPageTrackingEnabled(boolean autoPageTrackingEnabled) {
        this.mAutoPageTrackingEnabled = autoPageTrackingEnabled;
    }

    private synchronized void setInstanceListener(AnalyticsListener listener) {
        this.mAnalyticsListener = listener;
    }

    @VisibleForTesting
    WeakReference<Activity> getCurrentActivity() {
        return this.mCurrentActivity;
    }
}

