/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.TokenEntryType;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.util.DateExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class TokenCacheItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "TokenCacheItem";
    private UserInfo mUserInfo;
    private String mResource;
    private String mAuthority;
    private String mClientId;
    private String mAccessToken;
    private String mRefreshtoken;
    private String mRawIdToken;
    private Date mExpiresOn;
    private boolean mIsMultiResourceRefreshToken;
    private String mTenantId;
    private String mFamilyClientId;
    private Date mTokenUpdatedTime;
    private Date mExtendedExpiresOn;
    private String mSpeRing;

    public TokenCacheItem() {
    }

    TokenCacheItem(TokenCacheItem tokenCacheItem) {
        this.mAuthority = tokenCacheItem.getAuthority();
        this.mResource = tokenCacheItem.getResource();
        this.mClientId = tokenCacheItem.getClientId();
        this.mAccessToken = tokenCacheItem.getAccessToken();
        this.mRefreshtoken = tokenCacheItem.getRefreshToken();
        this.mRawIdToken = tokenCacheItem.getRawIdToken();
        this.mUserInfo = tokenCacheItem.getUserInfo();
        this.mExpiresOn = tokenCacheItem.getExpiresOn();
        this.mIsMultiResourceRefreshToken = tokenCacheItem.getIsMultiResourceRefreshToken();
        this.mTenantId = tokenCacheItem.getTenantId();
        this.mFamilyClientId = tokenCacheItem.getFamilyClientId();
        this.mExtendedExpiresOn = tokenCacheItem.getExtendedExpiresOn();
        this.mSpeRing = tokenCacheItem.getSpeRing();
    }

    private TokenCacheItem(String authority, AuthenticationResult authenticationResult) {
        if (authenticationResult == null) {
            throw new IllegalArgumentException("authenticationResult");
        }
        if (StringExtensions.isNullOrBlank((String)authority)) {
            throw new IllegalArgumentException("authority");
        }
        this.mAuthority = authority;
        this.mExpiresOn = authenticationResult.getExpiresOn();
        this.mIsMultiResourceRefreshToken = authenticationResult.getIsMultiResourceRefreshToken();
        this.mTenantId = authenticationResult.getTenantId();
        this.mUserInfo = authenticationResult.getUserInfo();
        this.mRawIdToken = authenticationResult.getIdToken();
        this.mRefreshtoken = authenticationResult.getRefreshToken();
        this.mFamilyClientId = authenticationResult.getFamilyClientId();
        this.mExtendedExpiresOn = authenticationResult.getExtendedExpiresOn();
        if (null != authenticationResult.getCliTelemInfo()) {
            this.mSpeRing = authenticationResult.getCliTelemInfo().getSpeRing();
        }
    }

    public static TokenCacheItem createRegularTokenCacheItem(String authority, String resource, String clientId, AuthenticationResult authResult) {
        TokenCacheItem item = new TokenCacheItem(authority, authResult);
        item.setClientId(clientId);
        item.setResource(resource);
        item.setAccessToken(authResult.getAccessToken());
        return item;
    }

    public static TokenCacheItem createMRRTTokenCacheItem(String authority, String clientId, AuthenticationResult authResult) {
        TokenCacheItem item = new TokenCacheItem(authority, authResult);
        item.setClientId(clientId);
        return item;
    }

    public static TokenCacheItem createFRRTTokenCacheItem(String authority, AuthenticationResult authResult) {
        return new TokenCacheItem(authority, authResult);
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public void setUserInfo(UserInfo info) {
        this.mUserInfo = info;
    }

    public String getResource() {
        return this.mResource;
    }

    public void setResource(String resource) {
        this.mResource = resource;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void setAccessToken(String accessToken) {
        this.mAccessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshtoken;
    }

    public void setRefreshToken(String refreshToken) {
        this.mRefreshtoken = refreshToken;
    }

    public Date getExpiresOn() {
        return DateExtensions.createCopy((Date)this.mExpiresOn);
    }

    public void setExpiresOn(Date expiresOn) {
        this.mExpiresOn = DateExtensions.createCopy((Date)expiresOn);
    }

    public boolean getIsMultiResourceRefreshToken() {
        return this.mIsMultiResourceRefreshToken;
    }

    public void setIsMultiResourceRefreshToken(boolean isMultiResourceRefreshToken) {
        this.mIsMultiResourceRefreshToken = isMultiResourceRefreshToken;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public void setTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public String getRawIdToken() {
        return this.mRawIdToken;
    }

    public void setRawIdToken(String rawIdToken) {
        this.mRawIdToken = rawIdToken;
    }

    public final String getFamilyClientId() {
        return this.mFamilyClientId;
    }

    public final void setFamilyClientId(String familyClientId) {
        this.mFamilyClientId = familyClientId;
    }

    public final void setExtendedExpiresOn(Date extendedExpiresOn) {
        this.mExtendedExpiresOn = DateExtensions.createCopy((Date)extendedExpiresOn);
    }

    public final Date getExtendedExpiresOn() {
        return DateExtensions.createCopy((Date)this.mExtendedExpiresOn);
    }

    public final boolean isExtendedLifetimeValid() {
        if (this.mExtendedExpiresOn != null && !StringExtensions.isNullOrBlank((String)this.mAccessToken)) {
            return !TokenCacheItem.isTokenExpired(this.mExtendedExpiresOn);
        }
        return false;
    }

    protected final Date getTokenUpdateTime() {
        return this.mTokenUpdatedTime;
    }

    final void setTokenUpdateTime(Date tokenUpateTime) {
        this.mTokenUpdatedTime = null == tokenUpateTime ? null : new Date(tokenUpateTime.getTime());
    }

    public static boolean isTokenExpired(Date expiresOn) {
        Calendar calendarWithBuffer = Calendar.getInstance();
        calendarWithBuffer.add(13, AuthenticationSettings.INSTANCE.getExpirationBuffer());
        Date validity = calendarWithBuffer.getTime();
        Logger.i(TAG, "Check token expiration time.", "expiresOn:" + expiresOn + " timeWithBuffer:" + calendarWithBuffer.getTime() + " Buffer:" + AuthenticationSettings.INSTANCE.getExpirationBuffer());
        return expiresOn != null && expiresOn.before(validity);
    }

    TokenEntryType getTokenEntryType() {
        if (!StringExtensions.isNullOrBlank((String)this.getResource())) {
            return TokenEntryType.REGULAR_TOKEN_ENTRY;
        }
        if (StringExtensions.isNullOrBlank((String)this.getClientId())) {
            return TokenEntryType.FRT_TOKEN_ENTRY;
        }
        return TokenEntryType.MRRT_TOKEN_ENTRY;
    }

    boolean isFamilyToken() {
        return !StringExtensions.isNullOrBlank((String)this.mFamilyClientId);
    }

    public String getSpeRing() {
        return this.mSpeRing;
    }

    void setSpeRing(String speRing) {
        this.mSpeRing = speRing;
    }
}

