/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.identity.common.adal.internal.net.HttpWebRequest;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;

class HttpUtil {
    HttpUtil() {
    }

    static void throwIfNetworkNotAvailable(Context context) throws AuthenticationException {
        try {
            HttpWebRequest.throwIfNetworkNotAvailable((Context)context, (boolean)false);
        }
        catch (ClientException e) {
            ADALError error;
            String errorCode = e.getErrorCode();
            String errorMessage = e.getMessage();
            switch (errorCode) {
                case "device_network_not_available_doze_mode": {
                    error = ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION;
                    break;
                }
                case "device_network_not_available": {
                    error = ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE;
                    break;
                }
                default: {
                    error = ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE;
                    Logger.warn((String)"HttpUtil", (String)("Unrecognized error code: " + errorCode));
                }
            }
            throw new AuthenticationException(error, errorMessage);
        }
    }
}

