/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.text.TextUtils;
import com.microsoft.aad.adal.UrlExtensions;
import java.net.URL;
import java.util.Map;
import java.util.UUID;

enum ClientMetrics {
    INSTANCE;

    private static final String CLIENT_METRICS_HEADER_LAST_ERROR = "x-client-last-error";
    private static final String CLIENT_METRICS_HEADER_LAST_REQUEST = "x-client-last-request";
    private static final String CLIENT_METRICS_HEADER_LAST_RESPONSE_TIME = "x-client-last-response-time";
    private static final String CLIENT_METRICS_HEADER_LAST_ENDPOINT = "x-client-last-endpoint";
    private long mStartTimeMillis = 0L;
    private String mLastError;
    private UUID mLastCorrelationId;
    private long mLastResponseTime;
    private String mLastEndpoint;
    private boolean mIsPending = false;
    private URL mQueryUrl;

    public void beginClientMetricsRecord(URL queryUrl, UUID correlationId, Map<String, String> headers) {
        if (UrlExtensions.isADFSAuthority(queryUrl)) {
            this.mLastCorrelationId = null;
            return;
        }
        if (this.mIsPending) {
            this.addClientMetricsHeadersToRequest(headers);
        }
        this.mStartTimeMillis = System.currentTimeMillis();
        this.mQueryUrl = queryUrl;
        this.mLastCorrelationId = correlationId;
        this.mLastError = "";
        this.mIsPending = false;
    }

    public void endClientMetricsRecord(String endpoint, UUID correlationId) {
        if (UrlExtensions.isADFSAuthority(this.mQueryUrl)) {
            return;
        }
        this.mLastEndpoint = endpoint;
        if (this.mStartTimeMillis != 0L) {
            this.mLastResponseTime = System.currentTimeMillis() - this.mStartTimeMillis;
            this.mLastCorrelationId = correlationId;
        }
        this.mIsPending = true;
    }

    public void setLastError(String errorCode) {
        this.mLastError = errorCode == null ? "" : errorCode.replaceAll("[\\[\\]]", "");
    }

    public void setLastErrorCodes(String[] errorCodes) {
        this.mLastError = errorCodes == null ? null : TextUtils.join((CharSequence)",", (Object[])errorCodes);
    }

    private void addClientMetricsHeadersToRequest(Map<String, String> headers) {
        if (this.mLastError != null) {
            headers.put(CLIENT_METRICS_HEADER_LAST_ERROR, this.mLastError);
        }
        if (this.mLastCorrelationId != null) {
            headers.put(CLIENT_METRICS_HEADER_LAST_REQUEST, this.mLastCorrelationId.toString());
        }
        headers.put(CLIENT_METRICS_HEADER_LAST_RESPONSE_TIME, Long.toString(this.mLastResponseTime));
        headers.put(CLIENT_METRICS_HEADER_LAST_ENDPOINT, this.mLastEndpoint);
    }
}

