/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import androidx.annotation.NonNull;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.TokenEntryType;

public final class CacheKey
extends com.microsoft.identity.common.adal.internal.cache.CacheKey {
    public static String createCacheKey(@NonNull TokenCacheItem item) throws AuthenticationException {
        if (item == null) {
            throw new IllegalArgumentException("TokenCacheItem");
        }
        String userid = null;
        if (item.getUserInfo() != null) {
            userid = item.getUserInfo().getUserId();
        }
        TokenEntryType tokenEntryType = item.getTokenEntryType();
        switch (tokenEntryType) {
            case REGULAR_TOKEN_ENTRY: {
                return CacheKey.createCacheKeyForRTEntry((String)item.getAuthority(), (String)item.getResource(), (String)item.getClientId(), (String)userid);
            }
            case MRRT_TOKEN_ENTRY: {
                return CacheKey.createCacheKeyForMRRT((String)item.getAuthority(), (String)item.getClientId(), (String)userid);
            }
            case FRT_TOKEN_ENTRY: {
                return CacheKey.createCacheKeyForFRT((String)item.getAuthority(), (String)item.getFamilyClientId(), (String)userid);
            }
        }
        throw new AuthenticationException(ADALError.INVALID_TOKEN_CACHE_ITEM, "Cannot create cachekey from given token item");
    }
}

