/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import com.google.gson.Gson;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class ApplicationReceiver
extends BroadcastReceiver {
    private static final String TAG = "ApplicationReceiver";
    public static final String INSTALL_REQUEST_TRACK_FILE = "adal.broker.install.track";
    public static final String INSTALL_REQUEST_KEY = "adal.broker.install.request";
    private static final String INSTALL_UPN_KEY = "username";
    public static final String INSTALL_URL_KEY = "app_link";

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.PACKAGE_ADDED")) {
            Logger.v(TAG, "Application install message is received");
            if (intent != null && intent.getData() != null) {
                Logger.v(TAG, "Installing:" + intent.getData().toString());
                if (intent.getData().toString().equalsIgnoreCase("package:" + AuthenticationSettings.INSTANCE.getBrokerPackageName())) {
                    Logger.v(TAG, "Message is related to the broker");
                    String request = ApplicationReceiver.getInstallRequestInthisApp(context);
                    if (!StringExtensions.IsNullOrBlank(request)) {
                        Logger.v(TAG, "Resume request in broker");
                        this.resumeRequestInBroker(context, request);
                    }
                }
            }
        }
    }

    public static void saveRequest(Context ctx, AuthenticationRequest request, String url) {
        SharedPreferences prefs = ctx.getSharedPreferences(INSTALL_REQUEST_TRACK_FILE, 0);
        if (prefs != null) {
            HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
            if (parameters != null && parameters.containsKey(INSTALL_UPN_KEY)) {
                request.setBrokerAccountName(parameters.get(INSTALL_UPN_KEY));
            }
            SharedPreferences.Editor prefsEditor = prefs.edit();
            Gson gson = new Gson();
            String jsonRequest = gson.toJson((Object)request);
            prefsEditor.putString(INSTALL_REQUEST_KEY, jsonRequest);
            prefsEditor.apply();
        }
    }

    public static String getUserName(Context ctx) {
        Gson gson;
        AuthenticationRequest pendingRequest;
        String request = ApplicationReceiver.getInstallRequestInthisApp(ctx);
        if (!StringExtensions.IsNullOrBlank(request) && (pendingRequest = (AuthenticationRequest)(gson = new Gson()).fromJson(request, AuthenticationRequest.class)) != null) {
            return pendingRequest.getBrokerAccountName();
        }
        return null;
    }

    public static void clearUserName(Context ctx) {
        SharedPreferences prefs = ctx.getSharedPreferences(INSTALL_REQUEST_TRACK_FILE, 0);
        if (prefs != null) {
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.putString(INSTALL_REQUEST_KEY, "");
            prefsEditor.apply();
        }
    }

    private void resumeRequestInBroker(Context ctx, String request) {
        boolean isIntentSafe;
        Gson gson = new Gson();
        AuthenticationRequest pendingRequest = (AuthenticationRequest)gson.fromJson(request, AuthenticationRequest.class);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.PICK");
        intent.putExtra("com.microsoft.aadbroker.adal.broker.request", (Serializable)pendingRequest);
        intent.putExtra("caller.info.package", ctx.getPackageName());
        intent.putExtra("com.microsoft.aadbroker.adal.broker.request.resume", "com.microsoft.aadbroker.adal.broker.request.resume");
        intent.setPackage(AuthenticationSettings.INSTANCE.getBrokerPackageName());
        intent.setClassName(AuthenticationSettings.INSTANCE.getBrokerPackageName(), AuthenticationSettings.INSTANCE.getBrokerPackageName() + ".ui.AccountChooserActivity");
        PackageManager packageManager = ctx.getPackageManager();
        List activities = packageManager.queryIntentActivities(intent, 0);
        boolean bl = isIntentSafe = activities.size() > 0;
        if (isIntentSafe) {
            intent.setFlags(0x18000000);
            ctx.startActivity(intent);
        }
    }

    public static String getInstallRequestInthisApp(Context ctx) {
        SharedPreferences prefs = ctx.getSharedPreferences(INSTALL_REQUEST_TRACK_FILE, 0);
        if (prefs != null && prefs.contains(INSTALL_REQUEST_KEY)) {
            String request = prefs.getString(INSTALL_REQUEST_KEY, "");
            Logger.d(TAG, "Install request:" + request);
            return request;
        }
        return "";
    }
}

