/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import android.os.Bundle;
import com.microsoft.aad.adal.ProfileInfo;
import com.microsoft.aad.adal.StringExtensions;
import java.io.Serializable;
import java.util.Date;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 8790127561636702672L;
    private String mVersion;
    private String mUniqueId;
    private String mDisplayableId;
    private String mName;
    private String mIdentityProvider;
    private transient Uri mPasswordChangeUrl;
    private transient Date mPasswordExpiresOn;

    public UserInfo() {
    }

    public UserInfo(String upn) {
        this.mDisplayableId = upn;
    }

    public UserInfo(String userid, String givenName, String identityProvider, String displayableId) {
        this.mUniqueId = userid;
        this.mName = givenName;
        this.mIdentityProvider = identityProvider;
        this.mDisplayableId = displayableId;
    }

    public UserInfo(ProfileInfo profileinfo) {
        if (!StringExtensions.IsNullOrBlank(profileinfo.mVersion)) {
            this.mVersion = profileinfo.mVersion;
        }
        if (!StringExtensions.IsNullOrBlank(profileinfo.mSubject)) {
            this.mUniqueId = profileinfo.mSubject;
        }
        if (!StringExtensions.IsNullOrBlank(profileinfo.mPreferredName)) {
            this.mDisplayableId = profileinfo.mPreferredName;
        }
        if (!StringExtensions.IsNullOrBlank(profileinfo.mName)) {
            this.mName = profileinfo.mName;
        }
    }

    static UserInfo getUserInfoFromBrokerResult(Bundle bundle) {
        String userid = bundle.getString("account.userinfo.userid");
        String givenName = bundle.getString("account.userinfo.given.name");
        String identityProvider = bundle.getString("account.userinfo.identity.provider");
        String displayableId = bundle.getString("account.userinfo.userid.displayable");
        return new UserInfo(userid, givenName, identityProvider, displayableId);
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    void setUniqueId(String userid) {
        this.mUniqueId = userid;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    void setIdentityProvider(String provider) {
        this.mIdentityProvider = provider;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    void setDisplayableId(String displayId) {
        this.mDisplayableId = displayId;
    }

    public Uri getPasswordChangeUrl() {
        return this.mPasswordChangeUrl;
    }

    void setPasswordChangeUrl(Uri passwordChangeUrl) {
        this.mPasswordChangeUrl = passwordChangeUrl;
    }

    public Date getPasswordExpiresOn() {
        return this.mPasswordExpiresOn;
    }

    void setPasswordExpiresOn(Date passwordExpiresOn) {
        this.mPasswordExpiresOn = passwordExpiresOn;
    }
}

