/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.UserIdentifier;
import java.io.Serializable;
import java.util.Set;
import java.util.UUID;

class AuthenticationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int mRequestId = 0;
    private String mAuthority = null;
    private String mRedirectUri = null;
    private String[] mScope = null;
    private String[] mAdditionalScope = null;
    private String mClientId = null;
    private String mBrokerAccountName = null;
    private UUID mCorrelationId;
    private String mExtraQueryParamsAuthentication;
    private PromptBehavior mPrompt;
    private boolean mSilent = false;
    private String mVersion = null;
    private UserIdentifier mUser;
    private String mPolicy = null;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(String authority, String[] scope, String client, String redirect, UserIdentifier user, PromptBehavior prompt, String extraQueryParams, UUID correlationId) {
        this.mAuthority = authority;
        this.mScope = scope;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mBrokerAccountName = user.getDisplayableId();
        this.mPrompt = prompt;
        this.mExtraQueryParamsAuthentication = extraQueryParams;
        this.mCorrelationId = correlationId;
        this.mUser = user;
    }

    public AuthenticationRequest(String authority, String[] scope, String clientid) {
        this.mAuthority = authority;
        this.mScope = scope;
        this.mClientId = clientid;
    }

    public AuthenticationRequest(String authority, String[] scope, String clientid, UserIdentifier user, UUID correlationId) {
        this.mAuthority = authority;
        this.mScope = scope;
        this.mClientId = clientid;
        this.mUser = user;
        this.mCorrelationId = correlationId;
        this.mBrokerAccountName = user.getDisplayableId();
    }

    public AuthenticationRequest(String authority, String[] scope, String clientId, UUID correlationId) {
        this.mAuthority = authority;
        this.mClientId = clientId;
        this.mScope = scope;
        this.mCorrelationId = correlationId;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public String[] getScope() {
        return this.mScope;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getLoginHint() {
        return this.mUser.getDisplayableId();
    }

    public UUID getCorrelationId() {
        return this.mCorrelationId;
    }

    public String getExtraQueryParamsAuthentication() {
        return this.mExtraQueryParamsAuthentication;
    }

    public String getLogInfo() {
        return String.format("Request authority:%s resource:%s clientid:%s", this.mAuthority, StringExtensions.createStringFromArray(this.mScope, " "), this.mClientId);
    }

    public PromptBehavior getPrompt() {
        return this.mPrompt;
    }

    public void setPrompt(PromptBehavior prompt) {
        this.mPrompt = prompt;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public void setRequestId(int requestId) {
        this.mRequestId = requestId;
    }

    public String getBrokerAccountName() {
        return this.mBrokerAccountName;
    }

    public void setBrokerAccountName(String brokerAccountName) {
        this.mBrokerAccountName = brokerAccountName;
    }

    public boolean isSilent() {
        return this.mSilent;
    }

    public void setSilent(boolean silent) {
        this.mSilent = silent;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public UserIdentifier getUserIdentifier() {
        return this.mUser;
    }

    public void setUserIdentifier(UserIdentifier user) {
        this.mUser = user;
    }

    public String[] getDecoratedScopeConsent() {
        return this.getDecoratedScope(this.mAdditionalScope);
    }

    public String[] getDecoratedScopeRequest() {
        return this.getDecoratedScope(null);
    }

    boolean isIdTokenRequest() {
        if (this.mScope != null && this.mScope.length != 0) {
            for (String scope : this.mScope) {
                if (!scope.equalsIgnoreCase("openid") && !scope.equalsIgnoreCase(this.mClientId)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getDecoratedScope(String[] scope2) {
        Set<String> set = StringExtensions.createSet(this.mScope, scope2);
        if (set.contains(this.mClientId)) {
            set.remove(this.mClientId);
        }
        set.add("openid");
        set.add("offline_access");
        set.add("profile");
        return set.toArray(new String[set.size()]);
    }

    public String[] getAdditionalScope() {
        return this.mAdditionalScope;
    }

    public void setAdditionalScope(String[] mAdditionalScope) {
        this.mAdditionalScope = mAdditionalScope;
    }

    public void setPolicy(String policy) {
        this.mPolicy = policy;
    }

    public String getPolicy() {
        return this.mPolicy;
    }
}

