/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Intent;
import android.text.TextUtils;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.ChallangeResponseBuilder;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.StringExtensions;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class WebviewHelper {
    private static final String TAG = "WebviewHelper";
    private Intent mRequestIntent;
    private AuthenticationRequest mRequest;
    private Oauth2 mOauth;

    public WebviewHelper(Intent requestIntent) {
        this.mRequestIntent = requestIntent;
        this.mRequest = this.getAuthenticationRequestFromIntent(this.mRequestIntent);
        this.mOauth = new Oauth2(this.mRequest);
    }

    public void validateRequestIntent() {
        if (this.mRequest == null) {
            Logger.v(TAG, "Request item is null, so it returns to caller");
            throw new IllegalArgumentException("Request is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getAuthority())) {
            throw new IllegalArgumentException("Authority is null");
        }
        if (this.mRequest.getScope() == null || this.mRequest.getScope().length == 0) {
            throw new IllegalArgumentException("Scope is null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getClientId())) {
            throw new IllegalArgumentException("ClientId is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getRedirectUri())) {
            throw new IllegalArgumentException("RedirectUri is null");
        }
    }

    public String getStartUrl() throws UnsupportedEncodingException {
        return this.mOauth.getCodeRequestUrl();
    }

    public String getRedirectUrl() {
        return this.mRequest.getRedirectUri();
    }

    public Intent getResultIntent(String finalUrl) {
        if (this.mRequestIntent != null) {
            AuthenticationRequest authRequest = this.getAuthenticationRequestFromIntent(this.mRequestIntent);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", finalUrl);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)authRequest);
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", authRequest.getRequestId());
            return resultIntent;
        }
        throw new IllegalArgumentException("requestIntent is null");
    }

    private AuthenticationRequest getAuthenticationRequestFromIntent(Intent callingIntent) {
        AuthenticationRequest authRequest = null;
        Serializable request = callingIntent.getSerializableExtra("com.microsoft.aad.adal:BrowserRequestMessage");
        if (request instanceof AuthenticationRequest) {
            authRequest = (AuthenticationRequest)request;
        }
        return authRequest;
    }

    public PreKeyAuthInfo getPreKeyAuthInfo(String challengeUrl) throws UnsupportedEncodingException {
        JWSBuilder jwsBuilder = new JWSBuilder();
        ChallangeResponseBuilder certHandler = new ChallangeResponseBuilder(jwsBuilder);
        ChallangeResponseBuilder.ChallangeResponse challangeResponse = certHandler.getChallangeResponseFromUri(challengeUrl);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", challangeResponse.mAuthorizationHeaderValue);
        String loadUrl = challangeResponse.mSubmitUrl;
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(challangeResponse.mSubmitUrl);
        Logger.v(TAG, "SubmitUrl:" + challangeResponse.mSubmitUrl);
        if (!parameters.containsKey("client_id")) {
            loadUrl = loadUrl + "?" + this.mOauth.getAuthorizationEndpointQueryParameters();
        }
        PreKeyAuthInfo preKeyAuthInfo = new PreKeyAuthInfo(headers, loadUrl);
        return preKeyAuthInfo;
    }

    public static class PreKeyAuthInfo {
        private HashMap<String, String> mHttpHeaders;
        private String mLoadUrl;

        public PreKeyAuthInfo(HashMap<String, String> httpHeaders, String loadUrl) {
            this.mHttpHeaders = httpHeaders;
            this.mLoadUrl = loadUrl;
        }

        public HashMap<String, String> getHttpHeaders() {
            return this.mHttpHeaders;
        }

        public String getLoadUrl() {
            return this.mLoadUrl;
        }
    }
}

