/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.text.TextUtils;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

final class TokenCacheKey
implements Serializable {
    private static final long serialVersionUID = 8067972995583126404L;
    private static final String TAG = "TokenCacheKey";
    private String mAuthority = "";
    private String[] mScope;
    private String mClientId = "";
    private String mUniqueId = "";
    private String mDisplayableId = "";
    private boolean mIsMultipleResourceRefreshToken;
    private String mPolicy = "";

    private TokenCacheKey() {
    }

    public String toJsonString() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("a", (Object)this.mAuthority);
        obj.put("s", (Object)StringExtensions.createStringFromArray(this.mScope, " "));
        obj.put("c", (Object)this.mClientId);
        obj.put("u", (Object)this.mUniqueId);
        obj.put("d", (Object)this.mDisplayableId);
        obj.put("mr", this.mIsMultipleResourceRefreshToken);
        obj.put("p", (Object)this.mPolicy);
        return obj.toString();
    }

    public String getLog() {
        StringBuilder sb = new StringBuilder();
        sb.append("Authority:" + this.mAuthority);
        sb.append(" scope:" + StringExtensions.createStringFromArray(this.mScope, " "));
        sb.append(" clientid:" + this.mClientId);
        sb.append(" uniqueid:" + this.mUniqueId);
        sb.append(" mrrt:" + this.mIsMultipleResourceRefreshToken);
        sb.append(" p:" + this.mPolicy);
        return sb.toString();
    }

    public static TokenCacheKey createCacheKey(String authority, String[] scope, String policy, String clientId, boolean isMultiResourceRefreshToken, String uniqueId, String displayableId) {
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("clientId");
        }
        TokenCacheKey key = new TokenCacheKey();
        key.mScope = scope;
        key.mAuthority = authority.toLowerCase(Locale.US);
        if (key.mAuthority.endsWith("/")) {
            key.mAuthority = (String)key.mAuthority.subSequence(0, key.mAuthority.length() - 1);
        }
        key.mClientId = clientId.toLowerCase(Locale.US);
        key.mIsMultipleResourceRefreshToken = isMultiResourceRefreshToken;
        if (!StringExtensions.IsNullOrBlank(uniqueId)) {
            key.mUniqueId = uniqueId.toLowerCase(Locale.US);
        }
        if (!StringExtensions.IsNullOrBlank(displayableId)) {
            key.mDisplayableId = displayableId.toLowerCase(Locale.US);
        }
        if (!StringExtensions.IsNullOrBlank(policy)) {
            key.mPolicy = policy;
        }
        return key;
    }

    public static TokenCacheKey createCacheKey(TokenCacheItem item) {
        if (item == null) {
            throw new IllegalArgumentException("TokenCacheItem");
        }
        String uniqueId = "";
        String displayableId = "";
        if (item.getUserInfo() != null) {
            uniqueId = item.getUserInfo().getUniqueId();
            displayableId = item.getUserInfo().getDisplayableId();
        }
        return TokenCacheKey.createCacheKey(item.getAuthority(), item.getScope(), item.getPolicy(), item.getClientId(), item.getIsMultiResourceRefreshToken(), uniqueId, displayableId);
    }

    public static TokenCacheKey createCacheKey(AuthenticationRequest item) {
        if (item == null) {
            throw new IllegalArgumentException("AuthenticationRequest");
        }
        return TokenCacheKey.createCacheKey(item.getAuthority(), item.getScope(), item.getPolicy(), item.getClientId(), false, item.getUserIdentifier().getUniqueId(), item.getUserIdentifier().getDisplayableId());
    }

    public static TokenCacheKey createMultiResourceRefreshTokenKey(AuthenticationRequest item, String cacheUniqueID, String cacheDispId) {
        if (item == null) {
            throw new IllegalArgumentException("AuthenticationRequest");
        }
        return TokenCacheKey.createCacheKey(item.getAuthority(), item.getScope(), item.getPolicy(), item.getClientId(), true, cacheUniqueID, cacheDispId);
    }

    public static TokenCacheKey createCacheKey(AuthenticationRequest request, AuthenticationResult result) {
        String uniqueId = "";
        String displayableId = "";
        if (result.getUserInfo() != null) {
            uniqueId = result.getUserInfo().getUniqueId();
            Logger.v(TAG, "Create key with uniqueid:" + uniqueId);
            displayableId = result.getUserInfo().getDisplayableId();
        }
        return TokenCacheKey.createCacheKey(request.getAuthority(), request.getScope(), request.getPolicy(), request.getClientId(), result.getIsMultiResourceRefreshToken(), uniqueId, displayableId);
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public String[] getScope() {
        return this.mScope;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    public boolean getIsMultipleResourceRefreshToken() {
        return this.mIsMultipleResourceRefreshToken;
    }

    public void setIsMultipleResourceRefreshToken(boolean mrrt) {
        this.mIsMultipleResourceRefreshToken = mrrt;
    }

    public boolean matches(TokenCacheItem item) {
        return !(!this.mAuthority.equalsIgnoreCase(item.getAuthority()) || !this.mClientId.equalsIgnoreCase(item.getClientId()) || !this.mIsMultipleResourceRefreshToken && !this.isScopeIntersect(item.getScope()) || !TextUtils.isEmpty((CharSequence)this.mUniqueId) && item.getUserInfo() != null && !this.mUniqueId.equalsIgnoreCase(item.getUserInfo().getUniqueId()) || !TextUtils.isEmpty((CharSequence)this.mDisplayableId) && item.getUserInfo() != null && !this.mDisplayableId.equalsIgnoreCase(item.getUserInfo().getDisplayableId()) || !TextUtils.isEmpty((CharSequence)this.mPolicy) && !this.mPolicy.equalsIgnoreCase(item.getPolicy()));
    }

    public boolean isUserEmpty() {
        return TextUtils.isEmpty((CharSequence)this.mDisplayableId) && TextUtils.isEmpty((CharSequence)this.mUniqueId);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TokenCacheKey)) {
            return false;
        }
        TokenCacheKey other = (TokenCacheKey)o;
        return this.mAuthority.equalsIgnoreCase(other.getAuthority()) && this.mClientId.equalsIgnoreCase(other.getClientId()) && this.isScopeEquals(other.getScope()) && this.mIsMultipleResourceRefreshToken == other.mIsMultipleResourceRefreshToken && this.mUniqueId.equalsIgnoreCase(other.getUniqueId()) && this.mDisplayableId.equalsIgnoreCase(other.getDisplayableId()) && this.mPolicy.equalsIgnoreCase(other.mPolicy);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + this.mAuthority.hashCode();
        hash = 17 * hash + this.mClientId.hashCode();
        hash = 17 * hash + (this.mScope == null || this.mScope.length == 0 ? 7 : this.mScope.hashCode());
        hash = 17 * hash + (this.mIsMultipleResourceRefreshToken ? 7 : 0);
        hash = 17 * hash + this.mUniqueId.hashCode();
        hash = 17 * hash + this.mDisplayableId.hashCode();
        hash = 17 * hash + this.mPolicy.hashCode();
        return hash;
    }

    private boolean isScopeIntersect(String[] scopes) {
        Set<String> self = StringExtensions.createSet(this.mScope);
        if (scopes != null && scopes.length != 0) {
            for (String onescope : scopes) {
                if (!self.contains(onescope.toLowerCase(Locale.US))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isScopeEquals(String[] otherScope) {
        Set<String> self = StringExtensions.createSet(this.mScope);
        Set<String> other = StringExtensions.createSet(otherScope);
        if (self.size() == other.size()) {
            return self.containsAll(other);
        }
        return false;
    }

    void setScope(String[] scope) {
        this.mScope = scope;
    }
}

