/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.UserInfo;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class TokenCacheItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "TokenCacheItem";
    private UserInfo mUserInfo;
    private String[] mScope;
    private String mAuthority;
    private String mClientId;
    private String mAccessToken;
    private String mRefreshtoken;
    private String mRawIdToken;
    private Date mExpiresOn;
    private boolean mIsMultiResourceRefreshToken;
    private String mTenantId;
    private String mPolicy;

    public TokenCacheItem() {
    }

    TokenCacheItem(AuthenticationRequest request, AuthenticationResult result, boolean storeMultiResourceRefreshToken) {
        if (request != null) {
            this.mAuthority = request.getAuthority();
            this.mClientId = request.getClientId();
            this.mPolicy = request.getPolicy();
        }
        if (result != null) {
            this.mRefreshtoken = result.getRefreshToken();
            this.mExpiresOn = result.getExpiresOn();
            this.mIsMultiResourceRefreshToken = storeMultiResourceRefreshToken;
            this.mTenantId = result.getTenantId();
            this.mUserInfo = result.getUserInfo();
            this.mRawIdToken = result.getIdToken();
            this.mAccessToken = result.getAccessToken();
            this.mScope = result.getScopeInResponse();
        }
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public void setUserInfo(UserInfo info) {
        this.mUserInfo = info;
    }

    public String[] getScope() {
        return this.mScope;
    }

    public void setScope(String[] scope) {
        this.mScope = scope;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void setAccessToken(String accessToken) {
        this.mAccessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshtoken;
    }

    public void setRefreshToken(String refreshToken) {
        this.mRefreshtoken = refreshToken;
    }

    public Date getExpiresOn() {
        return this.mExpiresOn;
    }

    public void setExpiresOn(Date expiresOn) {
        this.mExpiresOn = expiresOn;
    }

    public boolean getIsMultiResourceRefreshToken() {
        return this.mIsMultiResourceRefreshToken;
    }

    public void setIsMultiResourceRefreshToken(boolean isMultiResourceRefreshToken) {
        this.mIsMultiResourceRefreshToken = isMultiResourceRefreshToken;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public void setTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public String getRawIdToken() {
        return this.mRawIdToken;
    }

    public void setRawIdToken(String rawIdToken) {
        this.mRawIdToken = rawIdToken;
    }

    public static boolean isTokenExpired(Date expiresOn) {
        Calendar calendarWithBuffer = Calendar.getInstance();
        calendarWithBuffer.add(13, AuthenticationSettings.INSTANCE.getExpirationBuffer());
        Date validity = calendarWithBuffer.getTime();
        Logger.v(TAG, "expiresOn:" + expiresOn + " timeWithBuffer:" + calendarWithBuffer.getTime() + " Buffer:" + AuthenticationSettings.INSTANCE.getExpirationBuffer());
        return expiresOn != null && expiresOn.before(validity);
    }

    public String getPolicy() {
        return this.mPolicy;
    }

    public void setPolicy(String policy) {
        this.mPolicy = policy;
    }
}

