/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.DateTimeAdapter;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StorageHelper;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.TokenCacheKey;
import com.microsoft.aad.adal.TokenCacheNotificationArgs;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;

public class TokenCache
implements ITokenCacheStore {
    private static final String CACHE_BLOB = "CACHE_BLOB";
    private static final long serialVersionUID = 1L;
    private static final String SHARED_PREFERENCE_NAME = "com.microsoft.aad.adal.cache";
    private static final String TAG = "DefaultTokenCacheStore";
    private HashMap<TokenCacheKey, TokenCacheItem> mCacheItems;
    SharedPreferences mPrefs;
    private Context mContext;
    private Gson mGson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTimeAdapter()).create();
    private static StorageHelper sHelper;
    private static Object sLock;
    private static final int TOKEN_VALIDITY_WINDOW = 10;

    public TokenCache() {
        this.mCacheItems = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenCache(Context context) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.mContext = context;
        if (context != null) {
            this.mCacheItems = new HashMap();
            if (!StringExtensions.IsNullOrBlank(AuthenticationSettings.INSTANCE.getSharedPrefPackageName())) {
                try {
                    this.mContext = context.createPackageContext(AuthenticationSettings.INSTANCE.getSharedPrefPackageName(), 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new IllegalArgumentException("Package name:" + AuthenticationSettings.INSTANCE.getSharedPrefPackageName() + " is not found");
                }
            }
        } else {
            throw new IllegalArgumentException("Context is null");
        }
        this.mPrefs = this.mContext.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        Object object = sLock;
        synchronized (object) {
            if (sHelper == null) {
                Logger.v(TAG, "Started to initialize storage helper");
                sHelper = new StorageHelper(this.mContext);
                Logger.v(TAG, "Finished to initialize storage helper");
            }
        }
    }

    private SharedPreferences getSharedPreferences() {
        this.mPrefs = this.mContext.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        return this.mPrefs;
    }

    @Override
    public final String serialize() {
        if (this.mCacheItems != null && !this.mCacheItems.isEmpty()) {
            String cacheJson = this.mGson.toJson((Object)this.mCacheItems.values().toArray(), TokenCacheItem[].class);
            return this.encrypt(cacheJson);
        }
        return "";
    }

    @Override
    public final void deSerialize(String input) {
        try {
            this.mCacheItems = new HashMap();
            if (!TextUtils.isEmpty((CharSequence)input)) {
                String json = sHelper.decrypt(input);
                TokenCacheItem[] items = (TokenCacheItem[])this.mGson.fromJson(json, TokenCacheItem[].class);
                if (items != null && items.length > 0) {
                    for (TokenCacheItem item : items) {
                        TokenCacheKey key = TokenCacheKey.createCacheKey(item);
                        Logger.v(TAG, "Cache key:" + key.toJsonString() + " inserted to TokenCache");
                        this.mCacheItems.put(key, item);
                    }
                }
            } else {
                Logger.v(TAG, "Cache serialization input is empty.");
            }
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), "at serialize", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
        }
    }

    @Override
    public List<TokenCacheItem> readItems() {
        this.beforeAccess(new TokenCacheNotificationArgs());
        return new ArrayList<TokenCacheItem>(this.mCacheItems.values());
    }

    @Override
    public void deleteItem(TokenCacheItem item) {
        TokenCacheKey key = TokenCacheKey.createCacheKey(item);
        TokenCacheNotificationArgs args = TokenCacheNotificationArgs.create(key);
        this.beforeAccess(args);
        this.beforeWrite(args);
        this.mCacheItems.remove(key);
        this.stateChanged();
        this.afterAccess(args);
    }

    @Override
    public void clear() {
        TokenCacheNotificationArgs args = new TokenCacheNotificationArgs();
        this.beforeAccess(args);
        this.beforeWrite(args);
        this.mCacheItems.clear();
        this.stateChanged();
        this.afterAccess(args);
    }

    @Override
    public void beforeAccess(TokenCacheNotificationArgs args) {
    }

    @Override
    public void beforeWrite(TokenCacheNotificationArgs args) {
    }

    @Override
    public void afterAccess(TokenCacheNotificationArgs args) {
    }

    private String encrypt(String value) {
        try {
            return sHelper.encrypt(value);
        }
        catch (Exception e) {
            Logger.e(TAG, "Encryption failure", "", ADALError.ENCRYPTION_FAILED, e);
            return null;
        }
    }

    void removeItem(TokenCacheKey key) {
        this.argumentCheck();
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        TokenCacheNotificationArgs args = new TokenCacheNotificationArgs();
        this.beforeAccess(args);
        this.beforeWrite(args);
        Iterator<Map.Entry<TokenCacheKey, TokenCacheItem>> it = this.mCacheItems.entrySet().iterator();
        TokenCacheKey itemToRemove = null;
        while (it.hasNext()) {
            Map.Entry<TokenCacheKey, TokenCacheItem> pair = it.next();
            TokenCacheItem item = pair.getValue();
            if (!key.matches(item)) continue;
            itemToRemove = pair.getKey();
            break;
        }
        this.mCacheItems.remove(itemToRemove);
        this.stateChanged();
        this.afterAccess(args);
    }

    TokenCacheItem getItem(TokenCacheKey key) {
        this.argumentCheck();
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        TokenCacheNotificationArgs args = TokenCacheNotificationArgs.create(key);
        this.beforeAccess(args);
        Collection<TokenCacheItem> c = this.mCacheItems.values();
        Iterator<TokenCacheItem> itr = c.iterator();
        ArrayList<TokenCacheItem> items = new ArrayList<TokenCacheItem>();
        while (itr.hasNext()) {
            TokenCacheItem item = itr.next();
            if (!key.matches(item)) continue;
            items.add(item);
        }
        if (items.size() > 1 && key.isUserEmpty()) {
            Logger.e(TAG, "Multiple entries in the cache for key:" + key.getLog(), " TokenCache:getItem", ADALError.CACHE_MULTIPLE_ENTRIES);
            throw new AuthenticationException(ADALError.CACHE_MULTIPLE_ENTRIES);
        }
        this.afterAccess(args);
        return !items.isEmpty() ? (TokenCacheItem)items.get(0) : null;
    }

    void setItem(TokenCacheKey key, TokenCacheItem item) {
        this.argumentCheck();
        TokenCacheNotificationArgs args = TokenCacheNotificationArgs.create(key);
        this.beforeAccess(args);
        this.beforeWrite(args);
        this.mCacheItems.put(key, item);
        this.stateChanged();
        this.afterAccess(args);
    }

    private void argumentCheck() {
        if (this.mContext == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_CONTEXT_IS_NOT_PROVIDED);
        }
        if (this.mPrefs == null) {
            throw new AuthenticationException(ADALError.DEVICE_SHARED_PREF_IS_NOT_AVAILABLE);
        }
    }

    private static Calendar getTokenValidityTime() {
        Calendar timeAhead = Calendar.getInstance();
        timeAhead.add(13, 10);
        return timeAhead;
    }

    @Override
    public void stateChanged() {
        String cacheData = this.serialize();
        SharedPreferences.Editor prefsEditor = this.getSharedPreferences().edit();
        prefsEditor.putString(CACHE_BLOB, cacheData);
        prefsEditor.apply();
    }

    void initCache() {
        if (this.mPrefs.contains(CACHE_BLOB)) {
            String json = this.mPrefs.getString(CACHE_BLOB, "");
            this.deSerialize(json);
        }
    }

    static {
        sLock = new Object();
    }
}

