/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class IdToken {
    private static final String TAG = "IdToken";
    private String mSubject;
    private String mTenantId;
    private String mUpn;
    private String mGivenName;
    private String mFamilyName;
    private String mEmail;
    private String mIdentityProvider;
    private String mObjectId;
    private long mPasswordExpiration;
    private String mPasswordChangeUrl;

    public IdToken(String idtoken) throws AuthenticationException {
        HashMap<String, String> responseItems = this.parseJWT(idtoken);
        if (responseItems != null && !responseItems.isEmpty()) {
            this.mSubject = responseItems.get("sub");
            this.mTenantId = responseItems.get("tid");
            this.mUpn = responseItems.get("upn");
            this.mEmail = responseItems.get("email");
            this.mGivenName = responseItems.get("given_name");
            this.mFamilyName = responseItems.get("family_name");
            this.mIdentityProvider = responseItems.get("idp");
            this.mObjectId = responseItems.get("oid");
            String expiration = responseItems.get("pwd_exp");
            if (!StringExtensions.IsNullOrBlank(expiration)) {
                this.mPasswordExpiration = Long.parseLong(expiration);
            }
            this.mPasswordChangeUrl = responseItems.get("pwd_url");
        }
    }

    public String getSubject() {
        return this.mSubject;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public String getUpn() {
        return this.mUpn;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public String getFamilyName() {
        return this.mFamilyName;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    public String getObjectId() {
        return this.mObjectId;
    }

    public long getPasswordExpiration() {
        return this.mPasswordExpiration;
    }

    public String getPasswordChangeUrl() {
        return this.mPasswordChangeUrl;
    }

    private HashMap<String, String> parseJWT(String idtoken) throws AuthenticationException {
        String idbody = this.extractJWTBody(idtoken);
        byte[] data = Base64.decode((String)idbody, (int)8);
        try {
            String decodedBody = new String(data, "UTF-8");
            HashMap<String, String> responseItems = IdToken.extractJsonObjects(decodedBody);
            return responseItems;
        }
        catch (UnsupportedEncodingException exception) {
            Logger.e(TAG, "The encoding is not supported.", "", ADALError.ENCODING_IS_NOT_SUPPORTED, exception);
            throw new AuthenticationException(ADALError.ENCODING_IS_NOT_SUPPORTED, exception.getMessage(), exception);
        }
        catch (JSONException exception) {
            Logger.e(TAG, "Failed to parse the decoded body into JsonObject.", "", ADALError.JSON_PARSE_ERROR, exception);
            throw new AuthenticationException(ADALError.JSON_PARSE_ERROR, exception.getMessage(), exception);
        }
    }

    private String extractJWTBody(String idtoken) throws AuthenticationException {
        int firstDot = idtoken.indexOf(".");
        int secondDot = idtoken.indexOf(".", firstDot + 1);
        int invalidDot = idtoken.indexOf(".", secondDot + 1);
        if (invalidDot == -1 && firstDot > 0 && secondDot > 0) {
            return idtoken.substring(firstDot + 1, secondDot);
        }
        throw new AuthenticationException(ADALError.IDTOKEN_PARSING_FAILURE, "Failed to extract the ClientID");
    }

    private static HashMap<String, String> extractJsonObjects(String jsonStr) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonStr);
        HashMap<String, String> responseItems = new HashMap<String, String>();
        Iterator i = jsonObject.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            responseItems.put(key, jsonObject.getString(key));
        }
        return responseItems;
    }
}

