/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.NetworkOnMainThreadException;
import android.os.Process;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.util.SparseArray;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AcquireTokenSilentHandler;
import com.microsoft.aad.adal.AuthenticationActivity;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationDialog;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationRequestState;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.ClientAnalytics;
import com.microsoft.aad.adal.DefaultTokenCacheStore;
import com.microsoft.aad.adal.Discovery;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.HttpWebRequest;
import com.microsoft.aad.adal.IBrokerProxy;
import com.microsoft.aad.adal.IConnectionService;
import com.microsoft.aad.adal.IDiscovery;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.InstrumentationPropertiesBuilder;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PRNGFixes;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.SSOStateSerializer;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheAccessor;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UsageAuthenticationException;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AuthenticationContext {
    private static final int EXCLUDE_INDEX = 8;
    private static final String TAG = "AuthenticationContext";
    private Context mContext;
    private String mAuthority;
    private boolean mValidateAuthority;
    private boolean mAuthorityValidated = false;
    private ITokenCacheStore mTokenCacheStore;
    private static final ReentrantReadWriteLock RWL = new ReentrantReadWriteLock();
    private static final Lock READ_LOCK = RWL.readLock();
    private static final Lock WRITE_LOCK = RWL.writeLock();
    static SparseArray<AuthenticationRequestState> mDelegateMap = new SparseArray();
    private AuthenticationCallback<AuthenticationResult> mAuthorizationCallback;
    private IDiscovery mDiscovery = new Discovery();
    private IWebRequestHandler mWebRequest = new WebRequestHandler();
    private IJWSBuilder mJWSBuilder;
    private IBrokerProxy mBrokerProxy = null;
    private TokenCacheAccessor mTokenCacheAccessor;
    private UUID mRequestCorrelationId = null;
    private BrokerResumeResultReceiver mBrokerResumeResultReceiver = null;
    private static ExecutorService sThreadExecutor = Executors.newSingleThreadExecutor();
    private Handler mHandler;

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority) {
        PRNGFixes.apply();
        this.initialize(appContext, authority, new DefaultTokenCacheStore(appContext), validateAuthority, true);
    }

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, validateAuthority, false);
    }

    public AuthenticationContext(Context appContext, String authority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, true, false);
    }

    private void initialize(Context appContext, String authority, ITokenCacheStore tokenCacheStore, boolean validateAuthority, boolean defaultCache) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext");
        }
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        this.mBrokerProxy = new BrokerProxy(appContext);
        if (!defaultCache && !this.mBrokerProxy.canUseLocalCache()) {
            throw new UnsupportedOperationException("Local cache is not supported for broker usage");
        }
        this.mContext = appContext;
        this.checkInternetPermission();
        this.mAuthority = AuthenticationContext.extractAuthority(authority);
        this.mValidateAuthority = validateAuthority;
        this.mTokenCacheStore = tokenCacheStore;
        if (this.mTokenCacheStore != null) {
            this.mTokenCacheAccessor = new TokenCacheAccessor(this.mTokenCacheStore, this.mAuthority);
        }
        this.mJWSBuilder = new JWSBuilder();
    }

    public ITokenCacheStore getCache() {
        if (this.mBrokerProxy.canSwitchToBroker()) {
            return new ITokenCacheStore(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setItem(String key, TokenCacheItem item) {
                    throw new UnsupportedOperationException("Broker cache does not support direct setItem operation");
                }

                @Override
                public void removeItem(String key) {
                    throw new UnsupportedOperationException("Broker cache does not support direct removeItem operation");
                }

                @Override
                public void removeAll() {
                    AuthenticationContext.this.mBrokerProxy.removeAccounts();
                }

                @Override
                public TokenCacheItem getItem(String key) {
                    throw new UnsupportedOperationException("Broker cache does not support direct getItem operation");
                }

                @Override
                public boolean contains(String key) {
                    throw new UnsupportedOperationException("Broker cache does not support contains operation");
                }

                @Override
                public Iterator<TokenCacheItem> getAll() {
                    throw new UnsupportedOperationException("Broker cache does not support direct getAll operation");
                }
            };
        }
        return this.mTokenCacheStore;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public boolean getValidateAuthority() {
        return this.mValidateAuthority;
    }

    public String getBrokerUser() {
        if (this.mBrokerProxy != null) {
            return this.mBrokerProxy.getCurrentUser();
        }
        return null;
    }

    public UserInfo[] getBrokerUsers() throws OperationCanceledException, AuthenticatorException, IOException {
        return this.mBrokerProxy != null ? this.mBrokerProxy.getBrokerUsers() : null;
    }

    public String getRedirectUriForBroker() {
        PackageHelper packageHelper = new PackageHelper(this.mContext);
        String packageName = this.mContext.getPackageName();
        String signatureDigest = packageHelper.getCurrentSignatureForPackage(packageName);
        String redirectUri = PackageHelper.getBrokerRedirectUrl(packageName, signatureDigest);
        Logger.v(TAG, "Broker redirectUri:" + redirectUri + " packagename:" + packageName + " signatureDigest:" + signatureDigest);
        return redirectUri;
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String loginHint, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(resource, clientId, redirectUri, PromptBehavior.Auto, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, PromptBehavior.Auto, null, this.getRequestCorrelationId());
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String loginHint, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(resource, clientId, redirectUri, PromptBehavior.Auto, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, PromptBehavior.Auto, extraQueryParameters, this.getRequestCorrelationId());
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, PromptBehavior prompt, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, null, prompt, null, this.getRequestCorrelationId());
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, null, prompt, extraQueryParameters, this.getRequestCorrelationId());
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String loginHint, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(IWindowComponent fragment, String resource, String clientId, String redirectUri, String loginHint, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
        this.acquireTokenLocal(fragment, false, request, callback);
    }

    public void acquireToken(String resource, String clientId, String redirectUri, String loginHint, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(resource, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
        this.acquireTokenLocal(null, true, request, callback);
    }

    private IWindowComponent wrapActivity(final Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity");
        }
        return new IWindowComponent(){
            Activity refActivity;
            {
                this.refActivity = activity;
            }

            @Override
            public void startActivityForResult(Intent intent, int requestCode) {
                if (this.refActivity != null) {
                    this.refActivity.startActivityForResult(intent, requestCode);
                }
            }
        };
    }

    private String checkInputParameters(String resource, String clientId, String redirectUri, PromptBehavior behavior, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.mContext == null) {
            throw new IllegalArgumentException("context", new AuthenticationException(ADALError.DEVELOPER_CONTEXT_IS_NOT_PROVIDED));
        }
        if (StringExtensions.IsNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        if (StringExtensions.IsNullOrBlank(redirectUri)) {
            redirectUri = this.getRedirectFromPackage();
        }
        return redirectUri;
    }

    public AuthenticationResult acquireTokenSilentSync(String resource, String clientId, String userId) throws AuthenticationException, InterruptedException {
        Handler handler;
        final AtomicReference authenticationResult = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        if (StringExtensions.IsNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        Handler handler2 = handler = Looper.myLooper() == null ? this.getHandler() : null;
        if (handler == null) {
            Log.e((String)TAG, (String)"Sync network calls must not be invoked in main thread. This method will throw android.os.NetworkOnMainThreadException in next major release", (Throwable)new NetworkOnMainThreadException());
        }
        this.acquireTokenLocal(null, false, request, handler, new AuthenticationCallback<AuthenticationResult>(){

            @Override
            public void onSuccess(AuthenticationResult result) {
                authenticationResult.set(result);
                latch.countDown();
            }

            @Override
            public void onError(Exception exc) {
                exception.set(exc);
                latch.countDown();
            }
        });
        latch.await();
        Exception e = (Exception)exception.get();
        if (e != null) {
            if (e instanceof AuthenticationException) {
                throw (AuthenticationException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() != null) {
                if (e.getCause() instanceof AuthenticationException) {
                    throw (AuthenticationException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getCause().getMessage(), e.getCause());
            }
            throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getMessage(), e);
        }
        return (AuthenticationResult)authenticationResult.get();
    }

    @Deprecated
    public Future<AuthenticationResult> acquireTokenSilent(String resource, String clientId, String userId, final AuthenticationCallback<AuthenticationResult> callback) {
        if (StringExtensions.IsNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        final SettableFuture<AuthenticationResult> futureTask = new SettableFuture<AuthenticationResult>();
        this.acquireTokenLocal(null, false, request, new AuthenticationCallback<AuthenticationResult>(){

            @Override
            public void onSuccess(AuthenticationResult result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
                futureTask.set(result);
            }

            @Override
            public void onError(Exception exc) {
                if (callback != null) {
                    callback.onError(exc);
                }
                futureTask.setException(exc);
            }
        });
        return futureTask;
    }

    public void acquireTokenSilentAsync(String resource, String clientId, String userId, AuthenticationCallback<AuthenticationResult> callback) {
        if (StringExtensions.IsNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        this.acquireTokenLocal(null, false, request, callback);
    }

    public void acquireTokenByRefreshToken(String refreshToken, String clientId, AuthenticationCallback<AuthenticationResult> callback) {
        this.refreshTokenWithoutCache(refreshToken, clientId, null, callback);
    }

    public void acquireTokenByRefreshToken(String refreshToken, String clientId, String resource, AuthenticationCallback<AuthenticationResult> callback) {
        this.refreshTokenWithoutCache(refreshToken, clientId, resource, callback);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        String methodName = ":onActivityResult";
        if (requestCode == 1001) {
            this.getHandler();
            if (data == null) {
                Logger.e(TAG, "onActivityResult BROWSER_FLOW data is null.", "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
            } else {
                Bundle extras = data.getExtras();
                final int requestId = extras.getInt("com.microsoft.aad.adal:RequestId");
                final AuthenticationRequestState waitingRequest = this.getWaitingRequest(requestId);
                if (waitingRequest == null) {
                    Logger.e(TAG, "onActivityResult did not find waiting request for RequestId:" + requestId, "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
                    return;
                }
                Logger.v(TAG, "onActivityResult RequestId:" + requestId);
                final String correlationInfo = this.getCorrelationInfoFromWaitingRequest(waitingRequest);
                if (resultCode == 2004) {
                    String accessToken = data.getStringExtra("account.access.token");
                    String accountName = data.getStringExtra("account.name");
                    this.mBrokerProxy.saveAccount(accountName);
                    long expireTime = data.getLongExtra("account.expiredate", 0L);
                    Date expire = new Date(expireTime);
                    String idtoken = data.getStringExtra("account.idtoken");
                    String tenantId = data.getStringExtra("account.userinfo.tenantid");
                    UserInfo userinfo = UserInfo.getUserInfoFromBrokerResult(data.getExtras());
                    AuthenticationResult brokerResult = new AuthenticationResult(accessToken, null, expire, false, userinfo, tenantId, idtoken);
                    if (brokerResult != null && brokerResult.getAccessToken() != null) {
                        waitingRequest.mDelagete.onSuccess(brokerResult);
                        return;
                    }
                } else if (resultCode == 2001) {
                    Logger.v(TAG, "User cancelled the flow RequestId:" + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationCancelError("User cancelled the flow RequestId:" + requestId + correlationInfo));
                } else if (resultCode == 2006) {
                    Logger.v("AuthenticationContext:onActivityResult", "Device needs to have broker installed, waiting the broker installation. Once broker is installed, request will be resumed and result will be received");
                    this.mBrokerResumeResultReceiver = new BrokerResumeResultReceiver();
                    new ContextWrapper(this.mContext).registerReceiver((BroadcastReceiver)this.mBrokerResumeResultReceiver, new IntentFilter("com.microsoft.aadbroker.adal.broker.request.resume" + this.mContext.getPackageName()), null, this.mHandler);
                    this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (!AuthenticationContext.this.mBrokerResumeResultReceiver.isResultReceivedFromBroker()) {
                                Logger.v("AuthenticationContextonActivityResult", "BrokerResumeResultReceiver doesn't receive result from broker within 10 minuites, unregister the receiver and cancelling the request");
                                new ContextWrapper(AuthenticationContext.this.mContext).unregisterReceiver((BroadcastReceiver)AuthenticationContext.this.mBrokerResumeResultReceiver);
                                AuthenticationContext.this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationCancelError("Broker doesn't return back the result within 10 minuites"));
                            }
                        }
                    }, 600000L);
                } else if (resultCode == 2005) {
                    Serializable authException = extras.getSerializable("com.microsoft.aad.adal:AuthenticationException");
                    if (authException != null && authException instanceof AuthenticationException) {
                        AuthenticationException exception = (AuthenticationException)authException;
                        Logger.w(TAG, "Webview returned exception", exception.getMessage(), ADALError.WEBVIEW_RETURNED_AUTHENTICATION_EXCEPTION);
                        this.waitingRequestOnError(waitingRequest, requestId, exception);
                    } else {
                        this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.WEBVIEW_RETURNED_INVALID_AUTHENTICATION_EXCEPTION, correlationInfo));
                    }
                } else if (resultCode == 2002) {
                    String errCode = extras.getString("com.microsoft.aad.adal:BrowserErrorCode");
                    String errMessage = extras.getString("com.microsoft.aad.adal:BrowserErrorMessage");
                    Logger.v(TAG, "Error info:" + errCode + " " + errMessage + " for requestId: " + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.SERVER_INVALID_REQUEST, errCode + " " + errMessage + correlationInfo));
                } else if (resultCode == 2003) {
                    final AuthenticationRequest authenticationRequest = (AuthenticationRequest)extras.getSerializable("com.microsoft.aad.adal:BrowserRequestInfo");
                    final String endingUrl = extras.getString("com.microsoft.aad.adal:BrowserFinalUrl", "");
                    if (endingUrl.isEmpty()) {
                        AuthenticationException e = new AuthenticationException(ADALError.WEBVIEW_RETURNED_EMPTY_REDIRECT_URL, "Webview did not reach the redirectUrl. " + authenticationRequest.getLogInfo() + correlationInfo);
                        Logger.e(TAG, e.getMessage(), "", e.getCode());
                        this.waitingRequestOnError(waitingRequest, requestId, e);
                    } else {
                        final CallbackHandler callbackHandle = new CallbackHandler(this.mHandler, waitingRequest.mDelagete);
                        sThreadExecutor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Logger.v(AuthenticationContext.TAG, "Processing url for token. " + authenticationRequest.getLogInfo());
                                Oauth2 oauthRequest = new Oauth2(authenticationRequest, AuthenticationContext.this.mWebRequest);
                                AuthenticationResult result = null;
                                try {
                                    result = oauthRequest.getToken(endingUrl);
                                    Logger.v(AuthenticationContext.TAG, "OnActivityResult processed the result. " + authenticationRequest.getLogInfo());
                                }
                                catch (AuthenticationException | IOException exc) {
                                    String msg = "Error in processing code to get token. " + authenticationRequest.getLogInfo() + correlationInfo;
                                    Logger.e(AuthenticationContext.TAG, msg, ExceptionExtensions.getExceptionMessage(exc), ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, exc);
                                    AuthenticationContext.this.waitingRequestOnError(callbackHandle, waitingRequest, requestId, new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, msg, exc));
                                    return;
                                }
                                try {
                                    if (result != null) {
                                        if (!StringExtensions.IsNullOrBlank(result.getErrorCode())) {
                                            Logger.e(AuthenticationContext.TAG, result.getErrorLogInfo(), null, ADALError.AUTH_FAILED);
                                            callbackHandle.onError(new AuthenticationException(ADALError.AUTH_FAILED, result.getErrorLogInfo()));
                                            return;
                                        }
                                        Logger.v(AuthenticationContext.TAG, "OnActivityResult is setting the token to cache. " + authenticationRequest.getLogInfo());
                                        if (!StringExtensions.IsNullOrBlank(result.getAccessToken()) && AuthenticationContext.this.mTokenCacheAccessor != null) {
                                            AuthenticationContext.this.mTokenCacheAccessor.updateTokenCache(authenticationRequest.getResource(), authenticationRequest.getClientId(), result);
                                        }
                                        if (waitingRequest != null && waitingRequest.mDelagete != null) {
                                            Logger.v(AuthenticationContext.TAG, "Sending result to callback. " + authenticationRequest.getLogInfo());
                                            callbackHandle.onSuccess(result);
                                        }
                                    } else {
                                        callbackHandle.onError(new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, correlationInfo));
                                    }
                                }
                                finally {
                                    AuthenticationContext.this.removeWaitingRequest(requestId);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private String getCorrelationInfoFromWaitingRequest(AuthenticationRequestState waitingRequest) {
        UUID requestCorrelationID = this.getRequestCorrelationId();
        if (waitingRequest.mRequest != null) {
            requestCorrelationID = waitingRequest.mRequest.getCorrelationId();
        }
        String correlationInfo = String.format(" CorrelationId: %s", requestCorrelationID.toString());
        return correlationInfo;
    }

    private void waitingRequestOnError(AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        if (waitingRequest != null && waitingRequest.mDelagete != null) {
            Logger.v(TAG, "Sending error to callback" + this.getCorrelationInfoFromWaitingRequest(waitingRequest));
            waitingRequest.mDelagete.onError(exc);
        }
        if (exc != null && exc.getCode() != ADALError.AUTH_FAILED_CANCELLED) {
            this.removeWaitingRequest(requestId);
        }
    }

    private void waitingRequestOnError(CallbackHandler handler, AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        if (waitingRequest != null && waitingRequest.mDelagete != null) {
            Logger.v(TAG, "Sending error to callback" + this.getCorrelationInfoFromWaitingRequest(waitingRequest));
            handler.onError(exc);
        }
        if (exc != null && exc.getCode() != ADALError.AUTH_FAILED_CANCELLED) {
            this.removeWaitingRequest(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWaitingRequest(int requestId) {
        Logger.v(TAG, "Remove waiting request: " + requestId);
        WRITE_LOCK.lock();
        try {
            mDelegateMap.remove(requestId);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationRequestState getWaitingRequest(int requestId) {
        Logger.v(TAG, "Get waiting request: " + requestId);
        AuthenticationRequestState request = null;
        READ_LOCK.lock();
        try {
            request = (AuthenticationRequestState)mDelegateMap.get(requestId);
        }
        finally {
            READ_LOCK.unlock();
        }
        if (request == null && this.mAuthorizationCallback != null && requestId == this.mAuthorizationCallback.hashCode()) {
            Logger.e(TAG, "Request callback is not available for requestid:" + requestId + ". It will use last callback.", "", ADALError.CALLBACK_IS_NOT_FOUND);
            request = new AuthenticationRequestState(0, null, this.mAuthorizationCallback);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putWaitingRequest(int requestId, AuthenticationRequestState requestState) {
        Logger.v(TAG, "Put waiting request: " + requestId + this.getCorrelationInfoFromWaitingRequest(requestState));
        if (requestState != null) {
            WRITE_LOCK.lock();
            try {
                mDelegateMap.put(requestId, (Object)requestState);
            }
            finally {
                WRITE_LOCK.unlock();
            }
        }
    }

    public boolean cancelAuthenticationActivity(int requestId) {
        AuthenticationRequestState request = this.getWaitingRequest(requestId);
        if (request == null || request.mDelagete == null) {
            Logger.v(TAG, "Current callback is empty. There is not any active authentication.");
            return true;
        }
        String currentCorrelationInfo = this.getCorrelationInfoFromWaitingRequest(request);
        Logger.v(TAG, "Current callback is not empty. There is an active authentication Activity." + currentCorrelationInfo);
        Intent intent = new Intent("com.microsoft.aad.adal:BrowserCancel");
        Bundle extras = new Bundle();
        intent.putExtras(extras);
        intent.putExtra("com.microsoft.aad.adal:RequestId", requestId);
        boolean cancelResult = LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        if (cancelResult) {
            Logger.v(TAG, "Cancel broadcast message was successful." + currentCorrelationInfo);
            request.mCancelled = true;
            request.mDelagete.onError(new AuthenticationCancelError("Cancel broadcast message was successful."));
        } else {
            Logger.w(TAG, "Cancel broadcast message was not successful." + currentCorrelationInfo, "", ADALError.BROADCAST_CANCEL_NOT_SUCCESSFUL);
        }
        return cancelResult;
    }

    private void acquireTokenLocal(IWindowComponent activity, boolean useDialog, AuthenticationRequest request, AuthenticationCallback<AuthenticationResult> externalCall) {
        this.acquireTokenLocal(activity, useDialog, request, this.getHandler(), externalCall);
    }

    private void acquireTokenLocal(final IWindowComponent activity, final boolean useDialog, final AuthenticationRequest request, Handler handler, AuthenticationCallback<AuthenticationResult> externalCall) {
        final CallbackHandler callbackHandle = new CallbackHandler(handler, externalCall);
        Logger.setCorrelationId(this.getRequestCorrelationId());
        Logger.v(TAG, "Sending async task from thread:" + Process.myTid());
        sThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Logger.v(AuthenticationContext.TAG, "Running task in thread:" + Process.myTid());
                AuthenticationContext.this.acquireTokenLocalCall(callbackHandle, activity, useDialog, request);
            }
        });
    }

    private AuthenticationResult acquireTokenLocalCall(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest request) {
        URL authorityUrl = StringExtensions.getUrl(this.mAuthority);
        if (authorityUrl == null) {
            callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL));
            return null;
        }
        if (this.mValidateAuthority && !this.mAuthorityValidated) {
            URL authorityUrlInCallback = authorityUrl;
            boolean result = this.validateAuthority(authorityUrl);
            if (result) {
                this.mAuthorityValidated = true;
                Logger.v(TAG, "Authority is validated: " + authorityUrlInCallback.toString());
            } else {
                Logger.v(TAG, "Call external callback since instance is invalid" + authorityUrlInCallback.toString());
                callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE));
                return null;
            }
        }
        return this.acquireTokenAfterValidation(callbackHandle, activity, useDialog, request);
    }

    private boolean promptUser(PromptBehavior prompt) {
        return prompt == PromptBehavior.Always || prompt == PromptBehavior.REFRESH_SESSION || prompt == PromptBehavior.FORCE_PROMPT;
    }

    private boolean verifyBrokerRedirectUri(AuthenticationRequest request) throws UsageAuthenticationException {
        String methodName = ":verifyBrokerRedirectUri";
        String inputUri = request.getRedirectUri();
        String actualUri = this.getRedirectUriForBroker();
        String errMsg = "";
        if (StringExtensions.IsNullOrBlank(inputUri)) {
            errMsg = "The redirectUri is null or blank. so the redirect uri is expected to be:" + actualUri;
            Logger.e("AuthenticationContext:verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
        }
        if (!inputUri.startsWith("msauth://")) {
            errMsg = "The prefix of the redirect uri does not match the expected value.  The valid broker redirect URI prefix: msauth so the redirect uri is expected to be: " + actualUri;
            Logger.e("AuthenticationContext:verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
        }
        try {
            PackageHelper packageHelper = new PackageHelper(this.mContext);
            String base64URLEncodePackagename = URLEncoder.encode(this.mContext.getPackageName(), "UTF_8");
            String base64URLEncodeSignature = URLEncoder.encode(packageHelper.getCurrentSignatureForPackage(this.mContext.getPackageName()), "UTF_8");
            if (!inputUri.startsWith("msauth://" + base64URLEncodePackagename + "/")) {
                errMsg = "The base64 url encoded package name component of the redirect uri does not match the expected value.  This apps package name is: " + base64URLEncodePackagename + " so the redirect uri is expected to be: " + actualUri;
                Logger.e("AuthenticationContext:verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
                throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
            }
            if (!inputUri.equalsIgnoreCase(actualUri)) {
                errMsg = "The base64 url encoded signature component of the redirect uri does not match the expected value.  This apps signature is: " + base64URLEncodeSignature + " so the redirect uri is expected to be: " + actualUri;
                Logger.e("AuthenticationContext:verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
                throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.e("AuthenticationContext:verifyBrokerRedirectUri", e.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
            throw new UsageAuthenticationException(ADALError.ENCODING_IS_NOT_SUPPORTED, "The verifying BrokerRedirectUri process failed because the base64 url encoding is not supported.", e);
        }
        Logger.v("AuthenticationContext:verifyBrokerRedirectUri", "The broker redirect URI is valid: " + inputUri);
        return true;
    }

    private AuthenticationResult acquireTokenAfterValidation(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest request) {
        String methodName = ":acquireTokenAfterValidation";
        Logger.v(TAG, "Token request started");
        if (this.mBrokerProxy.canSwitchToBroker() && this.mBrokerProxy.verifyUser(request.getLoginHint(), request.getUserId())) {
            Logger.v(TAG, "It switched to broker for context: " + this.mContext.getPackageName());
            AuthenticationResult result = null;
            request.setVersion(AuthenticationContext.getVersionName());
            request.setBrokerAccountName(request.getLoginHint());
            try {
                if (!request.isSilent()) {
                    this.verifyBrokerRedirectUri(request);
                }
            }
            catch (UsageAuthenticationException exception) {
                Logger.v("AuthenticationContext:acquireTokenAfterValidation", "Did not pass the verification of the broker redirect URI");
                callbackHandle.onError(exception);
                return result;
            }
            if (!(this.promptUser(request.getPrompt()) || StringExtensions.IsNullOrBlank(request.getBrokerAccountName()) && StringExtensions.IsNullOrBlank(request.getUserId()))) {
                try {
                    Logger.v(TAG, "User is specified for background token request");
                    result = this.mBrokerProxy.getAuthTokenInBackground(request);
                }
                catch (AuthenticationException ex) {
                    ClientAnalytics.logEvent(new RefreshTokenEvent(new InstrumentationPropertiesBuilder(request, ex), "Fail", true));
                    callbackHandle.onError(ex);
                    return null;
                }
            } else {
                Logger.v(TAG, "User is not specified for background token request");
            }
            if (result != null && result.getAccessToken() != null && !result.getAccessToken().isEmpty()) {
                Logger.v(TAG, "Token is returned from background call ");
                ClientAnalytics.logEvent(new RefreshTokenEvent(new InstrumentationPropertiesBuilder(request, result), "Success", true));
                callbackHandle.onSuccess(result);
                return result;
            }
            Logger.v(TAG, "Token is not returned from backgroud call");
            if (!request.isSilent() && activity != null) {
                Intent brokerIntent;
                Logger.v(TAG, "Launch activity for Authenticator");
                this.mAuthorizationCallback = callbackHandle.callback;
                request.setRequestId(callbackHandle.callback.hashCode());
                Logger.v(TAG, "Starting Authentication Activity with callback:" + callbackHandle.callback.hashCode());
                this.putWaitingRequest(callbackHandle.callback.hashCode(), new AuthenticationRequestState(callbackHandle.callback.hashCode(), request, callbackHandle.callback));
                if (result != null && result.isInitialRequest()) {
                    Logger.v(TAG, "Initial request to authenticator");
                }
                if ((brokerIntent = this.mBrokerProxy.getIntentForBrokerActivity(request)) != null) {
                    try {
                        Logger.v(TAG, "Calling activity pid:" + Process.myPid() + " tid:" + Process.myTid() + "uid:" + Process.myUid());
                        activity.startActivityForResult(brokerIntent, 1001);
                    }
                    catch (ActivityNotFoundException e) {
                        Logger.e(TAG, "Activity login is not found after resolving intent", "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED, e);
                        callbackHandle.onError(new AuthenticationException(ADALError.BROKER_ACTIVITY_IS_NOT_RESOLVED));
                    }
                } else {
                    callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED));
                }
            } else {
                InstrumentationPropertiesBuilder propertiesBuilder = new InstrumentationPropertiesBuilder(request, result).add("ErrorClass", result == null ? "EmptyResponseFromServer" : "AuthTokenNotReturned");
                ClientAnalytics.logEvent(new RefreshTokenEvent(propertiesBuilder, "Fail", true));
                String msg = "Prompt is not allowed and failed to get token:";
                Logger.e(TAG, msg, "", ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED);
                callbackHandle.onError(new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, msg));
            }
            return null;
        }
        return this.localFlow(callbackHandle, activity, useDialog, request);
    }

    private AuthenticationResult localFlow(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest request) {
        AuthenticationResult authResult = null;
        if (!this.promptUser(request.getPrompt())) {
            try {
                AcquireTokenSilentHandler acquireTokenSilentHandler = new AcquireTokenSilentHandler(this.mContext, request, this.mTokenCacheAccessor);
                authResult = acquireTokenSilentHandler.getAccessToken();
            }
            catch (AuthenticationException authenticationException) {
                ClientAnalytics.logEvent(new RefreshTokenEvent(new InstrumentationPropertiesBuilder(request, authenticationException), "Fail"));
                callbackHandle.onError(authenticationException);
                return null;
            }
            if (this.isAccessTokenReturned(authResult)) {
                callbackHandle.onSuccess(authResult);
                ClientAnalytics.logEvent(new RefreshTokenEvent(new InstrumentationPropertiesBuilder(request, authResult), "Success"));
                return authResult;
            }
        }
        if (!this.isAccessTokenReturned(authResult)) {
            String authFailedMessage = "No token returned for silent flow or promptbehavior is set to always.";
            Logger.v(TAG, "No token returned for silent flow or promptbehavior is set to always.");
            InstrumentationPropertiesBuilder propertiesBuilder = new InstrumentationPropertiesBuilder(request, authResult).add("ErrorClass", authResult == null ? "EmptyResponseFromServer" : "AuthTokenNotReturned");
            ClientAnalytics.logEvent(new RefreshTokenEvent(propertiesBuilder, "Fail"));
            if (!request.isSilent() && (activity != null || useDialog)) {
                this.acquireTokenInteractively(callbackHandle, activity, request, useDialog);
            } else {
                String errorInfo = authResult == null ? "" : authResult.getErrorLogInfo();
                Logger.e(TAG, "Prompt is not allowed and failed to get token:", request.getLogInfo() + " " + errorInfo, ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED);
                callbackHandle.onError(new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, request.getLogInfo() + " " + errorInfo));
            }
        }
        return null;
    }

    private void acquireTokenInteractively(CallbackHandler callbackHandle, IWindowComponent activity, AuthenticationRequest request, boolean useDialog) {
        try {
            HttpWebRequest.throwIfNetworkNotAvaliable(this.mContext);
        }
        catch (AuthenticationException exception) {
            callbackHandle.onError(exception);
            return;
        }
        if (PromptBehavior.FORCE_PROMPT == request.getPrompt()) {
            Logger.v(TAG, "FORCE_PRMOPT is set for embeded flow, reset it as Always.");
            request.setPrompt(PromptBehavior.Always);
        }
        this.mAuthorizationCallback = callbackHandle.callback;
        request.setRequestId(callbackHandle.callback.hashCode());
        Logger.v(TAG, "Starting Authentication Activity with callback:" + callbackHandle.callback.hashCode());
        this.putWaitingRequest(callbackHandle.callback.hashCode(), new AuthenticationRequestState(callbackHandle.callback.hashCode(), request, callbackHandle.callback));
        if (useDialog) {
            AuthenticationDialog dialog = new AuthenticationDialog(this.mHandler, this.mContext, this, request);
            dialog.show();
        } else if (!this.startAuthenticationActivity(activity, request)) {
            callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED));
        }
    }

    protected boolean isRefreshable(AuthenticationResult cachedItem) {
        return cachedItem != null && !StringExtensions.IsNullOrBlank(cachedItem.getRefreshToken());
    }

    private boolean validateAuthority(URL authorityUrl) {
        if (this.mDiscovery != null) {
            Logger.v(TAG, "Start validating authority");
            this.mDiscovery.setCorrelationId(this.getRequestCorrelationId());
            boolean result = this.mDiscovery.isValidAuthority(authorityUrl);
            Logger.v(TAG, "Finish validating authority:" + authorityUrl + " result:" + result);
            return result;
        }
        return false;
    }

    private String getRedirectFromPackage() {
        return this.mContext.getApplicationContext().getPackageName();
    }

    private boolean isAccessTokenReturned(AuthenticationResult authResult) {
        return authResult != null && !StringExtensions.IsNullOrBlank(authResult.getAccessToken());
    }

    private boolean startAuthenticationActivity(IWindowComponent activity, AuthenticationRequest request) {
        Intent intent = this.getAuthenticationActivityIntent(activity, request);
        if (!this.resolveIntent(intent)) {
            Logger.e(TAG, "Intent is not resolved", "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED);
            return false;
        }
        try {
            activity.startActivityForResult(intent, 1001);
        }
        catch (ActivityNotFoundException e) {
            Logger.e(TAG, "Activity login is not found after resolving intent", "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED, e);
            return false;
        }
        return true;
    }

    private final boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private final Intent getAuthenticationActivityIntent(IWindowComponent activity, AuthenticationRequest request) {
        Intent intent = new Intent();
        if (AuthenticationSettings.INSTANCE.getActivityPackageName() != null) {
            intent.setClassName(AuthenticationSettings.INSTANCE.getActivityPackageName(), AuthenticationActivity.class.getName());
        } else {
            intent.setClass(this.mContext, AuthenticationActivity.class);
        }
        intent.putExtra("com.microsoft.aad.adal:BrowserRequestMessage", (Serializable)request);
        return intent;
    }

    public UUID getRequestCorrelationId() {
        if (this.mRequestCorrelationId == null) {
            return UUID.randomUUID();
        }
        return this.mRequestCorrelationId;
    }

    public void setRequestCorrelationId(UUID requestCorrelationId) {
        this.mRequestCorrelationId = requestCorrelationId;
        Logger.setCorrelationId(requestCorrelationId);
    }

    private void refreshTokenWithoutCache(final String refreshToken, final String clientId, final String resource, AuthenticationCallback<AuthenticationResult> externalCallback) {
        Logger.setCorrelationId(this.getRequestCorrelationId());
        Logger.v(TAG, "Refresh token without cache");
        if (StringExtensions.IsNullOrBlank(refreshToken)) {
            throw new IllegalArgumentException("Refresh token is not provided");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("ClientId is not provided");
        }
        if (externalCallback == null) {
            throw new IllegalArgumentException("Callback is not provided");
        }
        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), externalCallback);
        sThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AuthenticationResult authResult;
                URL authorityUrl = StringExtensions.getUrl(AuthenticationContext.this.mAuthority);
                if (authorityUrl == null) {
                    callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL));
                    return;
                }
                AuthenticationRequest request = new AuthenticationRequest(AuthenticationContext.this.mAuthority, resource, clientId, AuthenticationContext.this.getRequestCorrelationId());
                request.setSilent(true);
                if (AuthenticationContext.this.mValidateAuthority) {
                    Logger.v(AuthenticationContext.TAG, "Validating authority");
                    if (AuthenticationContext.this.validateAuthority(authorityUrl)) {
                        Logger.v(AuthenticationContext.TAG, "Authority is validated" + authorityUrl.toString());
                    } else {
                        Logger.v(AuthenticationContext.TAG, "Call callback since instance is invalid:" + authorityUrl.toString());
                        callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE));
                        return;
                    }
                }
                try {
                    AcquireTokenSilentHandler acquireTokenSilentHandler = new AcquireTokenSilentHandler(AuthenticationContext.this.mContext, request, AuthenticationContext.this.mTokenCacheAccessor);
                    authResult = acquireTokenSilentHandler.acquireTokenWithRefreshToken(refreshToken);
                }
                catch (AuthenticationException authenticationException) {
                    callbackHandle.onError(authenticationException);
                    return;
                }
                callbackHandle.onSuccess(authResult);
            }
        });
    }

    private synchronized Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.mContext.getMainLooper());
        }
        return this.mHandler;
    }

    private static String extractAuthority(String authority) {
        int fourthSlash;
        int thirdSlash;
        if (!(StringExtensions.IsNullOrBlank(authority) || (thirdSlash = authority.indexOf("/", 8)) < 0 || thirdSlash == authority.length() - 1 || (fourthSlash = authority.indexOf("/", thirdSlash + 1)) >= 0 && fourthSlash <= thirdSlash + 1)) {
            if (fourthSlash >= 0) {
                return authority.substring(0, fourthSlash);
            }
            return authority;
        }
        throw new IllegalArgumentException("authority");
    }

    private void checkInternetPermission() {
        PackageManager pm = this.mContext.getPackageManager();
        if (0 != pm.checkPermission("android.permission.INTERNET", this.mContext.getPackageName())) {
            throw new IllegalStateException(new AuthenticationException(ADALError.DEVELOPER_INTERNET_PERMISSION_MISSING));
        }
    }

    String serialize(String uniqueUserId) throws AuthenticationException {
        if (StringExtensions.IsNullOrBlank(uniqueUserId)) {
            throw new IllegalArgumentException("uniqueUserId");
        }
        if (this.mBrokerProxy.canSwitchToBroker()) {
            throw new UsageAuthenticationException(ADALError.FAIL_TO_EXPORT, "Failed to export the family refresh token cache item because broker is enabled.");
        }
        String cacheKey = CacheKey.createCacheKeyForFRT(this.getAuthority(), "1", uniqueUserId);
        TokenCacheItem tokenItem = this.getCache().getItem(cacheKey);
        if (tokenItem == null) {
            Logger.i(TAG, "Cannot find the family token cache item for this userID", "");
            throw new UsageAuthenticationException(ADALError.FAIL_TO_EXPORT, "Failed to export the FID because no family token cache item is found.");
        }
        if (!StringExtensions.IsNullOrBlank(tokenItem.getFamilyClientId())) {
            return SSOStateSerializer.serialize(tokenItem);
        }
        throw new IllegalArgumentException("tokenItem does not contain family refresh token");
    }

    void deserialize(String serializedBlob) throws AuthenticationException {
        if (StringExtensions.IsNullOrBlank(serializedBlob)) {
            throw new IllegalArgumentException("serializedBlob");
        }
        if (this.mBrokerProxy.canSwitchToBroker()) {
            throw new UsageAuthenticationException(ADALError.FAIL_TO_IMPORT, "Failed to import the serialized blob because broker is enabled.");
        }
        TokenCacheItem tokenCacheItem = SSOStateSerializer.deserialize(serializedBlob);
        String cacheKey = CacheKey.createCacheKey(tokenCacheItem);
        this.getCache().setItem(cacheKey, tokenCacheItem);
    }

    public static String getVersionName() {
        return "1.2.0";
    }

    private static class RefreshTokenEvent
    extends ClientAnalytics.Event {
        private RefreshTokenEvent(InstrumentationPropertiesBuilder builder, String result) {
            this(builder, result, false);
        }

        private RefreshTokenEvent(InstrumentationPropertiesBuilder builder, String result, boolean isBroker) {
            super("RefreshToken", builder.add("Result", result).add("BrokerApp", Boolean.valueOf(isBroker).toString()).build());
        }
    }

    static final class SettableFuture<V>
    extends FutureTask<V> {
        SettableFuture() {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return null;
                }
            });
        }

        @Override
        public void set(V v) {
            super.set(v);
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }
    }

    protected class BrokerResumeResultReceiver
    extends BroadcastReceiver {
        private boolean receivedResultFromBroker = false;

        public void onReceive(Context context, Intent intent) {
            String methodName = ":BrokerResumeResultReceiver:onReceive";
            Logger.d("AuthenticationContext:BrokerResumeResultReceiver:onReceive", "Received result from broker.");
            int receivedWaitingRequestId = intent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
            if (receivedWaitingRequestId == 0) {
                Logger.v("AuthenticationContext:BrokerResumeResultReceiver:onReceive", "Received waiting request is 0, error will be thrown, cannot find correct callback to send back the result.");
                return;
            }
            this.receivedResultFromBroker = true;
            AuthenticationRequestState waitingRequest = AuthenticationContext.this.getWaitingRequest(receivedWaitingRequestId);
            String errorCode = intent.getStringExtra("com.microsoft.aad.adal:BrowserErrorCode");
            if (!StringExtensions.IsNullOrBlank(errorCode)) {
                String errorMessage = intent.getStringExtra("com.microsoft.aad.adal:BrowserErrorMessage");
                String returnedErrorMessage = "ErrorCode: " + errorCode + " ErrorMessage" + errorMessage + AuthenticationContext.this.getCorrelationInfoFromWaitingRequest(waitingRequest);
                Logger.v("AuthenticationContext:BrokerResumeResultReceiver:onReceive", returnedErrorMessage);
                AuthenticationContext.this.waitingRequestOnError(waitingRequest, receivedWaitingRequestId, new AuthenticationException(ADALError.AUTH_FAILED, returnedErrorMessage));
            } else {
                boolean isBrokerCompleteTokenRequest = intent.getBooleanExtra("broker.result.returned", false);
                if (isBrokerCompleteTokenRequest) {
                    Logger.v("AuthenticationContext:BrokerResumeResultReceiver:onReceive", "Broker already completed the token request, calling acquireTokenSilentSync to retrieve token from broker.");
                    AuthenticationRequest authenticationRequest = waitingRequest.mRequest;
                    String userId = intent.getStringExtra("account.userinfo.userid");
                    if (StringExtensions.IsNullOrBlank(userId)) {
                        userId = authenticationRequest.getUserId();
                    }
                    AuthenticationContext.this.acquireTokenSilentAsync(authenticationRequest.getResource(), authenticationRequest.getClientId(), userId, waitingRequest.mDelagete);
                } else {
                    Logger.v("AuthenticationContext:BrokerResumeResultReceiver:onReceive", "Broker doesn't send back error nor the completion notification.");
                    AuthenticationContext.this.waitingRequestOnError(waitingRequest, receivedWaitingRequestId, new AuthenticationException(ADALError.AUTH_FAILED, "Broker doesn't send back error nor the completion notification."));
                }
            }
            new ContextWrapper(AuthenticationContext.this.mContext).unregisterReceiver((BroadcastReceiver)AuthenticationContext.this.mBrokerResumeResultReceiver);
        }

        public boolean isResultReceivedFromBroker() {
            return this.receivedResultFromBroker;
        }
    }

    class DefaultConnectionService
    implements IConnectionService {
        private Context mConnectionContext;

        DefaultConnectionService(Context ctx) {
            this.mConnectionContext = ctx;
        }

        @Override
        public boolean isConnectionAvailable() {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
    }

    private static class CallbackHandler {
        private Handler mRefHandler;
        private AuthenticationCallback<AuthenticationResult> callback;

        public CallbackHandler(Handler ref, AuthenticationCallback<AuthenticationResult> callbackExt) {
            this.mRefHandler = ref;
            this.callback = callbackExt;
        }

        public void onError(final AuthenticationException e) {
            if (this.callback != null) {
                if (this.mRefHandler != null) {
                    this.mRefHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CallbackHandler.this.callback.onError(e);
                        }
                    });
                } else {
                    this.callback.onError(e);
                }
            }
        }

        public void onSuccess(final AuthenticationResult result) {
            if (this.callback != null) {
                if (this.mRefHandler != null) {
                    this.mRefHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CallbackHandler.this.callback.onSuccess(result);
                        }
                    });
                } else {
                    this.callback.onSuccess(result);
                }
            }
        }
    }
}

