/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class JWSBuilder
implements IJWSBuilder {
    private static final long SECONDS_MS = 1000L;
    private static final String JWS_HEADER_ALG = "RS256";
    private static final String JWS_ALGORITHM = "SHA256withRSA";
    private static final String TAG = "JWSBuilder";

    JWSBuilder() {
    }

    @Override
    public String generateJWT(Map<String, String> header, Map<String, String> body, int expTimeInSeconds) throws JSONException, UnsupportedEncodingException {
        Logger.v(TAG, "Generating JWT.");
        JSONObject headerJson = this.generateJson(header, expTimeInSeconds);
        JSONObject bodyJson = this.generateJson(body, expTimeInSeconds);
        String signingInput = StringExtensions.encodeBase64URLSafeString((byte[])headerJson.toString().getBytes("UTF-8")) + "." + StringExtensions.encodeBase64URLSafeString((byte[])bodyJson.toString().getBytes("UTF-8"));
        return signingInput;
    }

    private JSONObject generateJson(Map<String, String> values, int expireSeconds) throws JSONException {
        JSONObject json = new JSONObject();
        long iat = System.currentTimeMillis() / 1000L;
        long expTimeInSeconds = iat + (long)expireSeconds;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("iat") || entry.getKey().equalsIgnoreCase("nbf")) {
                json.put(entry.getKey(), iat);
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("exp")) {
                json.put(entry.getKey(), expTimeInSeconds);
                continue;
            }
            json.put(entry.getKey(), (Object)entry.getValue());
        }
        return json;
    }

    @Override
    public String generateSignedJWT(String nonce, String audience, RSAPrivateKey privateKey, RSAPublicKey pubKey, X509Certificate cert) throws AuthenticationException {
        String signature;
        String signingInput;
        String methodName = ":generateSignedJWT";
        if (StringExtensions.isNullOrBlank((String)nonce)) {
            throw new IllegalArgumentException("nonce");
        }
        if (StringExtensions.isNullOrBlank((String)audience)) {
            throw new IllegalArgumentException("audience");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("pubKey");
        }
        Gson gson = new Gson();
        Claims claims = new Claims();
        claims.mNonce = nonce;
        claims.mAudience = audience;
        claims.mIssueAt = System.currentTimeMillis() / 1000L;
        JwsHeader header = new JwsHeader();
        header.mAlgorithm = JWS_HEADER_ALG;
        header.mType = "JWT";
        try {
            JwsHeader.access$702(header, new String[1]);
            ((JwsHeader)header).mCert[0] = new String(Base64.encode((byte[])cert.getEncoded(), (int)2), "UTF-8");
            String headerJsonString = gson.toJson((Object)header);
            String claimsJsonString = gson.toJson((Object)claims);
            Logger.v("JWSBuilder:generateSignedJWT", "Generate client certificate challenge response JWS Header. ", "Header: " + headerJsonString, null);
            signingInput = StringExtensions.encodeBase64URLSafeString((byte[])headerJsonString.getBytes("UTF-8")) + "." + StringExtensions.encodeBase64URLSafeString((byte[])claimsJsonString.getBytes("UTF-8"));
            signature = JWSBuilder.sign(privateKey, signingInput.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException(ADALError.ENCODING_IS_NOT_SUPPORTED, "Unsupported encoding", e);
        }
        catch (CertificateEncodingException e) {
            throw new AuthenticationException(ADALError.CERTIFICATE_ENCODING_ERROR, "Certificate encoding error", e);
        }
        return signingInput + "." + signature;
    }

    private static String sign(RSAPrivateKey privateKey, byte[] input) throws AuthenticationException {
        try {
            Signature signer = Signature.getInstance(JWS_ALGORITHM);
            signer.initSign(privateKey);
            signer.update(input);
            return StringExtensions.encodeBase64URLSafeString((byte[])signer.sign());
        }
        catch (InvalidKeyException e) {
            throw new AuthenticationException(ADALError.KEY_CHAIN_PRIVATE_KEY_EXCEPTION, "Invalid private RSA key: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new AuthenticationException(ADALError.SIGNATURE_EXCEPTION, "RSA signature exception: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException(ADALError.ENCODING_IS_NOT_SUPPORTED);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthenticationException(ADALError.DEVICE_NO_SUCH_ALGORITHM, "Unsupported RSA algorithm: " + e.getMessage(), e);
        }
    }

    final class JwsHeader {
        @SerializedName(value="alg")
        private String mAlgorithm;
        @SerializedName(value="typ")
        private String mType;
        @SerializedName(value="x5c")
        private String[] mCert;

        private JwsHeader() {
        }

        static /* synthetic */ String[] access$702(JwsHeader x0, String[] x1) {
            x0.mCert = x1;
            return x1;
        }
    }

    final class Claims {
        @SerializedName(value="aud")
        private String mAudience;
        @SerializedName(value="iat")
        private long mIssueAt;
        @SerializedName(value="nonce")
        private String mNonce;

        private Claims() {
        }
    }
}

