/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.security.KeyChain;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.support.v4.content.LocalBroadcastManager;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.ClientCertRequest;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.gson.Gson;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BasicWebViewClient;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.Telemetry;
import com.microsoft.aad.adal.TelemetryUtils;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UIEvent;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.adal.internal.net.IWebRequestHandler;
import com.microsoft.identity.common.adal.internal.net.WebRequestHandler;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.UUID;

@SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
public class AuthenticationActivity
extends Activity {
    static final int BACK_PRESSED_CANCEL_DIALOG_STEPS = -2;
    private static final String TAG = "AuthenticationActivity";
    private boolean mRegisterReceiver = false;
    private WebView mWebView;
    private String mStartUrl;
    private ProgressDialog mSpinner;
    private String mRedirectUrl;
    private AuthenticationRequest mAuthRequest;
    private ActivityBroadcastReceiver mReceiver = null;
    private String mCallingPackage;
    private int mWaitingRequestId;
    private int mCallingUID;
    private AccountAuthenticatorResponse mAccountAuthenticatorResponse = null;
    private Bundle mAuthenticatorResultBundle = null;
    private final IWebRequestHandler mWebRequestHandler = new WebRequestHandler();
    private final IJWSBuilder mJWSBuilder = new JWSBuilder();
    private boolean mPkeyAuthRedirect = false;
    private StorageHelper mStorageHelper;
    private UIEvent mUIEvent = null;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        String methodName = ":onCreate";
        super.onCreate(savedInstanceState);
        this.setContentView(this.getResources().getIdentifier("activity_authentication", "layout", this.getPackageName()));
        CookieSyncManager.createInstance((Context)this.getApplicationContext());
        CookieSyncManager.getInstance().sync();
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        Logger.v("AuthenticationActivity:onCreate", "AuthenticationActivity was created.");
        this.mAuthRequest = this.getAuthenticationRequestFromIntent(this.getIntent());
        if (this.mAuthRequest == null) {
            Logger.d("AuthenticationActivity:onCreate", "Intent for Authentication Activity doesn't have the request details, returning to caller");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Invalid request");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", "Intent does not have request details");
            this.returnToCaller(2002, resultIntent);
            return;
        }
        if (this.mAuthRequest.getAuthority() == null || this.mAuthRequest.getAuthority().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.authority");
            return;
        }
        if (this.mAuthRequest.getResource() == null || this.mAuthRequest.getResource().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.resource");
            return;
        }
        if (this.mAuthRequest.getClientId() == null || this.mAuthRequest.getClientId().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.clientid.key");
            return;
        }
        if (this.mAuthRequest.getRedirectUri() == null || this.mAuthRequest.getRedirectUri().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.redirect");
            return;
        }
        this.mRedirectUrl = this.mAuthRequest.getRedirectUri();
        Telemetry.getInstance().startEvent(this.mAuthRequest.getTelemetryRequestId(), "Microsoft.ADAL.ui_event");
        this.mUIEvent = new UIEvent("Microsoft.ADAL.ui_event");
        this.mUIEvent.setRequestId(this.mAuthRequest.getTelemetryRequestId());
        this.mUIEvent.setCorrelationId(this.mAuthRequest.getCorrelationId().toString());
        this.mWebView = (WebView)this.findViewById(this.getResources().getIdentifier("webView1", "id", this.getPackageName()));
        if (!AuthenticationSettings.INSTANCE.getDisableWebViewHardwareAcceleration()) {
            this.mWebView.setLayerType(1, null);
            Logger.d("AuthenticationActivity:onCreate", "Hardware acceleration is disabled in WebView");
        }
        this.mStartUrl = "about:blank";
        try {
            Oauth2 oauth = new Oauth2(this.mAuthRequest);
            this.mStartUrl = oauth.getCodeRequestUrl();
        }
        catch (UnsupportedEncodingException e) {
            Logger.v("AuthenticationActivity:onCreate", "Encoding format is not supported. ", e.getMessage(), null);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
            this.returnToCaller(2002, resultIntent);
            return;
        }
        Logger.v("AuthenticationActivity:onCreate", "Init broadcastReceiver with request. RequestId:" + this.mAuthRequest.getRequestId(), this.mAuthRequest.getLogInfo(), null);
        this.mReceiver = new ActivityBroadcastReceiver();
        this.mReceiver.mWaitingRequestId = this.mAuthRequest.getRequestId();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
        String userAgent = this.mWebView.getSettings().getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        userAgent = this.mWebView.getSettings().getUserAgentString();
        Logger.v("AuthenticationActivity:onCreate", "", "UserAgent:" + userAgent, null);
        if (this.isBrokerRequest(this.getIntent())) {
            this.mCallingPackage = this.getCallingPackage();
            if (this.mCallingPackage == null) {
                Logger.v("AuthenticationActivity:onCreate", "Calling package is null, startActivityForResult is not used to call this activity");
                Intent resultIntent = new Intent();
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Invalid request");
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", "startActivityForResult is not used to call this activity");
                this.returnToCaller(2002, resultIntent);
                return;
            }
            Logger.i("AuthenticationActivity:onCreate", "It is a broker request for package:" + this.mCallingPackage, "");
            this.mAccountAuthenticatorResponse = (AccountAuthenticatorResponse)this.getIntent().getParcelableExtra("accountAuthenticatorResponse");
            if (this.mAccountAuthenticatorResponse != null) {
                this.mAccountAuthenticatorResponse.onRequestContinued();
            }
            PackageHelper info = new PackageHelper((Context)this);
            this.mCallingPackage = this.getCallingPackage();
            this.mCallingUID = info.getUIDForPackage(this.mCallingPackage);
            String signatureDigest = info.getCurrentSignatureForPackage(this.mCallingPackage);
            this.mStartUrl = this.getBrokerStartUrl(this.mStartUrl, this.mCallingPackage, signatureDigest);
            if (!this.isCallerBrokerInstaller()) {
                Logger.v("AuthenticationActivity:onCreate", "Caller needs to be verified using special redirectUri");
                this.mRedirectUrl = PackageHelper.getBrokerRedirectUrl(this.mCallingPackage, signatureDigest);
            }
            Logger.v("AuthenticationActivity:onCreate", "", "Broker redirectUrl: " + this.mRedirectUrl + " The calling package is: " + this.mCallingPackage + " Signature hash for calling package is: " + signatureDigest + " Current context package: " + this.getPackageName() + " Start url: " + this.mStartUrl, null);
        } else {
            Logger.v("AuthenticationActivity:onCreate", "Non-broker request for package " + this.getCallingPackage(), " Start url: " + this.mStartUrl, null);
        }
        this.mRegisterReceiver = false;
        final String postUrl = this.mStartUrl;
        Logger.i("AuthenticationActivity:onCreate", "Device info:" + Build.VERSION.RELEASE + " " + Build.MANUFACTURER + Build.MODEL, "");
        this.mStorageHelper = new StorageHelper(this.getApplicationContext());
        this.setupWebView();
        if (this.mAuthRequest.getCorrelationId() == null) {
            Logger.v("AuthenticationActivity:onCreate", "Null correlation id in the request.");
        } else {
            Logger.v("AuthenticationActivity:onCreate", "Correlation id for request sent is:" + this.mAuthRequest.getCorrelationId().toString());
        }
        if (savedInstanceState == null) {
            this.mWebView.post(new Runnable(){

                @Override
                public void run() {
                    Logger.v("AuthenticationActivity:onCreate", "Launching webview for acquiring auth code.");
                    AuthenticationActivity.this.mWebView.loadUrl("about:blank");
                    AuthenticationActivity.this.mWebView.loadUrl(postUrl);
                }
            });
        } else {
            Logger.v("AuthenticationActivity:onCreate", "Reuse webview");
        }
    }

    private boolean isCallerBrokerInstaller() {
        String methodName = ":isCallerBrokerInstaller";
        PackageHelper info = new PackageHelper((Context)this);
        String packageName = this.getCallingPackage();
        if (!StringExtensions.isNullOrBlank((String)packageName)) {
            if (packageName.equals(AuthenticationSettings.INSTANCE.getBrokerPackageName())) {
                Logger.v("AuthenticationActivity:isCallerBrokerInstaller", "Same package as broker.");
                return true;
            }
            String signature = info.getCurrentSignatureForPackage(packageName);
            Logger.v("AuthenticationActivity:isCallerBrokerInstaller", "Checking broker signature. ", "Check signature for " + packageName + " signature:" + signature + " brokerSignature:" + AuthenticationSettings.INSTANCE.getBrokerSignature(), null);
            return signature.equals(AuthenticationSettings.INSTANCE.getBrokerSignature()) || signature.equals("ho040S3ffZkmxqtQrSwpTVOn9r0=");
        }
        return false;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mWebView.saveState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.mWebView.restoreState(savedInstanceState);
    }

    private void setupWebView() {
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.setWebViewClient((WebViewClient)new CustomWebViewClient());
        this.mWebView.setVisibility(4);
    }

    private AuthenticationRequest getAuthenticationRequestFromIntent(Intent callingIntent) {
        String methodName = ":getAuthenticationRequestFromIntent";
        AuthenticationRequest authRequest = null;
        if (this.isBrokerRequest(callingIntent)) {
            Logger.v("AuthenticationActivity:getAuthenticationRequestFromIntent", "It is a broker request. Get request info from bundle extras.");
            String authority = callingIntent.getStringExtra("account.authority");
            String resource = callingIntent.getStringExtra("account.resource");
            String redirect = callingIntent.getStringExtra("account.redirect");
            String loginhint = callingIntent.getStringExtra("account.login.hint");
            String accountName = callingIntent.getStringExtra("account.name");
            String clientidKey = callingIntent.getStringExtra("account.clientid.key");
            String correlationId = callingIntent.getStringExtra("account.correlationid");
            String prompt = callingIntent.getStringExtra("account.prompt");
            PromptBehavior promptBehavior = PromptBehavior.Auto;
            if (!StringExtensions.isNullOrBlank((String)prompt)) {
                promptBehavior = PromptBehavior.valueOf(prompt);
            }
            this.mWaitingRequestId = callingIntent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
            UUID correlationIdParsed = null;
            if (!StringExtensions.isNullOrBlank((String)correlationId)) {
                try {
                    correlationIdParsed = UUID.fromString(correlationId);
                }
                catch (IllegalArgumentException ex) {
                    correlationIdParsed = null;
                    Logger.e("AuthenticationActivity:getAuthenticationRequestFromIntent", "CorrelationId is malformed: " + correlationId, "", ADALError.CORRELATION_ID_FORMAT);
                }
            }
            authRequest = new AuthenticationRequest(authority, resource, clientidKey, redirect, loginhint, correlationIdParsed, false);
            authRequest.setBrokerAccountName(accountName);
            authRequest.setPrompt(promptBehavior);
            authRequest.setRequestId(this.mWaitingRequestId);
        } else {
            Serializable request = callingIntent.getSerializableExtra("com.microsoft.aad.adal:BrowserRequestMessage");
            if (request instanceof AuthenticationRequest) {
                authRequest = (AuthenticationRequest)request;
            }
        }
        return authRequest;
    }

    private void returnError(ADALError errorCode, String argument) {
        Logger.w(TAG, "Argument error:" + argument);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", errorCode.name());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", argument);
        if (this.mAuthRequest != null) {
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mWaitingRequestId);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
        }
        this.setResult(2002, resultIntent);
        this.finish();
    }

    private String getBrokerStartUrl(String loadUrl, String packageName, String signatureDigest) {
        if (!StringExtensions.isNullOrBlank((String)packageName) && !StringExtensions.isNullOrBlank((String)signatureDigest)) {
            try {
                return loadUrl + "&package_name=" + URLEncoder.encode(packageName, "UTF-8") + "&signature=" + URLEncoder.encode(signatureDigest, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.e(TAG, "Encoding", e);
            }
        }
        return loadUrl;
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        return callingIntent != null && !StringExtensions.isNullOrBlank((String)callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request"));
    }

    private void returnToCaller(int resultCode, Intent data) {
        String methodName = ":returnToCaller";
        Logger.v("AuthenticationActivity:returnToCaller", "Return To Caller:" + resultCode);
        this.displaySpinner(false);
        if (data == null) {
            data = new Intent();
        }
        if (this.mAuthRequest == null) {
            Logger.w("AuthenticationActivity:returnToCaller", "Request object is null", "", ADALError.ACTIVITY_REQUEST_INTENT_DATA_IS_NULL);
        } else {
            Logger.v("AuthenticationActivity:returnToCaller", "Set request id related to response. REQUEST_ID for caller returned to:" + this.mAuthRequest.getRequestId());
            data.putExtra("com.microsoft.aad.adal:RequestId", this.mAuthRequest.getRequestId());
        }
        this.setResult(resultCode, data);
        this.finish();
    }

    protected void onPause() {
        String methodName = ":onPause";
        Logger.v("AuthenticationActivity:onPause", "AuthenticationActivity onPause unregister receiver");
        super.onPause();
        if (this.mReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mReceiver);
        }
        this.mRegisterReceiver = true;
        if (this.mSpinner != null) {
            Logger.v("AuthenticationActivity:onPause", "Spinner at onPause will dismiss");
            this.mSpinner.dismiss();
        }
        this.hideKeyBoard();
    }

    protected void onResume() {
        String methodName = ":onResume";
        super.onResume();
        if (this.mRegisterReceiver) {
            Logger.v("AuthenticationActivity:onResume", "Webview onResume will register receiver. ", "StartUrl: " + this.mStartUrl, null);
            if (this.mReceiver != null) {
                Logger.v("AuthenticationActivity:onResume", "Webview onResume register broadcast receiver for request. RequestId: " + this.mReceiver.mWaitingRequestId);
                LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
            }
        }
        this.mRegisterReceiver = false;
        this.mSpinner = new ProgressDialog((Context)this);
        this.mSpinner.requestWindowFeature(1);
        this.mSpinner.setMessage(this.getText(this.getResources().getIdentifier("app_loading", "string", this.getPackageName())));
    }

    protected void onRestart() {
        Logger.v(TAG, "AuthenticationActivity onRestart");
        super.onRestart();
        this.mRegisterReceiver = true;
    }

    public void onBackPressed() {
        Logger.v(TAG, "Back button is pressed");
        if (this.mPkeyAuthRedirect || !this.mWebView.canGoBackOrForward(-2)) {
            this.cancelRequest();
        } else {
            this.mWebView.goBack();
        }
    }

    private void cancelRequest() {
        Logger.v(TAG, "Sending intent to cancel authentication activity");
        Intent resultIntent = new Intent();
        if (this.mUIEvent != null) {
            this.mUIEvent.setUserCancel();
        }
        this.returnToCaller(2001, resultIntent);
    }

    private void prepareForBrokerResume() {
        String methodName = ":prepareForBrokerResume";
        Logger.v("AuthenticationActivity:prepareForBrokerResume", "Return to caller with BROKER_REQUEST_RESUME, and waiting for result.");
        Intent resultIntent = new Intent();
        this.returnToCaller(2006, resultIntent);
    }

    private void hideKeyBoard() {
        if (this.mWebView != null) {
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            imm.hideSoftInputFromWindow(this.mWebView.getApplicationWindowToken(), 0);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mUIEvent != null) {
            Telemetry.getInstance().stopEvent(this.mAuthRequest.getTelemetryRequestId(), this.mUIEvent, "Microsoft.ADAL.ui_event");
        }
    }

    private void displaySpinner(boolean show) {
        String methodName = ":displaySpinner";
        if (!this.isFinishing() && !this.isChangingConfigurations() && this.mSpinner != null) {
            Logger.v("AuthenticationActivity:displaySpinner", "DisplaySpinner:" + show + " showing:" + this.mSpinner.isShowing());
            if (show && !this.mSpinner.isShowing()) {
                this.mSpinner.show();
            }
            if (!show && this.mSpinner.isShowing()) {
                this.mSpinner.dismiss();
            }
        }
    }

    private void displaySpinnerWithMessage(CharSequence charSequence) {
        if (!this.isFinishing() && this.mSpinner != null) {
            this.mSpinner.show();
            this.mSpinner.setMessage(charSequence);
        }
    }

    private void returnResult(int resultcode, Intent intent) {
        this.setAccountAuthenticatorResult(intent.getExtras());
        this.setResult(resultcode, intent);
        this.finish();
    }

    public void finish() {
        if (this.isBrokerRequest(this.getIntent()) && this.mAccountAuthenticatorResponse != null) {
            Logger.v(TAG, "It is a broker request");
            if (this.mAuthenticatorResultBundle == null) {
                this.mAccountAuthenticatorResponse.onError(4, "canceled");
            } else {
                this.mAccountAuthenticatorResponse.onResult(this.mAuthenticatorResultBundle);
            }
            this.mAccountAuthenticatorResponse = null;
        }
        super.finish();
    }

    private void setAccountAuthenticatorResult(Bundle result) {
        this.mAuthenticatorResultBundle = result;
    }

    class TokenTaskResult {
        private AuthenticationResult mTaskResult;
        private Exception mTaskException;
        private String mAccountName;

        TokenTaskResult() {
        }
    }

    class TokenTask
    extends AsyncTask<String, String, TokenTaskResult> {
        private String mPackageName;
        private int mAppCallingUID;
        private AuthenticationRequest mRequest;
        private AccountManager mAccountManager;
        private IWebRequestHandler mRequestHandler;

        public TokenTask() {
        }

        public TokenTask(IWebRequestHandler webHandler, AuthenticationRequest request, String packageName, int callingUID) {
            this.mRequestHandler = webHandler;
            this.mRequest = request;
            this.mPackageName = packageName;
            this.mAppCallingUID = callingUID;
            this.mAccountManager = AccountManager.get((Context)AuthenticationActivity.this);
        }

        protected TokenTaskResult doInBackground(String ... urlItems) {
            Oauth2 oauthRequest = new Oauth2(this.mRequest, this.mRequestHandler, AuthenticationActivity.this.mJWSBuilder);
            TokenTaskResult result = new TokenTaskResult();
            try {
                result.mTaskResult = oauthRequest.getToken(urlItems[0]);
                Logger.v(AuthenticationActivity.TAG, "Process result returned from TokenTask. ", this.mRequest.getLogInfo(), null);
            }
            catch (AuthenticationException | IOException exc) {
                Logger.e(AuthenticationActivity.TAG, "Error in processing code to get a token. ", this.mRequest.getLogInfo(), ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, exc);
                result.mTaskException = exc;
            }
            if (result.mTaskResult != null && result.mTaskResult.getAccessToken() != null) {
                Logger.v(AuthenticationActivity.TAG, "Token task successfully returns access token.", this.mRequest.getLogInfo(), null);
                try {
                    this.setAccount(result);
                }
                catch (IOException | GeneralSecurityException exc) {
                    Logger.e(AuthenticationActivity.TAG, "Error in setting the account", this.mRequest.getLogInfo(), ADALError.BROKER_ACCOUNT_SAVE_FAILED, exc);
                    result.mTaskException = exc;
                }
            }
            return result;
        }

        private String getBrokerAppCacheKey(String cacheKey) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            String digestKey = StringExtensions.createHash((String)("calling.uid.key" + this.mAppCallingUID + cacheKey));
            Logger.v(AuthenticationActivity.TAG, "Get broker app cache key.", "Key hash is:" + digestKey + " calling app UID:" + this.mAppCallingUID + " Key is: " + cacheKey, null);
            return digestKey;
        }

        private void appendAppUIDToAccount(Account account) throws GeneralSecurityException, IOException {
            String methodName = ":appendAppUIDToAccount";
            String appIdList = this.mAccountManager.getUserData(account, "account.uid.caches");
            if (appIdList == null) {
                appIdList = "";
            } else {
                try {
                    appIdList = AuthenticationActivity.this.mStorageHelper.decrypt(appIdList);
                }
                catch (IOException | GeneralSecurityException ex) {
                    Logger.e("AuthenticationActivity:appendAppUIDToAccount", "appUIDList failed to decrypt", "appIdList:" + appIdList, ADALError.ENCRYPTION_FAILED, ex);
                    appIdList = "";
                    Logger.i("AuthenticationActivity:appendAppUIDToAccount", "Reset the appUIDlist", "");
                }
            }
            Logger.i("AuthenticationActivity:appendAppUIDToAccount", "Add calling UID. ", "App UID: " + this.mAppCallingUID + "appIdList:" + appIdList, null);
            if (!appIdList.contains("calling.uid.key" + this.mAppCallingUID)) {
                Logger.i("AuthenticationActivity:appendAppUIDToAccount", "Account has new calling UID. ", "App UID: " + this.mAppCallingUID, null);
                String encryptedValue = AuthenticationActivity.this.mStorageHelper.encrypt(appIdList + "calling.uid.key" + this.mAppCallingUID);
                this.mAccountManager.setUserData(account, "account.uid.caches", encryptedValue);
            }
        }

        private void setAccount(TokenTaskResult result) throws GeneralSecurityException, IOException {
            String methodName = ":setAccount";
            String name = this.mRequest.getBrokerAccountName();
            Account[] accountList = this.mAccountManager.getAccountsByType("com.microsoft.workaccount");
            if (accountList.length != 1) {
                result.mTaskResult = null;
                result.mTaskException = new AuthenticationException(ADALError.BROKER_SINGLE_USER_EXPECTED);
                return;
            }
            Account newAccount = accountList[0];
            UserInfo userinfo = result.mTaskResult.getUserInfo();
            if (userinfo == null || StringExtensions.isNullOrBlank((String)userinfo.getUserId())) {
                Logger.i("AuthenticationActivity:setAccount", "Set userinfo from account", "");
                result.mTaskResult.setUserInfo(new UserInfo(name, name, "", "", name));
                this.mRequest.setLoginHint(name);
            } else {
                Logger.i("AuthenticationActivity:setAccount", "Saving userinfo to account", "");
                this.mAccountManager.setUserData(newAccount, "account.userinfo.userid", userinfo.getUserId());
                this.mAccountManager.setUserData(newAccount, "account.userinfo.given.name", userinfo.getGivenName());
                this.mAccountManager.setUserData(newAccount, "account.userinfo.family.name", userinfo.getFamilyName());
                this.mAccountManager.setUserData(newAccount, "account.userinfo.identity.provider", userinfo.getIdentityProvider());
                this.mAccountManager.setUserData(newAccount, "account.userinfo.userid.displayable", userinfo.getDisplayableId());
            }
            result.mAccountName = name;
            Logger.i("AuthenticationActivity:setAccount", "Setting account in account manager. ", "Package: " + this.mPackageName + " calling app UID:" + this.mAppCallingUID + " Account name: " + name);
            Gson gson = new Gson();
            Logger.i("AuthenticationActivity:setAccount", "app context:" + AuthenticationActivity.this.getApplicationContext().getPackageName() + " context:" + AuthenticationActivity.this.getPackageName() + " calling packagename:" + AuthenticationActivity.this.getCallingPackage(), "");
            if (AuthenticationSettings.INSTANCE.getSecretKeyData() == null) {
                Logger.i("AuthenticationActivity:setAccount", "Calling app doesn't provide the secret key.", "");
            }
            TokenCacheItem item = TokenCacheItem.createRegularTokenCacheItem(this.mRequest.getAuthority(), this.mRequest.getResource(), this.mRequest.getClientId(), result.mTaskResult);
            String json = gson.toJson((Object)item);
            String encrypted = AuthenticationActivity.this.mStorageHelper.encrypt(json);
            String key = CacheKey.createCacheKeyForRTEntry(AuthenticationActivity.this.mAuthRequest.getAuthority(), AuthenticationActivity.this.mAuthRequest.getResource(), AuthenticationActivity.this.mAuthRequest.getClientId(), null);
            this.saveCacheKey(key, newAccount, this.mAppCallingUID);
            this.mAccountManager.setUserData(newAccount, this.getBrokerAppCacheKey(key), encrypted);
            if (result.mTaskResult.getIsMultiResourceRefreshToken()) {
                TokenCacheItem itemMRRT = TokenCacheItem.createMRRTTokenCacheItem(this.mRequest.getAuthority(), this.mRequest.getClientId(), result.mTaskResult);
                json = gson.toJson((Object)itemMRRT);
                encrypted = AuthenticationActivity.this.mStorageHelper.encrypt(json);
                key = CacheKey.createCacheKeyForMRRT(AuthenticationActivity.this.mAuthRequest.getAuthority(), AuthenticationActivity.this.mAuthRequest.getClientId(), null);
                this.saveCacheKey(key, newAccount, this.mAppCallingUID);
                this.mAccountManager.setUserData(newAccount, this.getBrokerAppCacheKey(key), encrypted);
            }
            Logger.i("AuthenticationActivity:setAccount", "Set calling uid:" + this.mAppCallingUID, "");
            this.appendAppUIDToAccount(newAccount);
        }

        private void saveCacheKey(String key, Account cacheAccount, int callingUID) {
            String methodName = ":saveCacheKey";
            Logger.v("AuthenticationActivity:saveCacheKey", "Get CacheKeys for account");
            String keylist = this.mAccountManager.getUserData(cacheAccount, "userdata.caller.cachekeys" + callingUID);
            if (keylist == null) {
                keylist = "";
            }
            if (!keylist.contains("|" + key)) {
                Logger.v("AuthenticationActivity:saveCacheKey", "Account does not have the cache key. Saving it to account for the caller. ", "callerUID: " + callingUID + "The key to be saved is: " + key, null);
                keylist = keylist + "|" + key;
                this.mAccountManager.setUserData(cacheAccount, "userdata.caller.cachekeys" + callingUID, keylist);
                Logger.v("AuthenticationActivity:saveCacheKey", "Cache key saved into key list for the caller.", "keylist:" + keylist, null);
            }
        }

        protected void onPostExecute(TokenTaskResult result) {
            Logger.v(AuthenticationActivity.TAG, "Token task returns the result");
            AuthenticationActivity.this.displaySpinner(false);
            Intent intent = new Intent();
            if (result.mTaskResult == null) {
                Logger.v(AuthenticationActivity.TAG, "Token task has exception");
                AuthenticationActivity.this.returnError(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, result.mTaskException.getMessage());
                return;
            }
            if (result.mTaskResult.getStatus().equals((Object)AuthenticationResult.AuthenticationStatus.Succeeded)) {
                UserInfo userinfo;
                intent.putExtra("com.microsoft.aad.adal:RequestId", AuthenticationActivity.this.mWaitingRequestId);
                intent.putExtra("account.access.token", result.mTaskResult.getAccessToken());
                intent.putExtra("account.name", result.mAccountName);
                if (result.mTaskResult.getExpiresOn() != null) {
                    intent.putExtra("account.expiredate", result.mTaskResult.getExpiresOn().getTime());
                }
                if (result.mTaskResult.getTenantId() != null) {
                    intent.putExtra("account.userinfo.tenantid", result.mTaskResult.getTenantId());
                }
                if ((userinfo = result.mTaskResult.getUserInfo()) != null) {
                    intent.putExtra("account.userinfo.userid", userinfo.getUserId());
                    intent.putExtra("account.userinfo.given.name", userinfo.getGivenName());
                    intent.putExtra("account.userinfo.family.name", userinfo.getFamilyName());
                    intent.putExtra("account.userinfo.identity.provider", userinfo.getIdentityProvider());
                    intent.putExtra("account.userinfo.userid.displayable", userinfo.getDisplayableId());
                }
                if (null != result.mTaskResult.getCliTelemInfo()) {
                    TelemetryUtils.CliTelemInfo cliTelemInfo = result.mTaskResult.getCliTelemInfo();
                    intent.putExtra("cliteleminfo.spe_ring", cliTelemInfo.getSpeRing());
                    intent.putExtra("cliteleminfo.rt_age", cliTelemInfo.getRefreshTokenAge());
                    intent.putExtra("cliteleminfo.server_error", cliTelemInfo.getServerErrorCode());
                    intent.putExtra("cliteleminfo.server_suberror", cliTelemInfo.getServerSubErrorCode());
                }
                AuthenticationActivity.this.returnResult(2004, intent);
            } else {
                AuthenticationActivity.this.returnError(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, result.mTaskResult.getErrorDescription());
            }
        }
    }

    class CustomWebViewClient
    extends BasicWebViewClient {
        CustomWebViewClient() {
            super((Context)AuthenticationActivity.this, AuthenticationActivity.this.mRedirectUrl, AuthenticationActivity.this.mAuthRequest, AuthenticationActivity.this.mUIEvent);
        }

        @Override
        public void processRedirectUrl(WebView view, String url) {
            String methodName = ":processRedirectUrl";
            if (!AuthenticationActivity.this.isBrokerRequest(AuthenticationActivity.this.getIntent())) {
                Logger.i("AuthenticationActivity:processRedirectUrl", "It is not a broker request", "");
                Intent resultIntent = new Intent();
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", url);
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
                AuthenticationActivity.this.returnToCaller(2003, resultIntent);
                view.stopLoading();
            } else {
                Logger.i("AuthenticationActivity:processRedirectUrl", "It is a broker request", "");
                AuthenticationActivity.this.displaySpinnerWithMessage(AuthenticationActivity.this.getText(AuthenticationActivity.this.getResources().getIdentifier("broker_processing", "string", AuthenticationActivity.this.getPackageName())));
                view.stopLoading();
                new TokenTask(AuthenticationActivity.this.mWebRequestHandler, AuthenticationActivity.this.mAuthRequest, AuthenticationActivity.this.mCallingPackage, AuthenticationActivity.this.mCallingUID).execute(new String[]{url});
            }
        }

        @Override
        public boolean processInvalidUrl(WebView view, String url) {
            String methodName = ":processInvalidUrl";
            if (AuthenticationActivity.this.isBrokerRequest(AuthenticationActivity.this.getIntent()) && url.startsWith("msauth")) {
                Logger.e("AuthenticationActivity:processInvalidUrl", "The RedirectUri is not as expected.", String.format("Received %s and expected %s", url, AuthenticationActivity.this.mRedirectUrl), ADALError.DEVELOPER_REDIRECTURI_INVALID);
                AuthenticationActivity.this.returnError(ADALError.DEVELOPER_REDIRECTURI_INVALID, String.format("The RedirectUri is not as expected. Received %s and expected %s", url, AuthenticationActivity.this.mRedirectUrl));
                view.stopLoading();
                return true;
            }
            if (url.toLowerCase(Locale.US).equals("about:blank")) {
                Logger.v("AuthenticationActivity:processInvalidUrl", "It is an blank page request");
                return true;
            }
            if (!url.toLowerCase(Locale.US).startsWith("https://")) {
                Logger.e("AuthenticationActivity:processInvalidUrl", "The webview was redirected to an unsafe URL.", "", ADALError.WEBVIEW_REDIRECTURL_NOT_SSL_PROTECTED);
                AuthenticationActivity.this.returnError(ADALError.WEBVIEW_REDIRECTURL_NOT_SSL_PROTECTED, "The webview was redirected to an unsafe URL.");
                view.stopLoading();
                return true;
            }
            return false;
        }

        @Override
        public void showSpinner(boolean status) {
            AuthenticationActivity.this.displaySpinner(status);
        }

        @Override
        public void sendResponse(int returnCode, Intent responseIntent) {
            AuthenticationActivity.this.returnToCaller(returnCode, responseIntent);
        }

        @Override
        public void cancelWebViewRequest() {
            AuthenticationActivity.this.cancelRequest();
        }

        @Override
        public void prepareForBrokerResumeRequest() {
            AuthenticationActivity.this.prepareForBrokerResume();
        }

        @Override
        public void setPKeyAuthStatus(boolean status) {
            AuthenticationActivity.this.mPkeyAuthRedirect = status;
        }

        @Override
        public void postRunnable(Runnable item) {
            AuthenticationActivity.this.mWebView.post(item);
        }

        @TargetApi(value=21)
        public void onReceivedClientCertRequest(WebView view, final ClientCertRequest request) {
            String methodName = ":onReceivedClientCertRequest";
            Logger.v("AuthenticationActivity:onReceivedClientCertRequest", "Webview receives client TLS request.");
            Principal[] acceptableCertIssuers = request.getPrincipals();
            if (acceptableCertIssuers != null) {
                for (Principal issuer : acceptableCertIssuers) {
                    if (!issuer.getName().contains("CN=MS-Organization-Access")) continue;
                    Logger.v("AuthenticationActivity:onReceivedClientCertRequest", "Cancelling the TLS request, not respond to TLS challenge triggered by device authentication.");
                    request.cancel();
                    return;
                }
            }
            KeyChain.choosePrivateKeyAlias((Activity)AuthenticationActivity.this, (KeyChainAliasCallback)new KeyChainAliasCallback(){

                public void alias(String alias) {
                    if (alias == null) {
                        Logger.v("AuthenticationActivity:onReceivedClientCertRequest", "No certificate chosen by user, cancelling the TLS request.");
                        request.cancel();
                        return;
                    }
                    try {
                        X509Certificate[] certChain = KeyChain.getCertificateChain((Context)AuthenticationActivity.this.getApplicationContext(), (String)alias);
                        PrivateKey privateKey = KeyChain.getPrivateKey((Context)CustomWebViewClient.this.getCallingContext(), (String)alias);
                        Logger.v("AuthenticationActivity:onReceivedClientCertRequest", "Certificate is chosen by user, proceed with TLS request.");
                        request.proceed(privateKey, certChain);
                        return;
                    }
                    catch (KeyChainException e) {
                        Logger.e("AuthenticationActivity:onReceivedClientCertRequest", "KeyChain exception", e);
                    }
                    catch (InterruptedException e) {
                        Logger.e("AuthenticationActivity:onReceivedClientCertRequest", "InterruptedException exception", e);
                    }
                    request.cancel();
                }
            }, (String[])request.getKeyTypes(), (Principal[])request.getPrincipals(), (String)request.getHost(), (int)request.getPort(), null);
        }
    }

    private class ActivityBroadcastReceiver
    extends BroadcastReceiver {
        private int mWaitingRequestId = -1;

        private ActivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String methodName = ":onReceive";
            Logger.v("AuthenticationActivity:onReceive", "ActivityBroadcastReceiver onReceive");
            if (intent.getAction().equalsIgnoreCase("com.microsoft.aad.adal:BrowserCancel")) {
                Logger.v("AuthenticationActivity:onReceive", "ActivityBroadcastReceiver onReceive action is for cancelling Authentication Activity");
                int cancelRequestId = intent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
                if (cancelRequestId == this.mWaitingRequestId) {
                    Logger.v("AuthenticationActivity:onReceive", "Waiting requestId is same and cancelling this activity");
                    AuthenticationActivity.this.finish();
                }
            }
        }
    }
}

