/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.text.TextUtils;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationServerProtocolException;
import com.microsoft.aad.adal.ChallengeResponseBuilder;
import com.microsoft.aad.adal.HttpAuthDialog;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.UIEvent;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

abstract class BasicWebViewClient
extends WebViewClient {
    private static final String INSTALL_URL_KEY = "app_link";
    private static final String TAG = "BasicWebViewClient";
    public static final String BLANK_PAGE = "about:blank";
    private final String mRedirect;
    private final AuthenticationRequest mRequest;
    private final Context mCallingContext;
    private final UIEvent mUIEvent;

    BasicWebViewClient(Context appContext, String redirect, AuthenticationRequest request, UIEvent uiEvent) {
        this.mCallingContext = appContext;
        this.mRedirect = redirect;
        this.mRequest = request;
        this.mUIEvent = uiEvent;
    }

    public abstract void showSpinner(boolean var1);

    public abstract void sendResponse(int var1, Intent var2);

    public abstract void cancelWebViewRequest();

    public abstract void prepareForBrokerResumeRequest();

    public abstract void setPKeyAuthStatus(boolean var1);

    public abstract void postRunnable(Runnable var1);

    public void onReceivedHttpAuthRequest(WebView view, final HttpAuthHandler handler, String host, String realm) {
        String methodName = ":onReceivedHttpAuthRequest";
        Logger.i("BasicWebViewClient:onReceivedHttpAuthRequest", "Start. ", "Host:" + host);
        this.mUIEvent.setNTLM(true);
        HttpAuthDialog authDialog = new HttpAuthDialog(this.mCallingContext, host, realm);
        authDialog.setOkListener(new HttpAuthDialog.OkListener(){

            @Override
            public void onOk(String host, String realm, String username, String password) {
                Logger.i("BasicWebViewClient:onReceivedHttpAuthRequest", "Handler proceed. ", "Host: " + host);
                handler.proceed(username, password);
            }
        });
        authDialog.setCancelListener(new HttpAuthDialog.CancelListener(){

            @Override
            public void onCancel() {
                Logger.i("BasicWebViewClient:onReceivedHttpAuthRequest", "Handler cancelled", "");
                handler.cancel();
                BasicWebViewClient.this.cancelWebViewRequest();
            }
        });
        Logger.i("BasicWebViewClient:onReceivedHttpAuthRequest", "Show dialog. ", "");
        authDialog.show();
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        this.showSpinner(false);
        Logger.e(TAG, "Webview received an error. ErrorCode:" + errorCode, description, ADALError.ERROR_WEBVIEW);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Error Code:" + errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", description);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        super.onReceivedSslError(view, handler, error);
        this.showSpinner(false);
        handler.cancel();
        Logger.e(TAG, "Received ssl error. ", "", ADALError.ERROR_FAILED_SSL_HANDSHAKE);
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Code:-11");
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", error.toString());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
        this.sendResponse(2002, resultIntent);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        view.setVisibility(0);
        if (!url.startsWith(BLANK_PAGE)) {
            this.showSpinner(false);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.logPageStartLoadingUrl(url);
        super.onPageStarted(view, url, favicon);
        this.showSpinner(true);
    }

    private void logPageStartLoadingUrl(String url) {
        String methodName = ":logPageStartLoadingUrl";
        if (TextUtils.isEmpty((CharSequence)url)) {
            Logger.v("BasicWebViewClient:logPageStartLoadingUrl", "onPageStarted: Null url for page to load.");
            return;
        }
        Uri uri = Uri.parse((String)url);
        if (uri.isOpaque()) {
            Logger.v("BasicWebViewClient:logPageStartLoadingUrl", "onPageStarted: Non-hierarchical loading uri. ", "Url: " + url, null);
            return;
        }
        if (StringExtensions.isNullOrBlank((String)uri.getQueryParameter("code"))) {
            Logger.v("BasicWebViewClient:logPageStartLoadingUrl", "Webview starts loading. ", " Host: " + uri.getHost() + " Path: " + uri.getPath() + " Full loading url is: " + url, null);
        } else {
            Logger.v("BasicWebViewClient:logPageStartLoadingUrl", "Webview starts loading. ", " Host: " + uri.getHost() + " Path: " + uri.getPath() + " Auth code is returned for the loading url.", null);
        }
    }

    public boolean shouldOverrideUrlLoading(final WebView view, String url) {
        String methodName = ":shouldOverrideUrlLoading";
        Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "Navigation is detected");
        if (url.startsWith("urn:http-auth:PKeyAuth")) {
            Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "Webview detected request for pkeyauth challenge.");
            view.stopLoading();
            this.setPKeyAuthStatus(true);
            final String challengeUrl = url;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ChallengeResponseBuilder certHandler = new ChallengeResponseBuilder(new JWSBuilder());
                        final ChallengeResponseBuilder.ChallengeResponse challengeResponse = certHandler.getChallengeResponseFromUri(challengeUrl);
                        final HashMap<String, String> headers = new HashMap<String, String>();
                        headers.put("Authorization", challengeResponse.getAuthorizationHeaderValue());
                        BasicWebViewClient.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                String loadUrl = challengeResponse.getSubmitUrl();
                                Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "Respond to pkeyAuth challenge", "Challenge submit url:" + challengeResponse.getSubmitUrl(), null);
                                view.loadUrl(loadUrl, headers);
                            }
                        });
                    }
                    catch (AuthenticationServerProtocolException e) {
                        Logger.e("BasicWebViewClient:shouldOverrideUrlLoading", "Argument exception. ", e.getMessage(), ADALError.ARGUMENT_EXCEPTION, e);
                        Intent resultIntent = new Intent();
                        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
                        if (BasicWebViewClient.this.mRequest != null) {
                            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)BasicWebViewClient.this.mRequest);
                        }
                        BasicWebViewClient.this.sendResponse(2005, resultIntent);
                    }
                    catch (AuthenticationException e) {
                        Logger.e("BasicWebViewClient:shouldOverrideUrlLoading", "It is failed to create device certificate response", e.getMessage(), ADALError.DEVICE_CERTIFICATE_RESPONSE_FAILED, e);
                        Intent resultIntent = new Intent();
                        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
                        if (BasicWebViewClient.this.mRequest != null) {
                            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)BasicWebViewClient.this.mRequest);
                        }
                        BasicWebViewClient.this.sendResponse(2005, resultIntent);
                    }
                }
            }).start();
            return true;
        }
        if (url.toLowerCase(Locale.US).startsWith(this.mRedirect.toLowerCase(Locale.US))) {
            Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "Navigation starts with the redirect uri.");
            if (this.hasCancelError(url)) {
                Logger.i("BasicWebViewClient:shouldOverrideUrlLoading", "Sending intent to cancel authentication activity", "");
                view.stopLoading();
                this.cancelWebViewRequest();
                return true;
            }
            this.processRedirectUrl(view, url);
            return true;
        }
        if (url.startsWith("browser://")) {
            Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "It is an external website request");
            this.openLinkInBrowser(url);
            view.stopLoading();
            this.cancelWebViewRequest();
            return true;
        }
        if (url.startsWith("msauth://")) {
            Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "It is an install request");
            HashMap parameters = StringExtensions.getUrlParameters((String)url);
            this.prepareForBrokerResumeRequest();
            int threadSleepForCallingActivity = 1000;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Logger.v("BasicWebViewClient:shouldOverrideUrlLoading", "Error occurred when having thread sleeping for 1 second.");
            }
            this.openLinkInBrowser((String)parameters.get(INSTALL_URL_KEY));
            view.stopLoading();
            return true;
        }
        return this.processInvalidUrl(view, url);
    }

    public abstract void processRedirectUrl(WebView var1, String var2);

    public abstract boolean processInvalidUrl(WebView var1, String var2);

    final Context getCallingContext() {
        return this.mCallingContext;
    }

    protected void openLinkInBrowser(String url) {
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        this.mCallingContext.startActivity(intent);
    }

    private boolean hasCancelError(String redirectUrl) {
        HashMap parameters = StringExtensions.getUrlParameters((String)redirectUrl);
        String error = (String)parameters.get("error");
        String errorDescription = (String)parameters.get("error_description");
        if (!StringExtensions.isNullOrBlank((String)error)) {
            Logger.w(TAG, "Cancel error: " + error, errorDescription, null);
            return true;
        }
        return false;
    }
}

