/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.annotation.SuppressLint;
import android.util.Log;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.StringExtensions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

public class Logger {
    private static Logger sINSTANCE = new Logger();
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private LogLevel mLogLevel = LogLevel.Verbose;
    private ILogger mExternalLogger = null;
    private static final String CUSTOM_LOG_ERROR = "Custom log failed to log message:%s";
    private boolean mAndroidLogEnabled = false;
    private String mCorrelationId = null;
    private boolean mEnablePII = false;

    public static Logger getInstance() {
        return sINSTANCE;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.mLogLevel = logLevel;
    }

    public synchronized void setExternalLogger(ILogger externalLogger) {
        this.mExternalLogger = externalLogger;
    }

    public void setAndroidLogEnabled(boolean androidLogEnabled) {
        this.mAndroidLogEnabled = androidLogEnabled;
    }

    public void setEnablePII(boolean enablePII) {
        this.mEnablePII = enablePII;
    }

    private void sendLogcatLogs(String tag, LogLevel logLevel, String message) {
        switch (logLevel) {
            case Error: {
                Log.e((String)tag, (String)message);
                break;
            }
            case Warn: {
                Log.w((String)tag, (String)message);
                break;
            }
            case Info: {
                Log.i((String)tag, (String)message);
                break;
            }
            case Verbose: {
                Log.v((String)tag, (String)message);
                break;
            }
            case Debug: {
                Log.d((String)tag, (String)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown loglevel");
            }
        }
    }

    private static String addMoreInfo(String message) {
        if (!StringExtensions.isNullOrBlank(message)) {
            return Logger.getUTCDateTimeAsString() + "-" + Logger.getInstance().mCorrelationId + "-" + message + " ver:" + AuthenticationContext.getVersionName();
        }
        return Logger.getUTCDateTimeAsString() + "-" + Logger.getInstance().mCorrelationId + "- ver:" + AuthenticationContext.getVersionName();
    }

    private void log(String tag, String message, String additionalMessage, LogLevel logLevel, ADALError errorCode, Throwable throwable) {
        if (logLevel.compareTo(this.mLogLevel) > 0) {
            return;
        }
        StringBuilder logMessage = new StringBuilder();
        if (errorCode != null) {
            logMessage.append(Logger.getCodeName(errorCode)).append(':');
        }
        logMessage.append(Logger.addMoreInfo(message));
        if (!StringExtensions.isNullOrBlank(additionalMessage) && this.mEnablePII) {
            logMessage.append(' ').append(additionalMessage);
        }
        if (throwable != null) {
            logMessage.append('\n').append(Log.getStackTraceString((Throwable)throwable));
        }
        if (this.mAndroidLogEnabled) {
            this.sendLogcatLogs(tag, logLevel, logMessage.toString());
        }
        if (this.mExternalLogger != null) {
            try {
                if (!StringExtensions.isNullOrBlank(additionalMessage) && this.mEnablePII) {
                    this.mExternalLogger.Log(tag, Logger.addMoreInfo(message), additionalMessage + (throwable == null ? "" : Log.getStackTraceString((Throwable)throwable)), logLevel, errorCode);
                } else {
                    this.mExternalLogger.Log(tag, Logger.addMoreInfo(message), throwable == null ? null : Log.getStackTraceString((Throwable)throwable), logLevel, errorCode);
                }
            }
            catch (Exception e) {
                Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, message));
            }
        }
    }

    public static void d(String tag, String message) {
        if (StringExtensions.isNullOrBlank(message)) {
            return;
        }
        Logger.getInstance().log(tag, message, null, LogLevel.Debug, null, null);
    }

    public static void i(String tag, String message, String additionalMessage) {
        Logger.getInstance().log(tag, message, additionalMessage, LogLevel.Info, null, null);
    }

    public static void i(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().log(tag, message, additionalMessage, LogLevel.Info, errorCode, null);
    }

    public static void v(String tag, String message) {
        Logger.getInstance().log(tag, message, null, LogLevel.Verbose, null, null);
    }

    public static void v(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().log(tag, message, additionalMessage, LogLevel.Verbose, errorCode, null);
    }

    public static void w(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().log(tag, message, additionalMessage, LogLevel.Warn, errorCode, null);
    }

    public static void w(String tag, String message) {
        Logger.getInstance().log(tag, message, null, LogLevel.Warn, null, null);
    }

    public static void e(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().log(tag, message, additionalMessage, LogLevel.Error, errorCode, null);
    }

    public static void e(String tag, String message, String additionalMessage, ADALError errorCode, Throwable throwable) {
        Logger.getInstance().log(tag, message, additionalMessage, LogLevel.Error, errorCode, throwable);
    }

    public static void e(String tag, String message, Throwable throwable) {
        Logger.getInstance().log(tag, message, null, LogLevel.Error, null, throwable);
    }

    public static void setCorrelationId(UUID correlation) {
        Logger.getInstance().mCorrelationId = "";
        if (correlation != null) {
            Logger.getInstance().mCorrelationId = correlation.toString();
        }
    }

    private static String getCodeName(ADALError code) {
        if (code != null) {
            return code.name();
        }
        return "";
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static String getUTCDateTimeAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String utcTime = dateFormat.format(new Date());
        return utcTime;
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public static interface ILogger {
        public void Log(String var1, String var2, String var3, LogLevel var4, ADALError var5);
    }

    public static enum LogLevel {
        Error(0),
        Warn(1),
        Info(2),
        Verbose(3),
        Debug(4);

        private int mValue;

        private LogLevel(int val) {
            this.mValue = val;
        }
    }
}

