/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.util.Pair;
import com.microsoft.aad.adal.DefaultEvent;
import com.microsoft.aad.adal.StringExtensions;
import java.util.List;
import java.util.Map;

final class BrokerEvent
extends DefaultEvent {
    BrokerEvent(String eventName) {
        this.setProperty("Microsoft.ADAL.event_name", eventName);
    }

    void setBrokerAppName(String brokerAppName) {
        this.setProperty("Microsoft.ADAL.broker_app", brokerAppName);
    }

    void setBrokerAppVersion(String brokerAppVersion) {
        this.setProperty("Microsoft.ADAL.broker_version", brokerAppVersion);
    }

    void setBrokerAccountServerStartsBinding() {
        this.setProperty("Microsoft.ADAL.broker_account_service_starts_binding", Boolean.toString(true));
    }

    void setBrokerAccountServiceBindingSucceed(boolean succeeded) {
        this.setProperty("Microsoft.ADAL.broker_account_service_binding_succeed", Boolean.toString(succeeded));
    }

    void setBrokerAccountServiceConnected() {
        this.setProperty("Microsoft.ADAL.broker_account_service_connected", Boolean.toString(true));
    }

    void setServerErrorCode(String errorCode) {
        if (!StringExtensions.isNullOrBlank(errorCode) && !errorCode.equals("0")) {
            this.setProperty("Microsoft.ADAL.server_error_code", errorCode.trim());
        }
    }

    void setServerSubErrorCode(String subErrorCode) {
        if (!StringExtensions.isNullOrBlank(subErrorCode) && !subErrorCode.equals("0")) {
            this.setProperty("Microsoft.ADAL.server_sub_error_code", subErrorCode.trim());
        }
    }

    void setRefreshTokenAge(String tokenAge) {
        if (!StringExtensions.isNullOrBlank(tokenAge)) {
            this.setProperty("Microsoft.ADAL.rt_age", tokenAge.trim());
        }
    }

    void setSpeRing(String speRing) {
        if (!StringExtensions.isNullOrBlank(speRing)) {
            this.setProperty("Microsoft.ADAL.spe_info", speRing.trim());
        }
    }

    @Override
    public void processEvent(Map<String, String> dispatchMap) {
        List<Pair<String, String>> eventList = this.getEventList();
        dispatchMap.put("Microsoft.ADAL.broker_app_used", Boolean.toString(true));
        for (Pair<String, String> eventPair : eventList) {
            String name = (String)eventPair.first;
            if (name.equals("Microsoft.ADAL.event_name")) continue;
            dispatchMap.put((String)eventPair.first, (String)eventPair.second);
        }
    }
}

