/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.support.annotation.Nullable;
import com.microsoft.aad.adal.InstanceDiscoveryMetadata;
import com.microsoft.aad.adal.PromptBehavior;
import java.io.Serializable;
import java.util.UUID;

class AuthenticationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DELIM_NOT_FOUND = -1;
    private static final String UPN_DOMAIN_SUFFIX_DELIM = "@";
    private int mRequestId = 0;
    private String mAuthority = null;
    private String mRedirectUri = null;
    private String mResource = null;
    private String mClientId = null;
    private String mLoginHint = null;
    private String mUserId = null;
    private String mBrokerAccountName = null;
    private UUID mCorrelationId;
    private String mExtraQueryParamsAuthentication;
    private PromptBehavior mPrompt;
    private boolean mSilent = false;
    private String mVersion = null;
    private UserIdentifierType mIdentifierType;
    private boolean mIsExtendedLifetimeEnabled = false;
    private String mTelemetryRequestId;
    private String mClaimsChallenge;
    private transient InstanceDiscoveryMetadata mInstanceDiscoveryMetadata;

    public AuthenticationRequest() {
        this.mIdentifierType = UserIdentifierType.NoUser;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint, PromptBehavior prompt, String extraQueryParams, UUID correlationId, boolean isExtendedLifetimeEnabled, String claimsChallenge) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mBrokerAccountName = this.mLoginHint = loginhint;
        this.mPrompt = prompt;
        this.mExtraQueryParamsAuthentication = extraQueryParams;
        this.mCorrelationId = correlationId;
        this.mIdentifierType = UserIdentifierType.NoUser;
        this.mIsExtendedLifetimeEnabled = isExtendedLifetimeEnabled;
        this.mClaimsChallenge = claimsChallenge;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint, UUID requestCorrelationId, boolean isExtendedLifetimeEnabled) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mBrokerAccountName = this.mLoginHint = loginhint;
        this.mCorrelationId = requestCorrelationId;
        this.mIsExtendedLifetimeEnabled = isExtendedLifetimeEnabled;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint, boolean isExtendedLifetimeEnabled) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mBrokerAccountName = this.mLoginHint = loginhint;
        this.mIsExtendedLifetimeEnabled = isExtendedLifetimeEnabled;
    }

    public AuthenticationRequest(String authority, String resource, String clientid, boolean isExtendedLifetimeEnabled) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = clientid;
        this.mIsExtendedLifetimeEnabled = isExtendedLifetimeEnabled;
    }

    public AuthenticationRequest(String authority, String resource, String clientid, String userid, UUID correlationId, boolean isExtendedLifetimeEnabled) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = clientid;
        this.mUserId = userid;
        this.mCorrelationId = correlationId;
        this.mIsExtendedLifetimeEnabled = isExtendedLifetimeEnabled;
    }

    public AuthenticationRequest(String authority, String resource, String clientId, UUID correlationId, boolean isExtendedLifetimeEnabled) {
        this.mAuthority = authority;
        this.mClientId = clientId;
        this.mResource = resource;
        this.mCorrelationId = correlationId;
        this.mIsExtendedLifetimeEnabled = isExtendedLifetimeEnabled;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public String getResource() {
        return this.mResource;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public UUID getCorrelationId() {
        return this.mCorrelationId;
    }

    public String getExtraQueryParamsAuthentication() {
        return this.mExtraQueryParamsAuthentication;
    }

    public String getLogInfo() {
        return String.format("Request authority:%s clientid:%s", this.mAuthority, this.mClientId);
    }

    public PromptBehavior getPrompt() {
        return this.mPrompt;
    }

    public void setPrompt(PromptBehavior prompt) {
        this.mPrompt = prompt;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public void setRequestId(int requestId) {
        this.mRequestId = requestId;
    }

    public String getBrokerAccountName() {
        return this.mBrokerAccountName;
    }

    public void setBrokerAccountName(String brokerAccountName) {
        this.mBrokerAccountName = brokerAccountName;
    }

    void setLoginHint(String name) {
        this.mLoginHint = name;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public boolean isSilent() {
        return this.mSilent;
    }

    public void setSilent(boolean silent) {
        this.mSilent = silent;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public UserIdentifierType getUserIdentifierType() {
        return this.mIdentifierType;
    }

    public void setUserIdentifierType(UserIdentifierType user) {
        this.mIdentifierType = user;
    }

    public boolean getIsExtendedLifetimeEnabled() {
        return this.mIsExtendedLifetimeEnabled;
    }

    public void setClaimsChallenge(String claimsChallenge) {
        this.mClaimsChallenge = claimsChallenge;
    }

    public String getClaimsChallenge() {
        return this.mClaimsChallenge;
    }

    String getUserFromRequest() {
        if (UserIdentifierType.LoginHint == this.mIdentifierType) {
            return this.mLoginHint;
        }
        if (UserIdentifierType.UniqueId == this.mIdentifierType) {
            return this.mUserId;
        }
        return null;
    }

    @Nullable
    String getUpnSuffix() {
        String hint = this.getLoginHint();
        String suffix = null;
        if (hint != null) {
            int dIndex = hint.lastIndexOf(UPN_DOMAIN_SUFFIX_DELIM);
            suffix = -1 == dIndex ? null : hint.substring(dIndex + 1);
        }
        return suffix;
    }

    void setTelemetryRequestId(String telemetryRequestId) {
        this.mTelemetryRequestId = telemetryRequestId;
    }

    String getTelemetryRequestId() {
        return this.mTelemetryRequestId;
    }

    void setInstanceDiscoveryMetadata(InstanceDiscoveryMetadata metadata) {
        this.mInstanceDiscoveryMetadata = metadata;
    }

    InstanceDiscoveryMetadata getInstanceDiscoveryMetadata() {
        return this.mInstanceDiscoveryMetadata;
    }

    static enum UserIdentifierType {
        UniqueId,
        LoginHint,
        NoUser;

    }
}

