/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.IConnectionService;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PowerManagerWrapper;
import com.microsoft.aad.adal.UsageStatsManagerWrapper;

class DefaultConnectionService
implements IConnectionService {
    private final Context mConnectionContext;
    private static final String TAG = "DefaultConnectionService";

    DefaultConnectionService(Context ctx) {
        this.mConnectionContext = ctx;
    }

    @Override
    public boolean isConnectionAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting() && !this.isNetworkDisabledFromOptimizations();
    }

    @TargetApi(value=23)
    public boolean isNetworkDisabledFromOptimizations() {
        if (Build.VERSION.SDK_INT >= 23) {
            UsageStatsManagerWrapper usageStatsManagerWrapper = UsageStatsManagerWrapper.getInstance();
            if (usageStatsManagerWrapper.isAppInactive(this.mConnectionContext)) {
                Logger.w(TAG, "Client app is inactive. Network is disabled.", "", ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION);
                return true;
            }
            PowerManagerWrapper powerManagerWrapper = PowerManagerWrapper.getInstance();
            if (powerManagerWrapper.isDeviceIdleMode(this.mConnectionContext) && !powerManagerWrapper.isIgnoringBatteryOptimizations(this.mConnectionContext)) {
                Logger.w(TAG, "Device is dozing. Network is disabled.", "", ADALError.NO_NETWORK_CONNECTION_POWER_OPTIMIZATION);
                return true;
            }
        }
        return false;
    }
}

