/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.DeserializationAuthenticationException;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.TokenCacheItemSerializationAdapater;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

final class SSOStateSerializer {
    @SerializedName(value="version")
    private final int version = 1;
    @SerializedName(value="tokenCacheItems")
    private final List<TokenCacheItem> mTokenCacheItems = new ArrayList<TokenCacheItem>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(TokenCacheItem.class, (Object)new TokenCacheItemSerializationAdapater()).create();

    private int getVersion() {
        return 1;
    }

    private SSOStateSerializer(TokenCacheItem item) {
        if (item == null) {
            throw new IllegalArgumentException("tokenItem is null");
        }
        this.mTokenCacheItems.add(item);
    }

    private SSOStateSerializer() {
    }

    private TokenCacheItem getTokenItem() throws AuthenticationException {
        if (this.mTokenCacheItems == null || this.mTokenCacheItems.isEmpty()) {
            throw new AuthenticationException(ADALError.TOKEN_CACHE_ITEM_NOT_FOUND, "There is no token cache item in the SSOStateContainer.");
        }
        return this.mTokenCacheItems.get(0);
    }

    private String internalSerialize() {
        return GSON.toJson((Object)this);
    }

    private TokenCacheItem internalDeserialize(String serializedBlob) throws AuthenticationException {
        try {
            JSONObject jsonObject = new JSONObject(serializedBlob);
            if (jsonObject.getInt("version") == this.getVersion()) {
                return ((SSOStateSerializer)GSON.fromJson(serializedBlob, SSOStateSerializer.class)).getTokenItem();
            }
            throw new DeserializationAuthenticationException("Fail to deserialize because the blob version is incompatible. The version of the serializedBlob is " + jsonObject.getInt("version") + ". And the target class version is " + this.getVersion());
        }
        catch (JsonParseException | JSONException exception) {
            throw new DeserializationAuthenticationException(exception.getMessage());
        }
    }

    static String serialize(TokenCacheItem item) {
        SSOStateSerializer ssoStateSerializer = new SSOStateSerializer(item);
        return ssoStateSerializer.internalSerialize();
    }

    static TokenCacheItem deserialize(String serializedBlob) throws AuthenticationException {
        SSOStateSerializer ssoStateSerializer = new SSOStateSerializer();
        return ssoStateSerializer.internalDeserialize(serializedBlob);
    }
}

