/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.NetworkOnMainThreadException;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.util.SparseArray;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AcquireTokenRequest;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationRequestState;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.DefaultTokenCacheStore;
import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PRNGFixes;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.SSOStateSerializer;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UsageAuthenticationException;
import com.microsoft.aad.adal.UserInfo;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

public class AuthenticationContext {
    private static final int EXCLUDE_INDEX = 8;
    private static final String TAG = "AuthenticationContext";
    private Context mContext;
    private String mAuthority;
    private boolean mValidateAuthority;
    private boolean mIsAuthorityValidated;
    private ITokenCacheStore mTokenCacheStore;
    private BrokerProxy mBrokerProxy = null;
    private boolean mExtendedLifetimeEnabled = false;
    private final SparseArray<AuthenticationRequestState> mDelegateMap = new SparseArray();
    private UUID mRequestCorrelationId = null;

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority) {
        PRNGFixes.apply();
        this.initialize(appContext, authority, new DefaultTokenCacheStore(appContext), validateAuthority, true);
    }

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, validateAuthority, false);
    }

    public AuthenticationContext(Context appContext, String authority, ITokenCacheStore tokenCacheStore) {
        this.initialize(appContext, authority, tokenCacheStore, true, false);
    }

    private void initialize(Context appContext, String authority, ITokenCacheStore tokenCacheStore, boolean validateAuthority, boolean defaultCache) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext");
        }
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        this.mBrokerProxy = new BrokerProxy(appContext);
        if (!defaultCache && !this.mBrokerProxy.canUseLocalCache()) {
            throw new UnsupportedOperationException("Local cache is not supported for broker usage");
        }
        this.mContext = appContext;
        this.checkInternetPermission();
        this.mAuthority = AuthenticationContext.extractAuthority(authority);
        this.mValidateAuthority = validateAuthority;
        this.mTokenCacheStore = tokenCacheStore;
    }

    public ITokenCacheStore getCache() {
        return this.mTokenCacheStore;
    }

    public boolean getExtendedLifetimeEnabled() {
        return this.mExtendedLifetimeEnabled;
    }

    public void setExtendedLifetimeEnabled(boolean extendedLifetimeEnabled) {
        this.mExtendedLifetimeEnabled = extendedLifetimeEnabled;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public boolean getValidateAuthority() {
        return this.mValidateAuthority;
    }

    public String getBrokerUser() {
        if (this.mBrokerProxy != null) {
            return this.mBrokerProxy.getCurrentUser();
        }
        return null;
    }

    public UserInfo[] getBrokerUsers() throws OperationCanceledException, AuthenticatorException, IOException {
        return this.mBrokerProxy != null ? this.mBrokerProxy.getBrokerUsers() : null;
    }

    public String getRedirectUriForBroker() {
        PackageHelper packageHelper = new PackageHelper(this.mContext);
        String packageName = this.mContext.getPackageName();
        String signatureDigest = packageHelper.getCurrentSignatureForPackage(packageName);
        String redirectUri = PackageHelper.getBrokerRedirectUrl(packageName, signatureDigest);
        Logger.v(TAG, "Broker redirectUri:" + redirectUri + " packagename:" + packageName + " signatureDigest:" + signatureDigest);
        return redirectUri;
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String loginHint, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.checkPreRequirements(resource, clientId, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, PromptBehavior.Auto, null, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
            request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
            this.createAcquireTokenRequest().acquireToken(this.wrapActivity(activity), false, request, callback);
        }
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String loginHint, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.checkPreRequirements(resource, clientId, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, PromptBehavior.Auto, extraQueryParameters, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
            request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
            this.createAcquireTokenRequest().acquireToken(this.wrapActivity(activity), false, request, callback);
        }
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, PromptBehavior prompt, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.checkPreRequirements(resource, clientId, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, null, prompt, null, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
            this.createAcquireTokenRequest().acquireToken(this.wrapActivity(activity), false, request, callback);
        }
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.checkPreRequirements(resource, clientId, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, null, prompt, extraQueryParameters, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
            this.createAcquireTokenRequest().acquireToken(this.wrapActivity(activity), false, request, callback);
        }
    }

    public void acquireToken(Activity activity, String resource, String clientId, String redirectUri, String loginHint, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.checkPreRequirements(resource, clientId, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
            request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
            this.createAcquireTokenRequest().acquireToken(this.wrapActivity(activity), false, request, callback);
        }
    }

    public void acquireToken(IWindowComponent fragment, String resource, String clientId, String redirectUri, String loginHint, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.checkPreRequirements(resource, clientId, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
            request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
            this.createAcquireTokenRequest().acquireToken(fragment, false, request, callback);
        }
    }

    public void acquireToken(String resource, String clientId, String redirectUri, String loginHint, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.checkPreRequirements(resource, clientId, callback)) {
            redirectUri = this.getRedirectUri(redirectUri);
            AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, redirectUri, loginHint, prompt, extraQueryParameters, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
            request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.LoginHint);
            this.createAcquireTokenRequest().acquireToken(null, true, request, callback);
        }
    }

    public AuthenticationResult acquireTokenSilentSync(String resource, String clientId, String userId) throws AuthenticationException, InterruptedException {
        final AtomicReference authenticationResult = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        if (StringExtensions.isNullOrBlank(resource)) {
            throw new IllegalArgumentException("The required resource is null or blank.");
        }
        if (StringExtensions.isNullOrBlank(clientId)) {
            throw new IllegalArgumentException("The required clientId is null or blank.");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        Looper currentLooper = Looper.myLooper();
        if (currentLooper != null && currentLooper == this.mContext.getMainLooper()) {
            Log.e((String)TAG, (String)"Sync network calls must not be invoked in main thread. This method will throw android.os.NetworkOnMainThreadException in next major release", (Throwable)new NetworkOnMainThreadException());
        }
        this.createAcquireTokenRequest().acquireToken(null, false, request, new AuthenticationCallback<AuthenticationResult>(){

            @Override
            public void onSuccess(AuthenticationResult result) {
                authenticationResult.set(result);
                latch.countDown();
            }

            @Override
            public void onError(Exception exc) {
                exception.set(exc);
                latch.countDown();
            }
        });
        latch.await();
        Exception e = (Exception)exception.get();
        if (e != null) {
            if (e instanceof AuthenticationException) {
                throw (AuthenticationException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() != null) {
                if (e.getCause() instanceof AuthenticationException) {
                    throw (AuthenticationException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getCause().getMessage(), e.getCause());
            }
            throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getMessage(), e);
        }
        return (AuthenticationResult)authenticationResult.get();
    }

    @Deprecated
    public Future<AuthenticationResult> acquireTokenSilent(String resource, String clientId, String userId, final AuthenticationCallback<AuthenticationResult> callback) {
        if (StringExtensions.isNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.isNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        final SettableFuture<AuthenticationResult> futureTask = new SettableFuture<AuthenticationResult>();
        this.createAcquireTokenRequest().acquireToken(null, false, request, new AuthenticationCallback<AuthenticationResult>(){

            @Override
            public void onSuccess(AuthenticationResult result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
                futureTask.set(result);
            }

            @Override
            public void onError(Exception exc) {
                if (callback != null) {
                    callback.onError(exc);
                }
                futureTask.setException(exc);
            }
        });
        return futureTask;
    }

    public void acquireTokenSilentAsync(String resource, String clientId, String userId, AuthenticationCallback<AuthenticationResult> callback) {
        if (StringExtensions.isNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.isNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, userId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
        this.createAcquireTokenRequest().acquireToken(null, false, request, callback);
    }

    @Deprecated
    public void acquireTokenByRefreshToken(String refreshToken, String clientId, AuthenticationCallback<AuthenticationResult> callback) {
        if (StringExtensions.isNullOrBlank(refreshToken)) {
            throw new IllegalArgumentException("Refresh token is not provided");
        }
        if (StringExtensions.isNullOrBlank(clientId)) {
            throw new IllegalArgumentException("ClientId is not provided");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback is not provided");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, null, clientId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setSilent(true);
        this.createAcquireTokenRequest().refreshTokenWithoutCache(refreshToken, request, callback);
    }

    @Deprecated
    public void acquireTokenByRefreshToken(String refreshToken, String clientId, String resource, AuthenticationCallback<AuthenticationResult> callback) {
        if (StringExtensions.isNullOrBlank(refreshToken)) {
            throw new IllegalArgumentException("Refresh token is not provided");
        }
        if (StringExtensions.isNullOrBlank(clientId)) {
            throw new IllegalArgumentException("ClientId is not provided");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback is not provided");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, resource, clientId, this.getRequestCorrelationId(), this.getExtendedLifetimeEnabled());
        request.setSilent(true);
        this.createAcquireTokenRequest().refreshTokenWithoutCache(refreshToken, request, callback);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            AcquireTokenRequest acquireTokenRequest = new AcquireTokenRequest(this.mContext, this);
            acquireTokenRequest.onActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean cancelAuthenticationActivity(int requestId) throws AuthenticationException {
        AuthenticationRequestState waitingRequest = this.getWaitingRequest(requestId);
        if (waitingRequest == null || waitingRequest.getDelegate() == null) {
            Logger.v(TAG, "Current callback is empty. There is not any active authentication.");
            return true;
        }
        String currentCorrelationInfo = waitingRequest.getRequest() != null ? String.format(" CorrelationId: %s", waitingRequest.getRequest().getCorrelationId().toString()) : "No correlation id associated with waiting request";
        Logger.v(TAG, "Current callback is not empty. There is an active authentication Activity." + currentCorrelationInfo);
        Intent intent = new Intent("com.microsoft.aad.adal:BrowserCancel");
        Bundle extras = new Bundle();
        intent.putExtras(extras);
        intent.putExtra("com.microsoft.aad.adal:RequestId", requestId);
        boolean cancelResult = LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        if (cancelResult) {
            Logger.v(TAG, "Cancel broadcast message was successful." + currentCorrelationInfo);
            waitingRequest.setCancelled(true);
            waitingRequest.getDelegate().onError(new AuthenticationCancelError("Cancel broadcast message was successful."));
        } else {
            Logger.w(TAG, "Cancel broadcast message was not successful." + currentCorrelationInfo, "", ADALError.BROADCAST_CANCEL_NOT_SUCCESSFUL);
        }
        return cancelResult;
    }

    public UUID getRequestCorrelationId() {
        if (this.mRequestCorrelationId == null) {
            return UUID.randomUUID();
        }
        return this.mRequestCorrelationId;
    }

    public void setRequestCorrelationId(UUID requestCorrelationId) {
        this.mRequestCorrelationId = requestCorrelationId;
        Logger.setCorrelationId(requestCorrelationId);
    }

    private IWindowComponent wrapActivity(final Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity");
        }
        return new IWindowComponent(){
            private Activity mRefActivity;
            {
                this.mRefActivity = activity;
            }

            @Override
            public void startActivityForResult(Intent intent, int requestCode) {
                if (this.mRefActivity != null) {
                    this.mRefActivity.startActivityForResult(intent, requestCode);
                }
            }
        };
    }

    private boolean checkPreRequirements(String resource, String clientId, AuthenticationCallback<AuthenticationResult> callback) {
        if (AuthenticationSettings.INSTANCE.getUseBroker()) {
            try {
                this.mBrokerProxy.verifyBrokerPermissionsAPI22AndLess();
            }
            catch (UsageAuthenticationException exception) {
                callback.onError(exception);
                return false;
            }
        }
        if (this.mContext == null) {
            throw new IllegalArgumentException("context", new AuthenticationException(ADALError.DEVELOPER_CONTEXT_IS_NOT_PROVIDED));
        }
        if (StringExtensions.isNullOrBlank(resource)) {
            throw new IllegalArgumentException("resource");
        }
        if (StringExtensions.isNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        return true;
    }

    private String getRedirectUri(String inputRedirectUri) {
        String redirectUri = StringExtensions.isNullOrBlank(inputRedirectUri) ? this.mContext.getApplicationContext().getPackageName() : inputRedirectUri;
        return redirectUri;
    }

    private AcquireTokenRequest createAcquireTokenRequest() {
        return new AcquireTokenRequest(this.mContext, this);
    }

    private static String extractAuthority(String authority) {
        int fourthSlash;
        int thirdSlash;
        if (!(StringExtensions.isNullOrBlank(authority) || (thirdSlash = authority.indexOf(47, 8)) < 0 || thirdSlash == authority.length() - 1 || (fourthSlash = authority.indexOf("/", thirdSlash + 1)) >= 0 && fourthSlash <= thirdSlash + 1)) {
            if (fourthSlash >= 0) {
                return authority.substring(0, fourthSlash);
            }
            return authority;
        }
        throw new IllegalArgumentException("authority");
    }

    private void checkInternetPermission() {
        PackageManager pm = this.mContext.getPackageManager();
        if (0 != pm.checkPermission("android.permission.INTERNET", this.mContext.getPackageName())) {
            throw new IllegalStateException(new AuthenticationException(ADALError.DEVELOPER_INTERNET_PERMISSION_MISSING));
        }
    }

    String serialize(String uniqueUserId) throws AuthenticationException {
        if (StringExtensions.isNullOrBlank(uniqueUserId)) {
            throw new IllegalArgumentException("uniqueUserId");
        }
        if (this.mBrokerProxy.canSwitchToBroker() != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER) {
            throw new UsageAuthenticationException(ADALError.FAIL_TO_EXPORT, "Failed to export the family refresh token cache item because broker is enabled.");
        }
        String cacheKey = CacheKey.createCacheKeyForFRT(this.getAuthority(), "1", uniqueUserId);
        TokenCacheItem tokenItem = this.getCache().getItem(cacheKey);
        if (tokenItem == null) {
            Logger.i(TAG, "Cannot find the family token cache item for this userID", "");
            throw new UsageAuthenticationException(ADALError.FAIL_TO_EXPORT, "Failed to export the FID because no family token cache item is found.");
        }
        if (!StringExtensions.isNullOrBlank(tokenItem.getFamilyClientId())) {
            return SSOStateSerializer.serialize(tokenItem);
        }
        throw new IllegalArgumentException("tokenItem does not contain family refresh token");
    }

    void deserialize(String serializedBlob) throws AuthenticationException {
        if (StringExtensions.isNullOrBlank(serializedBlob)) {
            throw new IllegalArgumentException("serializedBlob");
        }
        if (this.mBrokerProxy.canSwitchToBroker() != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER) {
            throw new UsageAuthenticationException(ADALError.FAIL_TO_IMPORT, "Failed to import the serialized blob because broker is enabled.");
        }
        TokenCacheItem tokenCacheItem = SSOStateSerializer.deserialize(serializedBlob);
        String cacheKey = CacheKey.createCacheKey(tokenCacheItem);
        this.getCache().setItem(cacheKey, tokenCacheItem);
    }

    void setIsAuthorityValidated(boolean isAuthorityValidated) {
        this.mIsAuthorityValidated = isAuthorityValidated;
    }

    boolean getIsAuthorityValidated() {
        return this.mIsAuthorityValidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticationRequestState getWaitingRequest(int requestId) throws AuthenticationException {
        AuthenticationRequestState request;
        Logger.v(TAG, "Get waiting request: " + requestId);
        SparseArray<AuthenticationRequestState> sparseArray = this.mDelegateMap;
        synchronized (sparseArray) {
            request = (AuthenticationRequestState)this.mDelegateMap.get(requestId);
        }
        if (request == null) {
            Logger.e(TAG, "Request callback is not available for requestId:" + requestId, "", ADALError.CALLBACK_IS_NOT_FOUND);
            throw new AuthenticationException(ADALError.CALLBACK_IS_NOT_FOUND, "Request callback is not available for requestId:" + requestId);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putWaitingRequest(int requestId, AuthenticationRequestState requestState) {
        if (requestState == null) {
            return;
        }
        Logger.v(TAG, "Put waiting request: " + requestId + this.getCorrelationInfoFromWaitingRequest(requestState));
        SparseArray<AuthenticationRequestState> sparseArray = this.mDelegateMap;
        synchronized (sparseArray) {
            this.mDelegateMap.put(requestId, (Object)requestState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWaitingRequest(int requestId) {
        Logger.v(TAG, "Remove waiting request: " + requestId);
        SparseArray<AuthenticationRequestState> sparseArray = this.mDelegateMap;
        synchronized (sparseArray) {
            this.mDelegateMap.remove(requestId);
        }
    }

    String getCorrelationInfoFromWaitingRequest(AuthenticationRequestState waitingRequest) {
        UUID requestCorrelationID = this.getRequestCorrelationId();
        if (waitingRequest.getRequest() != null) {
            requestCorrelationID = waitingRequest.getRequest().getCorrelationId();
        }
        return String.format(" CorrelationId: %s", requestCorrelationID.toString());
    }

    public static String getVersionName() {
        return "1.10.0";
    }

    static final class SettableFuture<V>
    extends FutureTask<V> {
        SettableFuture() {
            super(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return null;
                }
            });
        }

        @Override
        public void set(V v) {
            super.set(v);
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }
    }
}

