/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AcquireTokenInteractiveRequest;
import com.microsoft.aad.adal.AcquireTokenSilentHandler;
import com.microsoft.aad.adal.AcquireTokenWithBrokerRequest;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationDialog;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationRequestState;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.ClientAnalytics;
import com.microsoft.aad.adal.Discovery;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.HttpWebRequest;
import com.microsoft.aad.adal.IBrokerProxy;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.InstrumentationPropertiesBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheAccessor;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UsageAuthenticationException;
import com.microsoft.aad.adal.UserInfo;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class AcquireTokenRequest {
    private static final String TAG = AcquireTokenRequest.class.getSimpleName();
    private static final ExecutorService THREAD_EXECUTOR = Executors.newSingleThreadExecutor();
    private final Context mContext;
    private final AuthenticationContext mAuthContext;
    private TokenCacheAccessor mTokenCacheAccessor;
    private final IBrokerProxy mBrokerProxy;
    private Handler mHandler = null;
    private BrokerResumeResultReceiver mBrokerResumeResultReceiver = null;
    private static final int TIMEOUT_FOR_BROKER_RESULT = 600000;
    private boolean mAcquireTokenSilentWithBroker = false;
    private Discovery mDiscovery = new Discovery();

    AcquireTokenRequest(Context appContext, AuthenticationContext authContext) {
        this.mContext = appContext;
        this.mAuthContext = authContext;
        if (authContext.getCache() != null) {
            this.mTokenCacheAccessor = new TokenCacheAccessor(authContext.getCache(), authContext.getAuthority());
        }
        this.mBrokerProxy = new BrokerProxy(appContext);
    }

    void acquireToken(final IWindowComponent activity, final boolean useDialog, final AuthenticationRequest authRequest, AuthenticationCallback<AuthenticationResult> authenticationCallback) {
        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), authenticationCallback);
        Logger.setCorrelationId(authRequest.getCorrelationId());
        Logger.v(TAG, "Sending async task from thread:" + Process.myTid());
        THREAD_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Logger.v(TAG, "Running task in thread:" + Process.myTid());
                try {
                    AcquireTokenRequest.this.validateAcquireTokenRequest(authRequest);
                    AcquireTokenRequest.this.performAcquireTokenRequest(callbackHandle, activity, useDialog, authRequest);
                }
                catch (AuthenticationException authenticationException) {
                    callbackHandle.onError(authenticationException);
                }
            }
        });
    }

    void refreshTokenWithoutCache(final String refreshToken, final AuthenticationRequest authenticationRequest, AuthenticationCallback<AuthenticationResult> externalCallback) {
        Logger.setCorrelationId(authenticationRequest.getCorrelationId());
        Logger.v(TAG, "Refresh token without cache");
        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), externalCallback);
        THREAD_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AcquireTokenRequest.this.validateAcquireTokenRequest(authenticationRequest);
                    AcquireTokenSilentHandler acquireTokenSilentHandler = new AcquireTokenSilentHandler(AcquireTokenRequest.this.mContext, authenticationRequest, AcquireTokenRequest.this.mTokenCacheAccessor);
                    AuthenticationResult authResult = acquireTokenSilentHandler.acquireTokenWithRefreshToken(refreshToken);
                    callbackHandle.onSuccess(authResult);
                }
                catch (AuthenticationException authenticationException) {
                    callbackHandle.onError(authenticationException);
                }
            }
        });
    }

    private void validateAcquireTokenRequest(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        BrokerProxy.SwitchToBroker canSwitchToBrokerFlag;
        URL authorityUrl = StringExtensions.getUrl(authenticationRequest.getAuthority());
        if (authorityUrl == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL);
        }
        if (this.mAuthContext.getValidateAuthority()) {
            this.validateAuthority(authorityUrl);
        }
        if ((canSwitchToBrokerFlag = this.mBrokerProxy.canSwitchToBroker()) != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER && this.mBrokerProxy.verifyUser(authenticationRequest.getLoginHint(), authenticationRequest.getUserId()) && !authenticationRequest.isSilent()) {
            if (canSwitchToBrokerFlag == BrokerProxy.SwitchToBroker.NEED_PERMISSIONS_TO_SWITCH_TO_BROKER) {
                throw new UsageAuthenticationException(ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING, "Broker related permissions are missing for GET_ACCOUNTS.");
            }
            this.verifyBrokerRedirectUri(authenticationRequest);
        }
    }

    private void validateAuthority(URL authorityUrl) throws AuthenticationException {
        if (this.mAuthContext.getIsAuthorityValidated()) {
            return;
        }
        Logger.v(TAG, "Start validating authority");
        this.mDiscovery.setCorrelationId(this.mAuthContext.getRequestCorrelationId());
        this.mDiscovery.validateAuthority(authorityUrl);
        Logger.v(TAG, "The passe in authority is valid.");
        this.mAuthContext.setIsAuthorityValidated(true);
    }

    private void performAcquireTokenRequest(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest authenticationRequest) throws AuthenticationException {
        AuthenticationResult authenticationResultFromSilentRequest = this.tryAcquireTokenSilent(authenticationRequest);
        if (this.isAccessTokenReturned(authenticationResultFromSilentRequest)) {
            callbackHandle.onSuccess(authenticationResultFromSilentRequest);
            return;
        }
        Logger.d(TAG, "Trying to acquire token interactively.");
        this.acquireTokenInteractiveFlow(callbackHandle, activity, useDialog, authenticationRequest);
    }

    private AuthenticationResult tryAcquireTokenSilent(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        AuthenticationResult authenticationResult = null;
        if (this.shouldTrySilentFlow(authenticationRequest)) {
            Logger.v(TAG, "Try to acquire token silently, return valid AT or use RT in the cache.");
            authenticationResult = this.acquireTokenSilentFlow(authenticationRequest);
            boolean isAccessTokenReturned = this.isAccessTokenReturned(authenticationResult);
            if (!isAccessTokenReturned && authenticationRequest.isSilent()) {
                String errorInfo = authenticationResult == null ? "No result returned from acquireTokenSilent" : authenticationResult.getErrorLogInfo();
                Logger.e(TAG, "Prompt is not allowed and failed to get token:", authenticationRequest.getLogInfo() + " " + errorInfo, ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED);
                throw new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, authenticationRequest.getLogInfo() + " " + errorInfo);
            }
            if (isAccessTokenReturned) {
                Logger.v(TAG, "Token is successfully returned from silent flow. ");
                ClientAnalytics.logEvent(new RefreshTokenEvent(new InstrumentationPropertiesBuilder(authenticationRequest, authenticationResult), "Success", this.mAcquireTokenSilentWithBroker));
            }
        }
        return authenticationResult;
    }

    private boolean shouldTrySilentFlow(AuthenticationRequest authenticationRequest) {
        return authenticationRequest.getPrompt() == PromptBehavior.Auto || authenticationRequest.isSilent();
    }

    private AuthenticationResult acquireTokenSilentFlow(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        AuthenticationResult authResult = this.tryAcquireTokenSilentLocally(authenticationRequest);
        if (this.isAccessTokenReturned(authResult)) {
            return authResult;
        }
        if (this.mBrokerProxy.canSwitchToBroker() == BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER || !this.mBrokerProxy.verifyUser(authenticationRequest.getLoginHint(), authenticationRequest.getUserId())) {
            return authResult;
        }
        Logger.d(TAG, "Cannot get AT from local cache, switch to Broker for auth, clear tokens from local cache for the user.");
        this.removeTokensForUser(authenticationRequest);
        return this.tryAcquireTokenSilentWithBroker(authenticationRequest);
    }

    private AuthenticationResult tryAcquireTokenSilentLocally(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        AuthenticationResult authResult;
        Logger.v(TAG, "Try to silently get token from local cache.");
        AcquireTokenSilentHandler acquireTokenSilentHandler = new AcquireTokenSilentHandler(this.mContext, authenticationRequest, this.mTokenCacheAccessor);
        try {
            authResult = acquireTokenSilentHandler.getAccessToken();
        }
        catch (AuthenticationException authenticationException) {
            ClientAnalytics.logEvent(new RefreshTokenEvent(new InstrumentationPropertiesBuilder(authenticationRequest, authenticationException), "Fail"));
            throw authenticationException;
        }
        return authResult;
    }

    private AuthenticationResult tryAcquireTokenSilentWithBroker(AuthenticationRequest authenticationRequest) throws AuthenticationException {
        AuthenticationResult authResult;
        this.mAcquireTokenSilentWithBroker = true;
        try {
            AcquireTokenWithBrokerRequest acquireTokenWithBrokerRequest = new AcquireTokenWithBrokerRequest(authenticationRequest, this.mBrokerProxy);
            authResult = acquireTokenWithBrokerRequest.acquireTokenWithBrokerSilent();
        }
        catch (AuthenticationException authenticationException) {
            ClientAnalytics.logEvent(new RefreshTokenEvent(new InstrumentationPropertiesBuilder(authenticationRequest, authenticationException), "Fail", true));
            throw authenticationException;
        }
        return authResult;
    }

    private void removeTokensForUser(AuthenticationRequest request) throws AuthenticationException {
        if (this.mTokenCacheAccessor == null) {
            return;
        }
        String user = !StringExtensions.isNullOrBlank(request.getUserId()) ? request.getUserId() : request.getLoginHint();
        TokenCacheItem frtItem = this.mTokenCacheAccessor.getFRTItem("1", user);
        if (frtItem != null) {
            this.mTokenCacheAccessor.removeTokenCacheItem(frtItem, request.getResource());
        }
        TokenCacheItem mrrtItem = this.mTokenCacheAccessor.getMRRTItem(request.getClientId(), user);
        TokenCacheItem regularTokenCacheItem = this.mTokenCacheAccessor.getRegularRefreshTokenCacheItem(request.getResource(), request.getClientId(), user);
        if (mrrtItem != null) {
            this.mTokenCacheAccessor.removeTokenCacheItem(mrrtItem, request.getResource());
        } else if (regularTokenCacheItem != null) {
            this.mTokenCacheAccessor.removeTokenCacheItem(regularTokenCacheItem, request.getResource());
        } else {
            Logger.v(TAG, "No token items need to be deleted for the user.");
        }
    }

    private void acquireTokenInteractiveFlow(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest authenticationRequest) throws AuthenticationException {
        if (activity == null && !useDialog) {
            throw new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, authenticationRequest.getLogInfo() + " Cannot launch webview, acitivity is null.");
        }
        HttpWebRequest.throwIfNetworkNotAvaliable(this.mContext);
        int requestId = callbackHandle.getCallback().hashCode();
        authenticationRequest.setRequestId(requestId);
        this.mAuthContext.putWaitingRequest(requestId, new AuthenticationRequestState(requestId, authenticationRequest, callbackHandle.getCallback()));
        BrokerProxy.SwitchToBroker switchToBrokerFlag = this.mBrokerProxy.canSwitchToBroker();
        if (switchToBrokerFlag != BrokerProxy.SwitchToBroker.CANNOT_SWITCH_TO_BROKER && this.mBrokerProxy.verifyUser(authenticationRequest.getLoginHint(), authenticationRequest.getUserId())) {
            if (switchToBrokerFlag == BrokerProxy.SwitchToBroker.NEED_PERMISSIONS_TO_SWITCH_TO_BROKER) {
                throw new UsageAuthenticationException(ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING, "Broker related permissions are missing for GET_ACCOUNTS");
            }
            Logger.v(TAG, "Launch activity for interactive authentication via broker with callback: " + callbackHandle.getCallback().hashCode());
            AcquireTokenWithBrokerRequest acquireTokenWithBrokerRequest = new AcquireTokenWithBrokerRequest(authenticationRequest, this.mBrokerProxy);
            acquireTokenWithBrokerRequest.acquireTokenWithBrokerInteractively(activity);
        } else {
            Logger.v(TAG, "Starting Authentication Activity for embedded flow. Callback is:" + callbackHandle.getCallback().hashCode());
            AcquireTokenInteractiveRequest acquireTokenInteractiveRequest = new AcquireTokenInteractiveRequest(this.mContext, authenticationRequest, this.mTokenCacheAccessor);
            acquireTokenInteractiveRequest.acquireToken(activity, useDialog ? new AuthenticationDialog(this.getHandler(), this.mContext, this, authenticationRequest) : null);
        }
    }

    private void verifyBrokerRedirectUri(AuthenticationRequest request) throws UsageAuthenticationException {
        String base64URLEncodeSignature;
        String base64URLEncodePackagename;
        String methodName = ":verifyBrokerRedirectUri";
        String inputUri = request.getRedirectUri();
        String actualRedirectUri = this.mAuthContext.getRedirectUriForBroker();
        if (StringExtensions.isNullOrBlank(inputUri)) {
            String errMsg = "The redirectUri is null or blank. so the redirect uri is expected to be:" + actualRedirectUri;
            Logger.e(TAG + ":verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
        }
        if (!inputUri.startsWith("msauth://")) {
            String errMsg = "The prefix of the redirect uri does not match the expected value.  The valid broker redirect URI prefix: msauth so the redirect uri is expected to be: " + actualRedirectUri;
            Logger.e(TAG + ":verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
        }
        PackageHelper packageHelper = new PackageHelper(this.mContext);
        try {
            base64URLEncodePackagename = URLEncoder.encode(this.mContext.getPackageName(), "UTF_8");
            base64URLEncodeSignature = URLEncoder.encode(packageHelper.getCurrentSignatureForPackage(this.mContext.getPackageName()), "UTF_8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG + ":verifyBrokerRedirectUri", e.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
            throw new UsageAuthenticationException(ADALError.ENCODING_IS_NOT_SUPPORTED, "The verifying BrokerRedirectUri process failed because the base64 url encoding is not supported.", e);
        }
        if (!inputUri.startsWith("msauth://" + base64URLEncodePackagename + "/")) {
            String errMsg = "The base64 url encoded package name component of the redirect uri does not match the expected value. This apps package name is: " + base64URLEncodePackagename + " so the redirect uri is expected to be: " + actualRedirectUri;
            Logger.e(TAG + ":verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
        }
        if (!inputUri.equalsIgnoreCase(actualRedirectUri)) {
            String errMsg = "The base64 url encoded signature component of the redirect uri does not match the expected value. This apps signature is: " + base64URLEncodeSignature + " so the redirect uri is expected to be: " + actualRedirectUri;
            Logger.e(TAG + ":verifyBrokerRedirectUri", errMsg, "", ADALError.DEVELOPER_REDIRECTURI_INVALID);
            throw new UsageAuthenticationException(ADALError.DEVELOPER_REDIRECTURI_INVALID, errMsg);
        }
        Logger.v(TAG + ":verifyBrokerRedirectUri", "The broker redirect URI is valid: " + inputUri);
    }

    void onActivityResult(int requestCode, int resultCode, Intent data) {
        String methodName = ":onActivityResult";
        if (requestCode == 1001) {
            this.getHandler();
            if (data == null) {
                Logger.e(TAG, "onActivityResult BROWSER_FLOW data is null.", "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
            } else {
                AuthenticationRequestState waitingRequest;
                Bundle extras = data.getExtras();
                final int requestId = extras.getInt("com.microsoft.aad.adal:RequestId");
                try {
                    waitingRequest = this.mAuthContext.getWaitingRequest(requestId);
                    Logger.v(TAG, "onActivityResult RequestId:" + requestId);
                }
                catch (AuthenticationException authenticationException) {
                    Logger.e(TAG, "onActivityResult did not find waiting request for RequestId:" + requestId, "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
                    return;
                }
                String correlationInfo = this.mAuthContext.getCorrelationInfoFromWaitingRequest(waitingRequest);
                if (resultCode == 2004) {
                    String accessToken = data.getStringExtra("account.access.token");
                    String accountName = data.getStringExtra("account.name");
                    this.mBrokerProxy.saveAccount(accountName);
                    long expireTime = data.getLongExtra("account.expiredate", 0L);
                    Date expire = new Date(expireTime);
                    String idtoken = data.getStringExtra("account.idtoken");
                    String tenantId = data.getStringExtra("account.userinfo.tenantid");
                    UserInfo userinfo = UserInfo.getUserInfoFromBrokerResult(data.getExtras());
                    AuthenticationResult brokerResult = new AuthenticationResult(accessToken, null, expire, false, userinfo, tenantId, idtoken, null);
                    if (brokerResult.getAccessToken() != null) {
                        waitingRequest.getDelegate().onSuccess(brokerResult);
                    }
                } else if (resultCode == 2001) {
                    Logger.v(TAG, "User cancelled the flow RequestId:" + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationCancelError("User cancelled the flow RequestId:" + requestId + correlationInfo));
                } else if (resultCode == 2006) {
                    Logger.v(TAG + ":onActivityResult", "Device needs to have broker installed, waiting the broker installation. Once broker is installed, request will be resumed and result will be received");
                    this.mBrokerResumeResultReceiver = new BrokerResumeResultReceiver();
                    new ContextWrapper(this.mContext).registerReceiver((BroadcastReceiver)this.mBrokerResumeResultReceiver, new IntentFilter("com.microsoft.aadbroker.adal.broker.request.resume" + this.mContext.getPackageName()), null, this.getHandler());
                    this.getHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (!AcquireTokenRequest.this.mBrokerResumeResultReceiver.isResultReceivedFromBroker()) {
                                Logger.v(TAG + "onActivityResult", "BrokerResumeResultReceiver doesn't receive result from broker within 10 minutes, unregister the receiver and cancelling the request");
                                new ContextWrapper(AcquireTokenRequest.this.mContext).unregisterReceiver((BroadcastReceiver)AcquireTokenRequest.this.mBrokerResumeResultReceiver);
                                AcquireTokenRequest.this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationCancelError("Broker doesn't return back the result within 10 minutes"));
                            }
                        }
                    }, 600000L);
                } else if (resultCode == 2005) {
                    Serializable authException = extras.getSerializable("com.microsoft.aad.adal:AuthenticationException");
                    if (authException != null && authException instanceof AuthenticationException) {
                        AuthenticationException exception = (AuthenticationException)authException;
                        Logger.w(TAG, "Webview returned exception", exception.getMessage(), ADALError.WEBVIEW_RETURNED_AUTHENTICATION_EXCEPTION);
                        this.waitingRequestOnError(waitingRequest, requestId, exception);
                    } else {
                        this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.WEBVIEW_RETURNED_INVALID_AUTHENTICATION_EXCEPTION, correlationInfo));
                    }
                } else if (resultCode == 2002) {
                    String errCode = extras.getString("com.microsoft.aad.adal:BrowserErrorCode");
                    String errMessage = extras.getString("com.microsoft.aad.adal:BrowserErrorMessage");
                    Logger.v(TAG, "Error info:" + errCode + " " + errMessage + " for requestId: " + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.SERVER_INVALID_REQUEST, errCode + " " + errMessage + correlationInfo));
                } else if (resultCode == 2003) {
                    AuthenticationRequest authenticationRequest = (AuthenticationRequest)extras.getSerializable("com.microsoft.aad.adal:BrowserRequestInfo");
                    final String endingUrl = extras.getString("com.microsoft.aad.adal:BrowserFinalUrl", "");
                    if (endingUrl.isEmpty()) {
                        StringBuilder exceptionMessage = new StringBuilder("Webview did not reach the redirectUrl. ");
                        if (authenticationRequest != null) {
                            exceptionMessage.append(authenticationRequest.getLogInfo());
                        }
                        exceptionMessage.append(correlationInfo);
                        AuthenticationException e = new AuthenticationException(ADALError.WEBVIEW_RETURNED_EMPTY_REDIRECT_URL, exceptionMessage.toString());
                        Logger.e(TAG, e.getMessage(), "", e.getCode());
                        this.waitingRequestOnError(waitingRequest, requestId, e);
                    } else {
                        final CallbackHandler callbackHandle = new CallbackHandler(this.getHandler(), waitingRequest.getDelegate());
                        THREAD_EXECUTOR.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AcquireTokenInteractiveRequest acquireTokenInteractiveRequest = new AcquireTokenInteractiveRequest(AcquireTokenRequest.this.mContext, waitingRequest.getRequest(), AcquireTokenRequest.this.mTokenCacheAccessor);
                                    AuthenticationResult authenticationResult = acquireTokenInteractiveRequest.acquireTokenWithAuthCode(endingUrl);
                                    if (waitingRequest.getDelegate() != null) {
                                        Logger.v(TAG, "Sending result to callback. " + waitingRequest.getRequest().getLogInfo());
                                        callbackHandle.onSuccess(authenticationResult);
                                    }
                                }
                                catch (AuthenticationException authenticationException) {
                                    StringBuilder message = new StringBuilder(authenticationException.getMessage());
                                    if (authenticationException.getCause() != null) {
                                        message.append(authenticationException.getCause().getMessage());
                                    }
                                    Logger.e(TAG, message.toString(), ExceptionExtensions.getExceptionMessage(authenticationException), ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, authenticationException);
                                    AcquireTokenRequest.this.waitingRequestOnError(callbackHandle, waitingRequest, requestId, authenticationException);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private boolean isAccessTokenReturned(AuthenticationResult authResult) {
        return authResult != null && !StringExtensions.isNullOrBlank(authResult.getAccessToken());
    }

    private synchronized Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.mContext.getMainLooper());
        }
        return this.mHandler;
    }

    private void waitingRequestOnError(AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        this.waitingRequestOnError(null, waitingRequest, requestId, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitingRequestOnError(CallbackHandler handler, AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        try {
            if (waitingRequest != null && waitingRequest.getDelegate() != null) {
                Logger.v(TAG, "Sending error to callback" + this.mAuthContext.getCorrelationInfoFromWaitingRequest(waitingRequest));
                if (handler != null) {
                    handler.onError(exc);
                } else {
                    waitingRequest.getDelegate().onError(exc);
                }
            }
        }
        finally {
            if (exc != null && exc.getCode() != ADALError.AUTH_FAILED_CANCELLED) {
                this.mAuthContext.removeWaitingRequest(requestId);
            }
        }
    }

    private static final class RefreshTokenEvent
    extends ClientAnalytics.Event {
        private RefreshTokenEvent(InstrumentationPropertiesBuilder builder, String result) {
            this(builder, result, false);
        }

        private RefreshTokenEvent(InstrumentationPropertiesBuilder builder, String result, boolean isBroker) {
            super("RefreshToken", builder.add("Result", result).add("BrokerApp", Boolean.valueOf(isBroker).toString()).build());
        }
    }

    protected class BrokerResumeResultReceiver
    extends BroadcastReceiver {
        private boolean mReceivedResultFromBroker = false;

        public void onReceive(Context context, Intent intent) {
            AuthenticationRequestState waitingRequest;
            String methodName = ":BrokerResumeResultReceiver:onReceive";
            Logger.d(TAG + ":BrokerResumeResultReceiver:onReceive", "Received result from broker.");
            int receivedWaitingRequestId = intent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
            if (receivedWaitingRequestId == 0) {
                Logger.v(TAG + ":BrokerResumeResultReceiver:onReceive", "Received waiting request is 0, error will be thrown, cannot find correct callback to send back the result.");
                return;
            }
            this.mReceivedResultFromBroker = true;
            try {
                waitingRequest = AcquireTokenRequest.this.mAuthContext.getWaitingRequest(receivedWaitingRequestId);
            }
            catch (AuthenticationException authenticationException) {
                Logger.e(TAG, "No waiting request exists", "", ADALError.CALLBACK_IS_NOT_FOUND, authenticationException);
                new ContextWrapper(AcquireTokenRequest.this.mContext).unregisterReceiver((BroadcastReceiver)AcquireTokenRequest.this.mBrokerResumeResultReceiver);
                return;
            }
            String errorCode = intent.getStringExtra("com.microsoft.aad.adal:BrowserErrorCode");
            if (!StringExtensions.isNullOrBlank(errorCode)) {
                String errorMessage = intent.getStringExtra("com.microsoft.aad.adal:BrowserErrorMessage");
                String returnedErrorMessage = "ErrorCode: " + errorCode + " ErrorMessage" + errorMessage + AcquireTokenRequest.this.mAuthContext.getCorrelationInfoFromWaitingRequest(waitingRequest);
                Logger.v(TAG + ":BrokerResumeResultReceiver:onReceive", returnedErrorMessage);
                AcquireTokenRequest.this.waitingRequestOnError(waitingRequest, receivedWaitingRequestId, new AuthenticationException(ADALError.AUTH_FAILED, returnedErrorMessage));
            } else {
                boolean isBrokerCompleteTokenRequest = intent.getBooleanExtra("broker.result.returned", false);
                if (isBrokerCompleteTokenRequest) {
                    Logger.v(TAG + ":BrokerResumeResultReceiver:onReceive", "Broker already completed the token request, calling acquireTokenSilentSync to retrieve token from broker.");
                    AuthenticationRequest authenticationRequest = waitingRequest.getRequest();
                    String userId = intent.getStringExtra("account.userinfo.userid");
                    if (StringExtensions.isNullOrBlank(userId)) {
                        userId = authenticationRequest.getUserId();
                    }
                    authenticationRequest.setSilent(true);
                    authenticationRequest.setUserId(userId);
                    authenticationRequest.setUserIdentifierType(AuthenticationRequest.UserIdentifierType.UniqueId);
                    AcquireTokenRequest.this.acquireToken(null, false, authenticationRequest, waitingRequest.getDelegate());
                } else {
                    Logger.v(TAG + ":BrokerResumeResultReceiver:onReceive", "Broker doesn't send back error nor the completion notification.");
                    AcquireTokenRequest.this.waitingRequestOnError(waitingRequest, receivedWaitingRequestId, new AuthenticationException(ADALError.AUTH_FAILED, "Broker doesn't send back error nor the completion notification."));
                }
            }
            new ContextWrapper(AcquireTokenRequest.this.mContext).unregisterReceiver((BroadcastReceiver)AcquireTokenRequest.this.mBrokerResumeResultReceiver);
        }

        public boolean isResultReceivedFromBroker() {
            return this.mReceivedResultFromBroker;
        }
    }

    private static class CallbackHandler {
        private Handler mRefHandler;
        private AuthenticationCallback<AuthenticationResult> mCallback;

        public CallbackHandler(Handler ref, AuthenticationCallback<AuthenticationResult> callbackExt) {
            this.mRefHandler = ref;
            this.mCallback = callbackExt;
        }

        public void onError(final AuthenticationException e) {
            if (this.mCallback != null) {
                if (this.mRefHandler != null) {
                    this.mRefHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CallbackHandler.this.mCallback.onError(e);
                        }
                    });
                } else {
                    this.mCallback.onError(e);
                }
            }
        }

        public void onSuccess(final AuthenticationResult result) {
            if (this.mCallback != null) {
                if (this.mRefHandler != null) {
                    this.mRefHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CallbackHandler.this.mCallback.onSuccess(result);
                        }
                    });
                } else {
                    this.mCallback.onSuccess(result);
                }
            }
        }

        AuthenticationCallback<AuthenticationResult> getCallback() {
            return this.mCallback;
        }
    }
}

