/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.microsoft.aad.adal.R;

class HttpAuthDialog {
    private static final String TAG = "HttpAuthDialog";
    private final Context mContext;
    private final String mHost;
    private final String mRealm;
    private AlertDialog mDialog;
    private EditText mUsernameView;
    private EditText mPasswordView;
    private OkListener mOkListener;
    private CancelListener mCancelListener;

    public HttpAuthDialog(Context context, String host, String realm) {
        this.mContext = context;
        this.mHost = host;
        this.mRealm = realm;
        this.mDialog = null;
        this.createDialog();
    }

    public void setOkListener(OkListener okListener) {
        this.mOkListener = okListener;
    }

    public void setCancelListener(CancelListener cancelListener) {
        this.mCancelListener = cancelListener;
    }

    public void show() {
        this.mDialog.show();
        this.mUsernameView.requestFocus();
    }

    private void createDialog() {
        LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
        View v = factory.inflate(R.layout.http_auth_dialog, null);
        this.mUsernameView = (EditText)v.findViewById(R.id.editUserName);
        this.mPasswordView = (EditText)v.findViewById(R.id.editPassword);
        this.mPasswordView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    HttpAuthDialog.this.mDialog.getButton(-1).performClick();
                    return true;
                }
                return false;
            }
        });
        String title = ((Object)this.mContext.getText(R.string.http_auth_dialog_title)).toString();
        this.mDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)title).setView(v).setPositiveButton(R.string.http_auth_dialog_login, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (HttpAuthDialog.this.mOkListener != null) {
                    HttpAuthDialog.this.mOkListener.onOk(HttpAuthDialog.this.mHost, HttpAuthDialog.this.mRealm, HttpAuthDialog.this.mUsernameView.getText().toString(), HttpAuthDialog.this.mPasswordView.getText().toString());
                }
            }
        }).setNegativeButton(R.string.http_auth_dialog_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (HttpAuthDialog.this.mCancelListener != null) {
                    HttpAuthDialog.this.mCancelListener.onCancel();
                }
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (HttpAuthDialog.this.mCancelListener != null) {
                    HttpAuthDialog.this.mCancelListener.onCancel();
                }
            }
        }).create();
    }

    public static interface CancelListener {
        public void onCancel();
    }

    public static interface OkListener {
        public void onOk(String var1, String var2, String var3, String var4);
    }
}

