/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.PromptBehavior;
import java.io.Serializable;
import java.util.UUID;

class AuthenticationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int mRequestId = 0;
    private String mAuthority = null;
    private String mRedirectUri = null;
    private String mResource = null;
    private String mClientId = null;
    private String mLoginHint = null;
    private String mUserId = null;
    private String mBrokerAccountName = null;
    private UUID mCorrelationId;
    private String mExtraQueryParamsAuthentication;
    private PromptBehavior mPrompt;
    private boolean mSilent = false;
    private String mVersion = null;
    private UserIdentifierType mIdentifierType;

    public AuthenticationRequest() {
        this.mIdentifierType = UserIdentifierType.NoUser;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint, PromptBehavior prompt, String extraQueryParams, UUID correlationId) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mBrokerAccountName = this.mLoginHint = loginhint;
        this.mPrompt = prompt;
        this.mExtraQueryParamsAuthentication = extraQueryParams;
        this.mCorrelationId = correlationId;
        this.mIdentifierType = UserIdentifierType.NoUser;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint, UUID requestCorrelationId) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mBrokerAccountName = this.mLoginHint = loginhint;
        this.mCorrelationId = requestCorrelationId;
    }

    public AuthenticationRequest(String authority, String resource, String client, String redirect, String loginhint) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = client;
        this.mRedirectUri = redirect;
        this.mBrokerAccountName = this.mLoginHint = loginhint;
    }

    public AuthenticationRequest(String authority, String resource, String clientid) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = clientid;
    }

    public AuthenticationRequest(String authority, String resource, String clientid, String userid, UUID correlationId) {
        this.mAuthority = authority;
        this.mResource = resource;
        this.mClientId = clientid;
        this.mUserId = userid;
        this.mCorrelationId = correlationId;
    }

    public AuthenticationRequest(String authority, String resource, String clientId, UUID correlationId) {
        this.mAuthority = authority;
        this.mClientId = clientId;
        this.mResource = resource;
        this.mCorrelationId = correlationId;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public String getResource() {
        return this.mResource;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public UUID getCorrelationId() {
        return this.mCorrelationId;
    }

    public String getExtraQueryParamsAuthentication() {
        return this.mExtraQueryParamsAuthentication;
    }

    public String getLogInfo() {
        return String.format("Request authority:%s resource:%s clientid:%s", this.mAuthority, this.mResource, this.mClientId);
    }

    public PromptBehavior getPrompt() {
        return this.mPrompt;
    }

    public void setPrompt(PromptBehavior prompt) {
        this.mPrompt = prompt;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public void setRequestId(int requestId) {
        this.mRequestId = requestId;
    }

    public String getBrokerAccountName() {
        return this.mBrokerAccountName;
    }

    public void setBrokerAccountName(String brokerAccountName) {
        this.mBrokerAccountName = brokerAccountName;
    }

    void setLoginHint(String name) {
        this.mLoginHint = name;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public boolean isSilent() {
        return this.mSilent;
    }

    public void setSilent(boolean silent) {
        this.mSilent = silent;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public UserIdentifierType getUserIdentifierType() {
        return this.mIdentifierType;
    }

    public void setUserIdentifierType(UserIdentifierType user) {
        this.mIdentifierType = user;
    }

    static enum UserIdentifierType {
        UniqueId,
        LoginHint,
        NoUser;

    }
}

