/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Intent;
import android.text.TextUtils;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

class WebviewHelper {
    private static final String TAG = "WebviewHelper";
    private Intent mRequestIntent;
    private AuthenticationRequest mRequest;

    public WebviewHelper(Intent requestIntent) {
        this.mRequestIntent = requestIntent;
        this.mRequest = this.getAuthenticationRequestFromIntent(this.mRequestIntent);
    }

    public void validateRequestIntent() {
        if (this.mRequest == null) {
            Logger.v(TAG, "Request item is null, so it returns to caller");
            throw new IllegalArgumentException("Request is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getAuthority())) {
            throw new IllegalArgumentException("Authority is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getResource())) {
            throw new IllegalArgumentException("Resource is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getClientId())) {
            throw new IllegalArgumentException("ClientId is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getRedirectUri())) {
            throw new IllegalArgumentException("RedirectUri is null");
        }
    }

    public String getStartUrl() throws UnsupportedEncodingException {
        Oauth2 oauth = new Oauth2(this.mRequest);
        return oauth.getCodeRequestUrl();
    }

    public String getRedirectUrl() {
        return this.mRequest.getRedirectUri();
    }

    public Intent getResultIntent(String finalUrl) {
        if (this.mRequestIntent != null) {
            AuthenticationRequest authRequest = this.getAuthenticationRequestFromIntent(this.mRequestIntent);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", finalUrl);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)authRequest);
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", authRequest.getRequestId());
            return resultIntent;
        }
        throw new IllegalArgumentException("requestIntent is null");
    }

    private AuthenticationRequest getAuthenticationRequestFromIntent(Intent callingIntent) {
        AuthenticationRequest authRequest = null;
        Serializable request = callingIntent.getSerializableExtra("com.microsoft.aad.adal:BrowserRequestMessage");
        if (request instanceof AuthenticationRequest) {
            authRequest = (AuthenticationRequest)request;
        }
        return authRequest;
    }
}

