/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.ChallangeResponseBuilder;
import com.microsoft.aad.adal.ClientMetrics;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.UserInfo;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class Oauth2 {
    private AuthenticationRequest mRequest;
    private IWebRequestHandler mWebRequestHandler;
    private IJWSBuilder mJWSBuilder = new JWSBuilder();
    private static final String TAG = "Oauth";
    private static final String DEFAULT_AUTHORIZE_ENDPOINT = "/oauth2/authorize";
    private static final String DEFAULT_TOKEN_ENDPOINT = "/oauth2/token";
    private static final String JSON_PARSING_ERROR = "It failed to parse response as json";

    Oauth2(AuthenticationRequest request) {
        this.mRequest = request;
        this.mWebRequestHandler = null;
        this.mJWSBuilder = null;
    }

    public Oauth2(AuthenticationRequest request, IWebRequestHandler webRequestHandler) {
        this.mRequest = request;
        this.mWebRequestHandler = webRequestHandler;
        this.mJWSBuilder = null;
    }

    public Oauth2(AuthenticationRequest request, IWebRequestHandler webRequestHandler, IJWSBuilder jwsMessageBuilder) {
        this.mRequest = request;
        this.mWebRequestHandler = webRequestHandler;
        this.mJWSBuilder = jwsMessageBuilder;
    }

    public String getAuthorizationEndpoint() {
        return this.mRequest.getAuthority() + DEFAULT_AUTHORIZE_ENDPOINT;
    }

    public String getTokenEndpoint() {
        return this.mRequest.getAuthority() + DEFAULT_TOKEN_ENDPOINT;
    }

    public String getAuthorizationEndpointQueryParameters() throws UnsupportedEncodingException {
        String requestUrl = String.format("response_type=%s&client_id=%s&resource=%s&redirect_uri=%s&state=%s", "code", URLEncoder.encode(this.mRequest.getClientId(), "UTF_8"), URLEncoder.encode(this.mRequest.getResource(), "UTF_8"), URLEncoder.encode(this.mRequest.getRedirectUri(), "UTF_8"), this.encodeProtocolState());
        if (this.mRequest.getLoginHint() != null && !this.mRequest.getLoginHint().isEmpty()) {
            requestUrl = String.format("%s&%s=%s", requestUrl, "login_hint", URLEncoder.encode(this.mRequest.getLoginHint(), "UTF_8"));
        }
        requestUrl = String.format("%s&%s=%s", requestUrl, "x-client-SKU", "Android");
        requestUrl = String.format("%s&%s=%s", requestUrl, "x-client-Ver", URLEncoder.encode(AuthenticationContext.getVersionName(), "UTF_8"));
        requestUrl = String.format("%s&%s=%s", requestUrl, "x-client-OS", URLEncoder.encode("" + Build.VERSION.SDK_INT, "UTF_8"));
        requestUrl = String.format("%s&%s=%s", requestUrl, "x-client-DM", URLEncoder.encode("" + Build.MODEL, "UTF_8"));
        if (this.mRequest.getCorrelationId() != null) {
            requestUrl = String.format("%s&%s=%s", requestUrl, "client-request-id", URLEncoder.encode(this.mRequest.getCorrelationId().toString(), "UTF_8"));
        }
        if (this.mRequest.getPrompt() == PromptBehavior.Always) {
            requestUrl = String.format("%s&%s=%s", requestUrl, "prompt", URLEncoder.encode("login", "UTF_8"));
        } else if (this.mRequest.getPrompt() == PromptBehavior.REFRESH_SESSION) {
            requestUrl = String.format("%s&%s=%s", requestUrl, "prompt", URLEncoder.encode("refresh_session", "UTF_8"));
        }
        if (!StringExtensions.IsNullOrBlank(this.mRequest.getExtraQueryParamsAuthentication())) {
            String params = this.mRequest.getExtraQueryParamsAuthentication();
            if (!params.startsWith("&")) {
                params = "&" + params;
            }
            requestUrl = requestUrl + params;
        }
        return requestUrl;
    }

    public String getCodeRequestUrl() throws UnsupportedEncodingException {
        String requestUrl = String.format("%s?%s", this.getAuthorizationEndpoint(), this.getAuthorizationEndpointQueryParameters());
        return requestUrl;
    }

    public String buildTokenRequestMessage(String code) throws UnsupportedEncodingException {
        String message = String.format("%s=%s&%s=%s&%s=%s&%s=%s", "grant_type", StringExtensions.URLFormEncode("authorization_code"), "code", StringExtensions.URLFormEncode(code), "client_id", StringExtensions.URLFormEncode(this.mRequest.getClientId()), "redirect_uri", StringExtensions.URLFormEncode(this.mRequest.getRedirectUri()));
        return message;
    }

    public String buildRefreshTokenRequestMessage(String refreshToken) throws UnsupportedEncodingException {
        String message = String.format("%s=%s&%s=%s&%s=%s", "grant_type", StringExtensions.URLFormEncode("refresh_token"), "refresh_token", StringExtensions.URLFormEncode(refreshToken), "client_id", StringExtensions.URLFormEncode(this.mRequest.getClientId()));
        if (!StringExtensions.IsNullOrBlank(this.mRequest.getResource())) {
            message = String.format("%s&%s=%s", message, "resource", StringExtensions.URLFormEncode(this.mRequest.getResource()));
        }
        return message;
    }

    public static AuthenticationResult processUIResponseParams(HashMap<String, String> response) {
        AuthenticationResult result = null;
        if (response.containsKey("error")) {
            UUID correlationId = null;
            String correlationInResponse = response.get("correlation_id");
            if (!StringExtensions.IsNullOrBlank(correlationInResponse)) {
                try {
                    correlationId = UUID.fromString(correlationInResponse);
                    Logger.setCorrelationId(correlationId);
                }
                catch (IllegalArgumentException ex) {
                    correlationId = null;
                    Logger.e(TAG, "CorrelationId is malformed: " + correlationInResponse, "", ADALError.CORRELATION_ID_FORMAT);
                }
            }
            Logger.v(TAG, "OAuth2 error:" + response.get("error") + " Description:" + response.get("error_description"));
            result = new AuthenticationResult(response.get("error"), response.get("error_description"), response.get("error_codes"));
        } else if (response.containsKey("code")) {
            result = new AuthenticationResult(response.get("code"));
        } else if (response.containsKey("access_token")) {
            boolean isMultiResourcetoken = false;
            String expires_in = response.get("expires_in");
            GregorianCalendar expires = new GregorianCalendar();
            ((Calendar)expires).add(13, expires_in == null || expires_in.isEmpty() ? 3600 : Integer.parseInt(expires_in));
            if (response.containsKey("resource")) {
                isMultiResourcetoken = true;
            }
            UserInfo userinfo = null;
            String tenantId = null;
            String rawIdToken = null;
            if (response.containsKey("id_token")) {
                rawIdToken = response.get("id_token");
                if (!StringExtensions.IsNullOrBlank(rawIdToken)) {
                    IdToken tokenParsed = Oauth2.parseIdToken(rawIdToken);
                    if (tokenParsed != null) {
                        tenantId = tokenParsed.mTenantId;
                        userinfo = new UserInfo(tokenParsed);
                    }
                } else {
                    Logger.v(TAG, "IdToken is not provided");
                }
            }
            result = new AuthenticationResult(response.get("access_token"), response.get("refresh_token"), expires.getTime(), isMultiResourcetoken, userinfo, tenantId, rawIdToken);
        }
        return result;
    }

    private static IdToken parseIdToken(String idtoken) {
        try {
            int firstDot = idtoken.indexOf(".");
            int secondDot = idtoken.indexOf(".", firstDot + 1);
            int invalidDot = idtoken.indexOf(".", secondDot + 1);
            if (invalidDot == -1 && firstDot > 0 && secondDot > 0) {
                String idbody = idtoken.substring(firstDot + 1, secondDot);
                byte[] data = Base64.decode((String)idbody, (int)8);
                String decodedBody = new String(data, "UTF-8");
                HashMap<String, String> responseItems = new HashMap<String, String>();
                Oauth2.extractJsonObjects(responseItems, decodedBody);
                if (responseItems != null && !responseItems.isEmpty()) {
                    IdToken idtokenInfo = new IdToken();
                    idtokenInfo.mSubject = responseItems.get("sub");
                    idtokenInfo.mTenantId = responseItems.get("tid");
                    idtokenInfo.mUpn = responseItems.get("upn");
                    idtokenInfo.mEmail = responseItems.get("email");
                    idtokenInfo.mGivenName = responseItems.get("given_name");
                    idtokenInfo.mFamilyName = responseItems.get("family_name");
                    idtokenInfo.mIdentityProvider = responseItems.get("idp");
                    idtokenInfo.mObjectId = responseItems.get("oid");
                    String expiration = responseItems.get("pwd_exp");
                    if (!StringExtensions.IsNullOrBlank(expiration)) {
                        idtokenInfo.mPasswordExpiration = Long.parseLong(expiration);
                    }
                    idtokenInfo.mPasswordChangeUrl = responseItems.get("pwd_url");
                    Logger.v(TAG, "IdToken is extracted from token response");
                    return idtokenInfo;
                }
            }
        }
        catch (Exception ex) {
            Logger.e(TAG, "Error in parsing user id token", null, ADALError.IDTOKEN_PARSING_FAILURE, ex);
        }
        return null;
    }

    private static void extractJsonObjects(HashMap<String, String> responseItems, String jsonStr) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonStr);
        Iterator i = jsonObject.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            responseItems.put(key, jsonObject.getString(key));
        }
    }

    public AuthenticationResult refreshToken(String refreshToken) throws Exception {
        String requestMessage = null;
        if (this.mWebRequestHandler == null) {
            Logger.v(TAG, "Web request is not set correctly");
            throw new IllegalArgumentException("webRequestHandler");
        }
        try {
            requestMessage = this.buildRefreshTokenRequestMessage(refreshToken);
        }
        catch (UnsupportedEncodingException encoding) {
            Logger.e(TAG, encoding.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, encoding);
            return null;
        }
        HashMap<String, String> headers = this.getRequestHeaders();
        headers.put("x-ms-PKeyAuth", "1.0");
        return this.postMessage(requestMessage, headers);
    }

    public AuthenticationResult getToken(String authorizationUrl) throws Exception {
        if (StringExtensions.IsNullOrBlank(authorizationUrl)) {
            throw new IllegalArgumentException("authorizationUrl");
        }
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(authorizationUrl);
        String encodedState = parameters.get("state");
        String state = Oauth2.decodeProtocolState(encodedState);
        if (!StringExtensions.IsNullOrBlank(state)) {
            Uri stateUri = Uri.parse((String)("http://state/path?" + state));
            String authorizationUri = stateUri.getQueryParameter("a");
            String resource = stateUri.getQueryParameter("r");
            if (!StringExtensions.IsNullOrBlank(authorizationUri) && !StringExtensions.IsNullOrBlank(resource) && resource.equalsIgnoreCase(this.mRequest.getResource())) {
                AuthenticationResult result = Oauth2.processUIResponseParams(parameters);
                if (result != null && !result.getCode().isEmpty()) {
                    return this.getTokenForCode(result.getCode());
                }
                return result;
            }
            throw new AuthenticationException(ADALError.AUTH_FAILED_BAD_STATE);
        }
        throw new AuthenticationException(ADALError.AUTH_FAILED_NO_STATE);
    }

    public AuthenticationResult getTokenForCode(String code) throws Exception {
        String requestMessage = null;
        if (this.mWebRequestHandler == null) {
            throw new IllegalArgumentException("webRequestHandler");
        }
        try {
            requestMessage = this.buildTokenRequestMessage(code);
        }
        catch (UnsupportedEncodingException encoding) {
            Logger.e(TAG, encoding.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, encoding);
            return null;
        }
        HashMap<String, String> headers = this.getRequestHeaders();
        return this.postMessage(requestMessage, headers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthenticationResult postMessage(String requestMessage, HashMap<String, String> headers) throws Exception {
        URL authority = null;
        AuthenticationResult result = null;
        authority = StringExtensions.getUrl(this.getTokenEndpoint());
        if (authority == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL);
        }
        try {
            this.mWebRequestHandler.setRequestCorrelationId(this.mRequest.getCorrelationId());
            ClientMetrics.INSTANCE.beginClientMetricsRecord(authority, this.mRequest.getCorrelationId(), headers);
            HttpWebResponse response = this.mWebRequestHandler.sendPost(authority, headers, requestMessage.getBytes("UTF_8"), "application/x-www-form-urlencoded");
            if (response.getStatusCode() == 401) {
                if (response.getResponseHeaders() != null && response.getResponseHeaders().containsKey("WWW-Authenticate")) {
                    String challangeHeader = response.getResponseHeaders().get("WWW-Authenticate").get(0);
                    Logger.v(TAG, "Device certificate challange request:" + challangeHeader);
                    if (StringExtensions.IsNullOrBlank(challangeHeader)) throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Challange header is empty");
                    if (StringExtensions.hasPrefixInHeader(challangeHeader, "PKeyAuth")) {
                        Logger.v(TAG, "Challange is related to device certificate");
                        ChallangeResponseBuilder certHandler = new ChallangeResponseBuilder(this.mJWSBuilder);
                        Logger.v(TAG, "Processing device challange");
                        ChallangeResponseBuilder.ChallangeResponse challangeResponse = certHandler.getChallangeResponseFromHeader(challangeHeader, authority.toString());
                        headers.put("Authorization", challangeResponse.mAuthorizationHeaderValue);
                        Logger.v(TAG, "Sending request with challenge response");
                        response = this.mWebRequestHandler.sendPost(authority, headers, requestMessage.getBytes("UTF_8"), "application/x-www-form-urlencoded");
                    }
                } else {
                    Logger.v(TAG, "401 http status code is returned without authorization header");
                }
            }
            if (response.getBody() != null) {
                Logger.v(TAG, "Token request does not have exception");
                result = this.processTokenResponse(response);
                ClientMetrics.INSTANCE.setLastError(null);
            }
            if (result == null) {
                String errMessage = null;
                byte[] message = response.getBody();
                errMessage = message != null ? new String(message) : "Status code:" + String.valueOf(response.getStatusCode());
                Logger.v(TAG, "Server error message:" + errMessage);
                if (response.getResponseException() == null) return result;
                throw response.getResponseException();
            }
            ClientMetrics.INSTANCE.setLastErrorCodes(result.getErrorCodes());
            return result;
        }
        catch (IllegalArgumentException e) {
            ClientMetrics.INSTANCE.setLastError(null);
            Logger.e(TAG, e.getMessage(), "", ADALError.ARGUMENT_EXCEPTION, e);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            ClientMetrics.INSTANCE.setLastError(null);
            Logger.e(TAG, e.getMessage(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
            throw e;
        }
        catch (Exception e) {
            ClientMetrics.INSTANCE.setLastError(null);
            Logger.e(TAG, e.getMessage(), "", ADALError.SERVER_ERROR, e);
            throw e;
        }
        finally {
            ClientMetrics.INSTANCE.endClientMetricsRecord("token", this.mRequest.getCorrelationId());
        }
    }

    public static String decodeProtocolState(String encodedState) {
        if (!StringExtensions.IsNullOrBlank(encodedState)) {
            byte[] stateBytes = Base64.decode((String)encodedState, (int)9);
            return new String(stateBytes);
        }
        return null;
    }

    public String encodeProtocolState() {
        String state = String.format("a=%s&r=%s", this.mRequest.getAuthority(), this.mRequest.getResource());
        return Base64.encodeToString((byte[])state.getBytes(), (int)9);
    }

    private HashMap<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return headers;
    }

    private AuthenticationResult processTokenResponse(HttpWebResponse webResponse) {
        List<String> listOfHeaders;
        AuthenticationResult result = new AuthenticationResult();
        HashMap<String, String> responseItems = new HashMap<String, String>();
        String correlationIdInHeader = null;
        if (webResponse.getResponseHeaders() != null && webResponse.getResponseHeaders().containsKey("client-request-id") && (listOfHeaders = webResponse.getResponseHeaders().get("client-request-id")) != null && listOfHeaders.size() > 0) {
            correlationIdInHeader = listOfHeaders.get(0);
        }
        if (webResponse.getBody() != null && webResponse.getBody().length > 0) {
            try {
                String jsonStr = new String(webResponse.getBody());
                Oauth2.extractJsonObjects(responseItems, jsonStr);
                result = Oauth2.processUIResponseParams(responseItems);
            }
            catch (Exception ex) {
                Logger.e(TAG, ex.getMessage(), "", ADALError.SERVER_INVALID_JSON_RESPONSE, ex);
                result = new AuthenticationResult(JSON_PARSING_ERROR, ex.getMessage(), null);
            }
        } else {
            String errMessage = null;
            byte[] message = webResponse.getBody();
            errMessage = message != null ? new String(message) : "Status code:" + String.valueOf(webResponse.getStatusCode());
            Logger.v(TAG, "Server error message:" + errMessage);
            result = new AuthenticationResult(String.valueOf(webResponse.getStatusCode()), errMessage, null);
        }
        if (correlationIdInHeader != null && !correlationIdInHeader.isEmpty()) {
            try {
                UUID correlation = UUID.fromString(correlationIdInHeader);
                if (!correlation.equals(this.mRequest.getCorrelationId())) {
                    Logger.w(TAG, "CorrelationId is not matching", "", ADALError.CORRELATION_ID_NOT_MATCHING_REQUEST_RESPONSE);
                }
                Logger.v(TAG, "Response correlationId:" + correlationIdInHeader);
            }
            catch (Exception ex) {
                Logger.e(TAG, "Wrong format of the correlation ID:" + correlationIdInHeader, "", ADALError.CORRELATION_ID_FORMAT, ex);
            }
        }
        return result;
    }
}

