/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.BasicWebViewClient;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.R;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

@SuppressLint(value={"InflateParams", "SetJavaScriptEnabled", "ClickableViewAccessibility"})
class AuthenticationDialog {
    protected static final String TAG = "AuthenticationDialog";
    private Context mContext;
    private AuthenticationContext mAuthContext;
    private AuthenticationRequest mRequest;
    private Handler mHandlerInView;
    private Dialog mDialog;

    public AuthenticationDialog(Handler handler, Context context, AuthenticationContext authCtx, AuthenticationRequest request) {
        this.mHandlerInView = handler;
        this.mContext = context;
        this.mAuthContext = authCtx;
        this.mRequest = request;
    }

    public void show() {
        this.mHandlerInView.post(new Runnable(){

            @Override
            public void run() {
                LayoutInflater inflater = (LayoutInflater)AuthenticationDialog.this.mContext.getSystemService("layout_inflater");
                AlertDialog.Builder builder = new AlertDialog.Builder(AuthenticationDialog.this.mContext);
                View webviewInDialog = inflater.inflate(R.layout.dialog_authentication, null);
                final WebView webview = (WebView)webviewInDialog.findViewById(R.id.com_microsoft_aad_adal_webView1);
                if (webview == null) {
                    Logger.e(AuthenticationDialog.TAG, "Expected resource name for webview is com_microsoft_aad_adal_webView1. It is not in your layout file", "", ADALError.DEVELOPER_DIALOG_LAYOUT_INVALID);
                    Intent resultIntent = new Intent();
                    resultIntent.putExtra("com.microsoft.aad.adal:RequestId", AuthenticationDialog.this.mRequest.getRequestId());
                    AuthenticationDialog.this.mAuthContext.onActivityResult(1001, 2001, resultIntent);
                    if (AuthenticationDialog.this.mHandlerInView != null) {
                        AuthenticationDialog.this.mHandlerInView.post(new Runnable(){

                            @Override
                            public void run() {
                                if (AuthenticationDialog.this.mDialog != null && AuthenticationDialog.this.mDialog.isShowing()) {
                                    AuthenticationDialog.this.mDialog.dismiss();
                                }
                            }
                        });
                    }
                    return;
                }
                webview.getSettings().setJavaScriptEnabled(true);
                webview.requestFocus(130);
                webview.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent event) {
                        int action = event.getAction();
                        if (!(action != 0 && action != 1 || view.hasFocus())) {
                            view.requestFocus();
                        }
                        return false;
                    }
                });
                webview.getSettings().setLoadWithOverviewMode(true);
                webview.getSettings().setDomStorageEnabled(true);
                webview.getSettings().setUseWideViewPort(true);
                webview.getSettings().setBuiltInZoomControls(true);
                try {
                    Oauth2 oauth = new Oauth2(AuthenticationDialog.this.mRequest);
                    final String startUrl = oauth.getCodeRequestUrl();
                    String stopRedirect = AuthenticationDialog.this.mRequest.getRedirectUri();
                    webview.setWebViewClient((WebViewClient)new DialogWebViewClient(stopRedirect, 1001, AuthenticationDialog.this.mRequest));
                    webview.post(new Runnable(){

                        @Override
                        public void run() {
                            webview.loadUrl("about:blank");
                            webview.loadUrl(startUrl);
                        }
                    });
                }
                catch (UnsupportedEncodingException e) {
                    Logger.e(AuthenticationDialog.TAG, "Encoding error", "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
                }
                builder.setView(webviewInDialog).setCancelable(true);
                builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        Intent resultIntent = new Intent();
                        resultIntent.putExtra("com.microsoft.aad.adal:RequestId", AuthenticationDialog.this.mRequest.getRequestId());
                        AuthenticationDialog.this.mAuthContext.onActivityResult(1001, 2001, resultIntent);
                        if (AuthenticationDialog.this.mHandlerInView != null) {
                            AuthenticationDialog.this.mHandlerInView.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (AuthenticationDialog.this.mDialog != null && AuthenticationDialog.this.mDialog.isShowing()) {
                                        AuthenticationDialog.this.mDialog.dismiss();
                                    }
                                }
                            });
                        }
                    }
                });
                AuthenticationDialog.this.mDialog = (Dialog)builder.create();
                AuthenticationDialog.this.mDialog.show();
            }
        });
    }

    class DialogWebViewClient
    extends BasicWebViewClient {
        public DialogWebViewClient(String stopRedirect, int browserFlow, AuthenticationRequest request) {
            super(stopRedirect, browserFlow, request);
        }

        @Override
        public void showSpinner(final boolean status) {
            if (AuthenticationDialog.this.mHandlerInView != null) {
                AuthenticationDialog.this.mHandlerInView.post(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBar progressBar;
                        if (AuthenticationDialog.this.mDialog != null && AuthenticationDialog.this.mDialog.isShowing() && (progressBar = (ProgressBar)AuthenticationDialog.this.mDialog.findViewById(R.id.com_microsoft_aad_adal_progressBar)) != null) {
                            int showFlag = status ? 0 : 4;
                            progressBar.setVisibility(showFlag);
                        }
                    }
                });
            }
        }

        @Override
        public void sendResponse(int returnCode, Intent responseIntent) {
            AuthenticationDialog.this.mAuthContext.onActivityResult(1001, returnCode, responseIntent);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.toLowerCase(Locale.US).startsWith(this.mRedirect.toLowerCase(Locale.US))) {
                Intent resultIntent = new Intent();
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", url);
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mRequest);
                resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mRequest.getRequestId());
                this.sendResponse(2003, resultIntent);
                view.stopLoading();
                AuthenticationDialog.this.mDialog.dismiss();
                return true;
            }
            if (url.startsWith("browser://")) {
                Logger.v(AuthenticationDialog.TAG, "It is an external website request");
                this.openLinkInBrowserFromDialog(url);
                view.stopLoading();
                return true;
            }
            return false;
        }

        private void openLinkInBrowserFromDialog(final String url) {
            if (AuthenticationDialog.this.mHandlerInView != null) {
                AuthenticationDialog.this.mHandlerInView.post(new Runnable(){

                    @Override
                    public void run() {
                        String link = url.replace("browser://", "https://");
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                        AuthenticationDialog.this.mContext.startActivity(intent);
                    }
                });
            }
        }
    }
}

